package com.bxm.report.service.media.impl;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.dao.media.ext.AdTicketPositionWeightMapperExt;
import com.bxm.report.model.common.CommonSearchDto;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.dto.media.InfoMediaMsgDto;
import com.bxm.report.model.dto.media.InfoPositionMsgDto;
import com.bxm.report.model.enums.RoleEnum;
import com.bxm.report.service.media.MediaPositionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**  
* @Title: MeidaPositionServiceImpl 
* @Description:  
* @author xavier  
* @date 2018年3月14日  
*/  
@Service
public class MediaPositionServiceImpl implements MediaPositionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionServiceImpl.class);

	@Autowired
	private AdTicketPositionWeightMapperExt mediaPostionWeightExt;

    @Override
    public List<InfoMediaMsgDto> findMediaByRole(User user, CommonSearchDto search) {
        if (getMJCode(user) != null) {
            // 普通媒介
            LOGGER.info("普通媒介查询媒体");
            return mediaPostionWeightExt.findMediaByRole(search, getMJCode(user));
        }
        return findMediaAll(search);
    }

    @Override
    public List<InfoMediaMsgDto> findMediaAll(CommonSearchDto search) {
        //todo  这个后面要改

        return mediaPostionWeightExt.findMediaAll(search);
    }

    @Override
    public List<InfoPositionMsgDto> findPositionAll(Map<String, Object> params) {
        return mediaPostionWeightExt.findPositionAll2(params);
    }

    private String getMJCode(User user) {
        List<String> codes = user.getRoleCodes();
        if (!codes.contains(RoleEnum.MJLEADER.getCode()) && codes.contains(RoleEnum.MJ.getCode())) {
            return user.getUserNameContainRole(RoleEnum.MJ.getCode());
        }
        return null;
    }

}
