package com.bxm.report.service.position.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.bxm.dao.position.PositionQualityFactorMapper;
import com.bxm.report.model.dao.position.PositionQualityFactor;
import com.bxm.report.model.dto.position.PositionQualityFactorDto;
import com.bxm.report.service.position.PositionQualityFactorService;
import com.bxm.util.DateUtil;

@Service
public class PositionQualityFactorServiceImpl implements PositionQualityFactorService {

    private static final Logger logger = Logger.getLogger(PositionQualityFactorServiceImpl.class);

    @Autowired
    private PositionQualityFactorMapper positionQualityFactorMapper;

    /**
     * 广告位ID-质量因子,map封装(特殊处理),限制查询
     */
    @Override
    public Map<String, String> queryPositionQualityFactorMap(PositionQualityFactorDto record) {
        if (record == null) {
            record = new PositionQualityFactorDto();
        }
        //防止前端不传时间
        if (StringUtils.isBlank(record.getImportTime())) {
            record.setImportTime(DateUtil.dateTo8String3(new Date()));
        }
        List<PositionQualityFactor> result = null;
        HashMap<String, String> factorMap = new HashMap<String, String>();
        try {
            //判断表里是否有数据
            long tableCount = positionQualityFactorMapper.selectAllCount(record);
            if (tableCount > 0) {
                //对应日期没有质量因子（质量因子为空），则取该日之前最近的天的质量因子,最大跨度30天
                long preCount = 0;
                long cycles = 0;
                String preImportTime = null;
                String importTime = null;
                do {
                    cycles++;
                    preCount = positionQualityFactorMapper.selectCountByImportTime(record);
                    //当前日期
                    importTime = record.getImportTime();
                    preImportTime = DateUtil
                            .dateTo8String3(DateUtil.increaseDate(DateUtil.convertStr2Date(importTime), -1));
                    //设置前一日
                    record.setImportTime(preImportTime);
                } while (preCount <= 0 && cycles <= 30);
                //查询数据
                record.setImportTime(importTime);
                result = positionQualityFactorMapper.selectList(record);
                if (!CollectionUtils.isEmpty(result)) {
                    result.forEach(positionQualityFactor -> {
                        factorMap.put(positionQualityFactor.getPositionId(), positionQualityFactor.getFactor());
                    });
                }
            }
        } catch (Exception e) {
            logger.error("查询时间范围内广告位质量因子出错" + e.getMessage(), e);
        }
        return factorMap;
    }
}
