package com.bxm.report.service.report;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */



import java.util.List;
import java.util.Map;

import com.bxm.report.model.dao.adticket.AdTicketTagConf;


/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/11 17:20
 */
public interface AdTicketTagConfService {

	/**
	 * 单个增加
	 * @return
	 */
	public Integer add(AdTicketTagConf conf);

	/**
	 * 批量增加
	 * @return
	 */
	public Integer addBatch(String tags, Long ticketId);

	/**
	 * 根据广告券id删除关联信息
	 * @param ticketId
	 * @return
	 */
	public Integer delete(Long ticketId);

	/**
	 * 根据广告券id查找所有关联信息
	 * @param ticketId
	 * @return
	 */
	public String findByTicketId(Long ticketId);

	/**
	 * Description: 根据一级类别标签查询所属下的券ID集合
	 * JDK version used: <JDK1.8>
	 * Author： hxpeng
	 * Create Date： 2018/7/25 14:51
	 */
	List<Long> findTicketIdsByOneLevelTagCode(Integer oneLevelTagCode);

	/**
	 * Description: 根据券ID集合查询一级标签名称集合， key:券ID, value:一级标签名称
	 * JDK version used: <JDK1.8>
	 * Author： hxpeng
	 * Create Date： 2018/7/25 14:29
	 */
	Map<Long, String> findClassifyTagName(List<Long> ticketIds);

	/**
	 * Description: 过滤券ID集合 中 属于 某一级标签下的的券ID
	 * JDK version used: <JDK1.8>
	 * Author： hxpeng
	 * Create Date： 2018/8/27 16:09
	 */
	List<Long> checkTicketBelongOneLevelTagCode(List<Long> ticketIds, Integer oneLevelTagCode);

}
