/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.report.service.report;

import com.bxm.datapark.facade.Page;
import com.bxm.report.model.base.PaginationTemp;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.vo.activity.ActivityVo;
import com.bxm.report.model.vo.app.*;
import com.bxm.report.model.vo.appcount.AppCountVo;

import java.io.IOException;
import java.util.List;

/**
 * 开发者报表，服务接口层
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.report.IAppReportService.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:29:00
 * @modifier 阿导
 * @updated 2018-02-27 11:29:00
 */
public interface IAppReportService {

    /**
     * 分页查询开发者日报
     * 
     * @param datetime
     * @param keyword
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    Page<AppCountVo> getAppCount(String datetime, String keyword, User user, Integer pageSize, Integer pageNum,
                                 String sortName, String sortType, String onlineStart,
                                 String onlineEnd) throws IOException;

    /**
     * 不分页查询开发者日报
     * 
     * @param datetime
     * @param keyword
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    List<AppCountVo> getAppCountExport(String datetime, String keyword, User user, String sortName, String sortType,
                                       String onlineStart, String onlineEnd) throws IOException;

    /**
     * 分页查询开发者子链接
     * 
     * @param datetime
     * @param keyword
     * @param appKey
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    Page<AppBusinessVo> findAppBusinessCount(String datetime, String keyword, String appKey, Integer pageSize,
                                             Integer pageNum, String sortName, String sortType, String onlineStart,
                                             String onlineEnd) throws Exception;

    List<AppBusinessVo> findAppBusinessCountExport(String datetime, String keyword, String appKey, String sortName,
                                                   String sortType, String onlineStart,
                                                   String onlineEnd) throws IOException;

    List<AppByDateVo> findAppCountDate(String appKey, String startTime, String endTime, String sortName,
                                       String sortType) throws IOException;

    List<AppBusinessByDateVo> findAppBusinessCountByDate(String appKey, String business, String startTime,
                                                         String endTime, String sortName,
                                                         String sortType) throws IOException;

    Page<AppTicketVo> findAppTicketCount(String datetime, String appKey, Integer scene, String keyword,
                                         Integer pageSize, Integer pageNum, String sortName,
                                         String sortType) throws IOException;

    List<AppTicketVo> findAppTicketCount(String datetime, String appKey, Integer scene, String json) throws IOException;

    List<AppTicketDateVo> findAppTicketCountDate(String startTime, String endTime, String appkey, Long certificateid,
                                                 String sortName, String sortType) throws IOException;

    Page<AppBusinessTicketVo> findAppBusinessTicketCount(String datetime, String appKey, String business, Integer scene,
                                                         String keyword, Integer pageSize, Integer pageNum,
                                                         String sortName, String sortType,
                                                         Integer ticketType) throws IOException;

    /**
     * 加载所有数据后在内存分页
     * @param datetime
     * @param appKey
     * @param business
     * @param scene
     * @param keyword
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @param ticketType
     * @return
     * @throws IOException
     */
    Page<AppBusinessTicketVo> findAppBusinessTicketCountPageAfterLoadAll(String datetime, String appKey, String business,
                                                                Integer scene, String keyword, Integer pageSize,
                                                                Integer pageNum, String sortName, String sortType,
                                                                Integer ticketType) throws IOException;

    List<AppBusinessTicketVo> findAppBusinessTicketExport(String datetime, String appKey, String business,
                                                          Integer scene, String json,
                                                          Integer ticketType) throws IOException;

    /**
     * 查询开发者子渠道活动
     * 
     * @param json
     * @param datetime
     * @param appKey
     * @param business
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    PaginationTemp<ActivityVo> findAppBusinessActivity(String json, String datetime, String appKey, String business,
                                           String activityType, String activityPlanner, Integer pageSize, Integer pageNum,
                                           String sortName, String sortType) throws IOException;

    /**
     * 导出开发者子渠道活动
     * 
     * @param datetime
     * @param appKey
     * @param business
     * @param keyword
     */
    List<ActivityVo> appBusinessActivityExport(String datetime, String appKey, String business,
                                               String keyword) throws IOException;

    int updateIconOrClickPv(int iconPv, int iconClickPv, String dateTime, String business,
                            String appKey) throws Exception;

    // 开发者日报根据权限查看
    List<AppCountVo> findAppCountSumByDate(String startTime, String endTime, String keyword, User user, String sortName,
                                           String sortType) throws Exception;

    List<AppCountVo> appCountSumByDateExport(String startTime, String endTime, String keyword,
                                             User user) throws Exception;

    /**
     * 开发者日报-子链接-广告券-按日 报表
     * 
     * @param startTime
     * @param endTime
     * @param appkey
     * @param certificateid
     * @param sortName
     * @param sortType
     * @return
     * @throws IOException
     */
    List<AppBusinessTicketDateVo> findAppBusinessTicketDateReport(String startTime, String endTime, String appkey,
                                                                  Long certificateid, String sortName, String sortType,
                                                                  String business) throws IOException;
}
