/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.report.service.report;



import com.bxm.datapark.facade.Page;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;

import java.io.IOException;
import java.util.List;

/**
 * 广告券日报，服务接口层
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.report.ITicketReportService.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-02-27 11:28:00
 */
public interface ITicketReportService {

    Page<TicketCountVo> findTicketCount(String datetime, Integer scene, String keyword, Integer pageNum, Integer pageSize, String sortName, String sortType, String ae, Integer ticketType, Integer tagCode) throws IOException;

    List<TicketCountVo> findTicketCountExport(String datetime, Integer scene, String keyword, String ae, Integer ticketType, Integer tagCode) throws IOException;

    Page<TicketAppVo> findTicketAppCount(String datetime, Long certificateid, String keyword, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException;
    List<TicketAppVo> findTicketAppCountExport(String datetime, Long certificateid, String keyword) throws IOException;

    Page<TicketAppBusinessVo> findTicketAppBusinessCount(String datetime, Long certificateid, String String, String keyword, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException;

    List<TicketAppBusinessVo> findTicketAppBusinessCountExport(String datetime, Long certificateid, String appKey, String keyword) throws IOException;

    List<TicketDateVo> findTicketCountDate(String startTime, String endTime, Long certificateid, String sortName, String sortType) throws IOException;
}
