package com.bxm.report.service.report.impl;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.dao.adkeeper.AdTicketTagConfMapper;
import com.bxm.dao.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.report.model.constant.TicketConstant;
import com.bxm.report.model.dao.adticket.AdTicketTagConf;
import com.bxm.report.model.dto.adticket.AdTicketTagConfDO;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import com.bxm.report.service.report.AdTicketTagConfService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <h3>标签</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/11 17:21
 */
@Service
public class AdTicketTagConfServiceImpl implements AdTicketTagConfService {

    private final static Logger logger = LoggerFactory.getLogger(AdTicketTagConfServiceImpl.class);

	@Autowired
	private AdTicketTagConfMapper adTicketTagConfMapper;

	@Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;

	@Override
	public Integer add(AdTicketTagConf conf) {
		return 	adTicketTagConfMapper.insert(conf);
	}

	@Override
	public Integer addBatch(String tags, Long ticketId) {
		if(tags == null){
			return null;
		}
		String[] tagsArray = tags.split(",");
		List<String> list = Arrays.asList(tagsArray);
		Integer result = adTicketTagConfMapper.addBatch(list,ticketId);
		return result;
	}

	/**
	 * 根据广告券id删除关联信息
	 *
	 * @param ticketId
	 * @return
	 */
	@Override
	public Integer delete(Long ticketId) {
		return adTicketTagConfMapper.deleteByTicketId(ticketId);
	}

	/**
	 * 根据广告券id查找所有关联信息
	 * @param ticketId
	 * @return
	 */
	@Override
	public String findByTicketId(Long ticketId) {
		String ads = "";
		List<AdTicketTagConf> adTagConfList = adTicketTagConfMapper.findByTicketId(ticketId);
		if(adTagConfList.isEmpty()){
			return null;
		}
		for (int i=0;i<adTagConfList.size();i++) {
			if(i==adTagConfList.size()-1){
				ads+=adTagConfList.get(i).getTagCode();
			}else {
				ads+=adTagConfList.get(i).getTagCode()+",";
			}
		}
		return ads;
	}

    @Override
    public List<Long> findTicketIdsByOneLevelTagCode(Integer oneLevelTagCode) {
	    if (null == oneLevelTagCode){
	        return Collections.emptyList();
        }
        List<TblAdTagVo> tblAdTagVos = tblAdPostionTagMapperExt.findTagsByOneLevelCode(oneLevelTagCode);
        if (CollectionUtils.isEmpty(tblAdTagVos)) {
            logger.warn(">>>>>>>>>>no tag belong :", oneLevelTagCode);
            return Collections.emptyList();
        }
        // 获取一级标签下面的Code
        List<Integer> codes = tblAdTagVos.stream().map(TblAdTagVo::getCode).collect(Collectors.toList());
        return adTicketTagConfMapper.findTicketIds(codes);
    }

    @Override
    public Map<Long, String> findClassifyTagName(List<Long> ticketIds) {
	    if (CollectionUtils.isEmpty(ticketIds)){
	        return Collections.emptyMap();
        }
        List<AdTicketTagConfDO> adTicketTagConfDOS = adTicketTagConfMapper.findTicketBelongCodeName(ticketIds, TicketConstant.TicketTag.TAG_TYPE_CLASSIFY);
        Map<Long, String> tagNameMap = new HashMap<>(adTicketTagConfDOS.size());
        for (AdTicketTagConfDO adTicketTagConfDO : adTicketTagConfDOS) {
            String fullNameStr = adTicketTagConfDO.getFullNameStr();
            if (StringUtils.isBlank(fullNameStr)){
                continue;
            }
            Integer indexOf = fullNameStr.indexOf(".");
            String tagName;
            if (indexOf < 0){
                tagName = fullNameStr;
            }else{
                tagName = fullNameStr.substring(0, indexOf);
            }
            String name = tagNameMap.get(adTicketTagConfDO.getTicketId());
            if (StringUtils.isBlank(name)) {
                tagNameMap.put(adTicketTagConfDO.getTicketId(), tagName);
            } else {
                tagNameMap.put(adTicketTagConfDO.getTicketId(), StringUtils.join(name,",",tagName));
            }
        }
        return tagNameMap;
    }

    @Override
    public List<Long> checkTicketBelongOneLevelTagCode(List<Long> ticketIds, Integer oneLevelTagCode) {
        if (CollectionUtils.isEmpty(ticketIds) || null == oneLevelTagCode) {
            return Collections.emptyList();
        }
        List<TblAdTagVo> tblAdTagVos = tblAdPostionTagMapperExt.findTagsByOneLevelCode(oneLevelTagCode);
        if (CollectionUtils.isEmpty(tblAdTagVos)) {
            logger.warn(">>>>>>>>>>no tag belong :", oneLevelTagCode);
            return Collections.emptyList();
        }
	    // 获取一级标签下面的Code
        List<Integer> codes = tblAdTagVos.stream().map(TblAdTagVo::getCode).collect(Collectors.toList());
        // 过滤券ID集合 是否在 某一个一级标签下
        return adTicketTagConfMapper.checkTicketBelongOneLevelCode(ticketIds, codes);
    }
}
