/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.report.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.dao.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.dao.adkeeper.AdTicketMapper;
import com.bxm.dao.adkeeper.AdTicketOcpcMapper;
import com.bxm.dao.adkeeper.TblActivityMapper;
import com.bxm.dao.adkeeper.TblAdIconClickPvUpdateMapper;
import com.bxm.dao.adkeeper.ext.TblAdIconClickPvUpdateMapperExt;
import com.bxm.datapark.facade.Page;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dto.CollectionName;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.log.facade.service.LogsService;
import com.bxm.report.facade.app.AppEntranceFacadeIntegration;
import com.bxm.report.facade.datapark.DataparkAppPullerIntegration;
import com.bxm.report.model.base.PaginationTemp;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.model.constant.ReportConstant;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dao.activity.ActivityWithBLOBs;
import com.bxm.report.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dao.adticket.AdTicketOcpcConf;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.model.dao.appcount.AppCount;
import com.bxm.report.model.dao.icon.TblAdIconClickPvUpdate;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.model.dto.position.PositionQualityFactorDto;
import com.bxm.report.model.enums.RoleEnum;
import com.bxm.report.model.vo.activity.ActivityVo;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.app.*;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.report.service.adkeeper.InfoAppMsgService;
import com.bxm.report.service.position.PositionQualityFactorService;
import com.bxm.report.service.report.IAppReportService;
import com.bxm.report.service.report.ReportCommonService;
import com.bxm.report.service.utils.*;
import com.bxm.util.StringUtil;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Pattern;

/**
 * 开发者报表，服务层实现
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.report.impl.AppReportServiceImpl.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:33:00
 * @modifier 阿导
 * @updated 2018-02-27 11:33:00
 */
@Service
public class AppReportServiceImpl implements IAppReportService {

    Logger                                  logger  = LoggerFactory.getLogger(AppReportServiceImpl.class);

    @Autowired
    private AdPositionService               adPositionService;
    @Autowired
    private InfoAppMsgService               infoAppMsgService;
    @Autowired
    private DataparkAppPullerIntegration    dataparkAppPullerIntegration;
    @Autowired
    private InfoActivityCertificateService  infoActivityCertificateService;
    @Autowired
    private ReportCommonService             reportCommonService;
    @Autowired
    //private ActivityMapper                  activityMapper;
    private TblActivityMapper                 activityMapper;

    @Autowired
    private TblAdIconClickPvUpdateMapper    tblAdIconClickPvUpdateMapper;
    @Autowired
    private TblAdIconClickPvUpdateMapperExt tblAdIconClickPvUpdateMapperExt;
    @Autowired
    private DictionariesService             dictionariesService;
    @Autowired
    private AdTicketMapper                  adTicketMapper;
    @Autowired
    AdTicketOcpcMapper                      adTicketOcpcMapper;
    @Autowired
    AdTicketFlowPackageMapper               adTicketFlowPackageMapper;
    @Autowired
    private LogsService                     logsService;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher                         fetcher;

    private Pattern                         pattern = Pattern.compile("\"times\"\\s*:\\s*\"(\\d{1,2}-\\d{1,2}-\\d+(\\s*,\\s*\\d{1,2}-\\d{1,2}-\\d+)*)\"");

    @Autowired
    private Mapper                          mapper;

    @Resource
    private AppEntranceFacadeIntegration    appEntranceFacadeIntegration;

    //广告位质量因子service
    @Autowired
    private PositionQualityFactorService positionQualityFactorService;

    @Override
    public Page<AppCountVo> getAppCount(String datetime, String keyword, User user, Integer pageSize, Integer pageNum,
                                        String sortName, String sortType, String onlineStart,
                                        String onlineEnd) throws IOException {
        // 查询当前用户的角色如果只为BD则只能看到自己的媒体信息,媒介只能看到自己对应媒体 但要排除leader
        String roleCode = getRoleCode(user);
        // 1、根据关键字查询出开发者的信息
        List<InfoAppMsg> infoAppMsgs = new ArrayList<>();
        // 2、声明一个集合用于封装appKeys
        List<String> appKeysList = Lists.newArrayList();
        // 3、把所有查询出的所有appKey添加至appKeys,并存入map集合
        Map<String, InfoAppMsg> infoAppMsgMap = Maps.newHashMap();
        StringBuffer appKeys = new StringBuffer();

        infoAppMsgs = infoAppMsgService.findAllAppkeys(keyword, roleCode);
        if (CollectionUtils.isNotEmpty(infoAppMsgs)) {
            infoAppMsgs.forEach(infoAppMsg -> {
                appKeysList.add(infoAppMsg.getAppkey());
                infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                appKeys.append(infoAppMsg.getAppkey()).append(",");
            });
        } else {
            return new Page<AppCountVo>();
        }

        if (appKeysList.size() == 0) {
            return new Page<AppCountVo>();
        }
        // 4、把解析过后的appKeys赋值给appKeysJson
        Map<String, String> appKeyMap = adPositionService.findAppKeysByOnline(appKeysList, onlineStart, onlineEnd);

        if (appKeyMap == null || appKeyMap.size() == 0) {
            return new Page<AppCountVo>();
        }
        List<String> appKeysListTemp = new ArrayList<>();
        appKeysList.forEach(appKey -> {
            if (appKeyMap.containsKey(appKey)) {
                appKeysListTemp.add(appKey);
            }
        });

        // 5、调用datapark
        Page<AppCount> appCountPage = dataparkAppPullerIntegration.getAppCountPage(datetime, pageSize, pageNum,
                                                                                   sortName, sortType,
                                                                                   JSON.toJSONString(appKeysListTemp));
        List<AppCount> listTemp = appCountPage.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接appkey
            getAppKeys(keyword, infoAppMsgMap, appKeysList, appKeys, listTemp);
        } else {
            return new Page<AppCountVo>();
        }
        // 6、查询开发者子链接数
        Map<String, Integer> businessNumberMaps = adPositionService.getBusinessNumberByAppKeys(appKeysList);
        // 7、整合开发者信息
        List<AppCountVo> list = new ArrayList<AppCountVo>();
        // 8、把相关信息复制到新实例化的结果集
        Page<AppCountVo> appCountPageRs = new Page<AppCountVo>();
        mapper.map(appCountPage, appCountPageRs);
        Integer business = 0;
        if (CollectionUtils.isNotEmpty(listTemp)) {
            for (AppCount appCount : listTemp) {
                // 实例化
                AppCountVo appCountVo = new AppCountVo();
                // 复制属性
                mapper.map(appCount, appCountVo);
                Double perclickPv = appCount.getPerClickPv() == null ? 0.0 : appCount.getPerClickPv();
                appCountVo.setPerClickPv(perclickPv);
                Double perclickPvChange = appCount.getPerClickPvChange() == null ? 0.0 : appCount.getPerClickPvChange();
                appCountVo.setPerClickPvChange(perclickPvChange == 0.0 ? "-" : perclickPvChange + "%");
                // 获取开发者名称并存入对象
                String appName = infoAppMsgMap.getOrDefault(appCountVo.getAppKey(), new InfoAppMsg()).getAppname();
                appCountVo.setAppName(StringUtils.isNotEmpty(appName) ? appName : "");
                // 获取开发者子链接数并存入对象
                Integer businessNumber = businessNumberMaps.getOrDefault(appCountVo.getAppKey(),
                                                                         Integer.valueOf(ReportConstant.ZERO_S));
                appCountVo.setBusinessCount(businessNumber);
                if (appKeyMap.get(appCount.getAppKey()) == null) {
                    appCountVo.setOnlineTime("");
                } else {
                    appCountVo.setOnlineTime(appKeyMap.get(appCount.getAppKey()));
                }
                // 存入集合
                list.add(appCountVo);
                // 放入结果集
                business += businessNumber;
            }
            list.get(0).setBusinessCount(business);
            appCountPageRs.setList(list);
        }
        // 9、返回结果集
        return appCountPageRs;
    }

    @Override
    public List<AppCountVo> getAppCountExport(String datetime, String keyword, User user, String sortName,
                                              String sortType, String onlineStart,
                                              String onlineEnd) throws IOException {
        // 查询当前用户的角色如果只为BD则只能看到自己的媒体信息
        String roleCode = getRoleCode(user);
        // 1、根据关键字查询出开发者的信息
        List<InfoAppMsg> infoAppMsgs = new ArrayList<>();
        // 2、声明一个集合用于封装appKeys
        List<String> appKeysList = Lists.newArrayList();
        // 3、把所有查询出的所有appKey添加至appKeys,并存入map集合
        Map<String, InfoAppMsg> infoAppMsgMap = Maps.newHashMap();
        StringBuffer appKeys = new StringBuffer();
        infoAppMsgs = infoAppMsgService.findAllAppkeys(keyword, roleCode);
        if (CollectionUtils.isNotEmpty(infoAppMsgs)) {
            infoAppMsgs.forEach(infoAppMsg -> {
                appKeysList.add(infoAppMsg.getAppkey());
                infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                appKeys.append(infoAppMsg.getAppkey()).append(",");
            });
        } else {
            return Collections.emptyList();
        }

        if (CollectionUtils.isEmpty(appKeysList)) {
            return Collections.emptyList();
        }
        // 4、把解析过后的appKeys赋值给appKeysJson
        Map<String, String> appKeyMap = adPositionService.findAppKeysByOnline(appKeysList, onlineStart, onlineEnd);

        if (appKeyMap == null || appKeyMap.size() == 0) {
            return new ArrayList<AppCountVo>();
        }
        List<String> appKeysListTemp = new ArrayList<>();
        appKeysList.forEach(appKey -> {
            if (appKeyMap.containsKey(appKey)) {
                appKeysListTemp.add(appKey);
            }
        });

        // 4、调用datapark
        List<AppCount> appCountVos = dataparkAppPullerIntegration.getAppCountVos(datetime, sortName, sortType,
                                                                                 JSON.toJSONString(appKeysListTemp));
        if (CollectionUtils.isNotEmpty(appCountVos)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接appkey
            getAppKeys(keyword, infoAppMsgMap, appKeysList, appKeys, appCountVos);
        } else {
            return new ArrayList<AppCountVo>();
        }
        // 5、声明并实例化结果集
        List<AppCountVo> list = new ArrayList<>();
        // 6、把数据添加至新的集合
        copyList(appCountVos, list);
        // 7、查询开发者子链接数
        Map<String, Integer> businessNumberMaps = adPositionService.getBusinessNumberByAppKeys(appKeysList);
        /// 7、整合开发者信息
        if (CollectionUtils.isNotEmpty(list)) {
            for (AppCountVo appCountVo : list) {
                // 获取开发者名称并存入对象
                String appName = infoAppMsgMap.getOrDefault(appCountVo.getAppKey(), new InfoAppMsg()).getAppname();
                // 获取开发者子链接数并存入对象
                Integer businessNumber = businessNumberMaps.getOrDefault(appCountVo.getAppKey(),
                                                                         Integer.valueOf(ReportConstant.ZERO_S));
                appCountVo.setBusinessCount(businessNumber);
                appCountVo.setAppName(StringUtils.isNotEmpty(appName) ? appName : "");
            }
        }
        if (user.getRoleCodes().contains(RoleEnum.BD.getCode())
            && !user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode())) {
            for (AppCountVo aList : list) {
                aList.setMidPagePv(0);
                aList.setMidPvChange("");
                aList.setIndexPv(0);
                aList.setIndexPvChange("");
                aList.setIndexUv(0);
                aList.setIndexUvChange("");
                aList.setIncome(0.0);
                aList.setIncomeChange("");
                aList.setBxmIncome(0.0);
                aList.setBxmIncomeChange("");
                aList.setOpenPvAurp(0.0);
                aList.setOpenPvAurpChange("");
                aList.setUvAurp(0.0);
                aList.setUvAurpChange("");
                aList.setBxmAurp(0.0);
                aList.setBxmAurpChange("");
            }
            return list;
        }

        // 8、返回结果集
        return list;
    }

    private void getAppKeys(String keyword, Map<String, InfoAppMsg> infoAppMsgMap, List<String> appKeysList,
                            StringBuffer appKeys, List<AppCount> appCounts) {
        if (StringUtils.isEmpty(keyword)) {
            appCounts.forEach(appCount -> {
                appKeys.append(appCount.getAppKey()).append(",");
                appKeysList.add(appCount.getAppKey());
            });
            List<InfoAppMsg> infoAppByAppkeys = infoAppMsgService.findInfoAppByAppkeys(appKeys);
            if (CollectionUtils.isNotEmpty(infoAppByAppkeys)) {
                infoAppByAppkeys.forEach(infoAppMsg -> {
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                });
            }
        }
    }

    @Override
    public Page<AppBusinessVo> findAppBusinessCount(String datetime, String keyword, String appKey, Integer pageSize,
                                                    Integer pageNum, String sortName, String sortType,
                                                    String onlineStart, String onlineEnd) throws Exception {
        // 1、声明一个集合用于封装子链接
        List<String> businesses = Lists.newArrayList();
        StringBuffer sbBusinesses = new StringBuffer("");
        Map<String, String> businessMap = new HashMap<>();
        Map<String, AdpositionVo> adpositionVoMap = Maps.newHashMap();
        // 2、把所有查询出的所有子链接添加至businesses,并把对象添加至map集合
        if (StringUtils.isNotEmpty(keyword)) {
            // 3、根据关键字查询出子链接的信息
            List<AdpositionVo> adpositionVos = adPositionService.findBusinesses(appKey, keyword, onlineStart, onlineEnd);
            if (CollectionUtils.isNotEmpty(adpositionVos)) {
                // 处理信息
                dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
            } else {
                return new Page<AppBusinessVo>();
            }
        } else {
            // 通过appkey和上线时间查询business
            List<AppCountVo> appCountVos = adPositionService.findBusinessByAppkeyTime(appKey, onlineStart, onlineEnd);

            if (appCountVos == null || appCountVos.size() == 0) {
                return new Page<AppBusinessVo>();
            }
            appCountVos.forEach(appCountVo -> {
                businessMap.put("ad-" + appCountVo.getBusiness(), appCountVo.getOnlineTime());
            });
        }

        // 4、调用datapark
        Page<AppCount> appBusinessCountVoPage = dataparkAppPullerIntegration.getAppBusinessCountVoPage(datetime, appKey,
                                                                                                       pageSize,
                                                                                                       pageNum,
                                                                                                       sortName,
                                                                                                       sortType,
                                                                                                       JSON.toJSONString(businesses));
        // 查询前一天
        String preDate = DateParkUtil.getPreDate(datetime);
        Page<AppCount> appBusinessCountVoPagePre = dataparkAppPullerIntegration.getAppBusinessCountVoPage(preDate,
                                                                                                          appKey,
                                                                                                          pageSize,
                                                                                                          pageNum,
                                                                                                          sortName,
                                                                                                          sortType,
                                                                                                          JSON.toJSONString(businesses));
        // 5、把数据添加到新的结果集
        List<AppCount> listTemp = appBusinessCountVoPage.getList();
        // 将前一天的数据查询出来 便于计算涨幅
        List<AppCount> listPre = appBusinessCountVoPagePre.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接businesses
            getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, listTemp);
        } else {
            return new Page<AppBusinessVo>();
        }
        List<AppBusinessVo> list = new ArrayList<>();
        // 5、声明并实例化结果集
        Page<AppBusinessVo> appBusinessPageRs = new Page<>();
        // 6、把数据添加到新的结果集
        mapper.map(appBusinessCountVoPage, appBusinessPageRs);
        if (CollectionUtils.isNotEmpty(listTemp)) {
            //查询广告位质量因子
            PositionQualityFactorDto positionQualityFactorDto = new PositionQualityFactorDto();
            positionQualityFactorDto.setImportTime(datetime);
            Map<String,String> factorMap = positionQualityFactorService.queryPositionQualityFactorMap(positionQualityFactorDto);
            //
            for (AppCount appCount : listTemp) {
                // 实例化
                AppBusinessVo appBusinessVo = new AppBusinessVo();
                // 复制属性
                mapper.map(appCount, appBusinessVo);
                appBusinessVo.setLandingRateChange(appCount.getLandingRateChange() + "%");
                // 获取子链接名称并放入对象
                if (StringUtils.isNotEmpty(appCount.getBusiness())) {
                    String name = adpositionVoMap.getOrDefault(appCount.getBusiness().replaceAll("ad-", ""),
                                                               new AdpositionVo()).getName();
                    appBusinessVo.setBusinessName(name);
                }
                appBusinessVo.setOnlineTime(businessMap.get(appCount.getBusiness()));

                //设置质量因子
                if(StringUtils.isNotBlank(appBusinessVo.getAppKey()) && StringUtils.isNotBlank(appBusinessVo.getBusiness())){
                    String positionId = appBusinessVo.getAppKey() + "-" + appBusinessVo.getBusiness().replace("ad-", "");
                    appBusinessVo.setFactor(factorMap.get(positionId));
                }
                list.add(appBusinessVo);
            }
            appBusinessPageRs.setList(getUpdateList(listPre, list, datetime, appKey, appBusinessCountVoPage.getTotal(),
                                                    appBusinessCountVoPage.getSize()));

        }
        // 7、返回结果集

        return appBusinessPageRs;
    }

    @Override
    public List<AppBusinessVo> findAppBusinessCountExport(String datetime, String keyword, String appKey,
                                                          String sortName, String sortType, String onlineStart,
                                                          String onlineEnd) throws IOException {
        // 1、声明一个集合用于封装子链接
        List<String> businesses = Lists.newArrayList();
        StringBuffer sbBusinesses = new StringBuffer("");
        Map<String, AdpositionVo> adpositionVoMap = Maps.newHashMap();
        Map<String, String> businessMap = new HashMap<>();
        // 2、把所有查询出的所有子链接添加至businesses,并把对象添加至map集合
        if (StringUtils.isNotEmpty(keyword)) {
            // 3、根据关键字查询出子链接的信息
            List<AdpositionVo> adpositionVos = adPositionService.findBusinesses(appKey, keyword, onlineStart, onlineEnd);
            if (CollectionUtils.isNotEmpty(adpositionVos)) {
                // 处理信息
                dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
            } else {
                return Collections.emptyList();
            }
        } else {
            // 通过appkey和上线时间查询business
            List<AppCountVo> appCountVos = adPositionService.findBusinessByAppkeyTime(appKey, onlineStart, onlineEnd);

            if (appCountVos == null || appCountVos.size() == 0) {
                return Collections.emptyList();
            }
            appCountVos.forEach(appCountVo -> {
                businessMap.put("ad-" + appCountVo.getBusiness(), appCountVo.getOnlineTime());
            });
        }
        // 4、调用datapark
        List<AppCount> appBusinessCountVos = dataparkAppPullerIntegration.getAppBusinessCountVos(datetime, appKey,
                                                                                                 sortName, sortType,
                                                                                                 JSON.toJSONString(businesses));
        if (CollectionUtils.isNotEmpty(appBusinessCountVos)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接businesses
            getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, appBusinessCountVos);
        } else {
            return new ArrayList<AppBusinessVo>();
        }
        // 5、声明并实例化结果集
        List<AppBusinessVo> appBusinessList = new ArrayList<>();
        // 6、把数据添加到新的集合
        if (CollectionUtils.isNotEmpty(appBusinessCountVos)) {
            for (AppCount appCount : appBusinessCountVos) {
                AppBusinessVo appBusinessVo = new AppBusinessVo();
                mapper.map(appCount, appBusinessVo);
                appBusinessVo.setBusinessName(adpositionVoMap.getOrDefault(appBusinessVo.getBusiness(),
                                                                           new AdpositionVo()).getName());
                appBusinessVo.setOnlineTime(businessMap.get(appCount.getBusiness()));
                appBusinessVo.setPerClickPv(appCount.getPerClickPv());
                appBusinessVo.setPerClickPvChange(getPerChangeName(appCount));
                appBusinessVo.setEcpm(appCount.getEcpm());
                appBusinessVo.setEcpmChange(appCount.getEcpmChange());
                appBusinessVo.setmEcpm(appCount.getmEcpm());
                appBusinessVo.setmEcpmChange(appCount.getmEcpmChange());
                appBusinessList.add(appBusinessVo);
            }
        }
        // 9、返回结果集
        return appBusinessList;
    }

    private void dealBusiness(List<AdpositionVo> adpositionVos, List<String> businesses,
                              Map<String, AdpositionVo> adpositionVoMap, StringBuffer sbBusinesses) {
        adpositionVos.forEach(adpositionVo -> {
            businesses.add("ad-" + adpositionVo.getBusiness().replaceAll("ad-", ""));
            adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), adpositionVo);
            sbBusinesses.append(adpositionVo.getBusiness().replaceAll("ad-", "")).append(",");
        });
    }

    private void getBusinesses(String appKey, String keyword, Map<String, AdpositionVo> adpositionVoMap,
                               StringBuffer sbBusinesses, List<AppCount> appCounts) {
        if (StringUtils.isEmpty(keyword)) {
            appCounts.forEach(appCount -> {
                if (StringUtils.isNotEmpty(appCount.getBusiness())) {
                    sbBusinesses.append(appCount.getBusiness()).append(",");
                }
            });
            List<AdpositionVo> byBusinesses = adPositionService.findByBusinesses(appKey, sbBusinesses);
            if (CollectionUtils.isNotEmpty(byBusinesses)) {
                byBusinesses.forEach(adpositionVo -> {
                    adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), adpositionVo);
                });
            }
        }
    }

    private void copyList(List<AppCount> appBusinessCountVos, List<AppCountVo> appBusinessList) {
        if (CollectionUtils.isNotEmpty(appBusinessCountVos)) {
            for (AppCount appCount : appBusinessCountVos) {
                AppCountVo appCountVo = new AppCountVo();
                mapper.map(appCount, appCountVo);
                appBusinessList.add(appCountVo);
            }
        }
    }

    @Override
    public List<AppByDateVo> findAppCountDate(String appKey, String startTime, String endTime, String sortName,
                                              String sortType) throws IOException {

        // 1、封装条件
        List<AppCount> appDateVos = dataparkAppPullerIntegration.getAppDateVos(appKey, startTime, endTime, sortName,
                                                                               sortType);
        List<AppByDateVo> appDateList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(appDateVos)) {
            for (AppCount appCount : appDateVos) {
                AppByDateVo appByDate = new AppByDateVo();
                mapper.map(appCount, appByDate);
                Double perclickpv = appCount.getPerClickPv() == null ? 0.0 : appCount.getPerClickPv();
                appByDate.setPerClickPv(perclickpv);
                appByDate.setPerClickPvChange(getPerChangeName(appCount));
                appDateList.add(appByDate);
            }
        }
        // 4、返回结果集
        return appDateList;
    }

    @Override
    public List<AppBusinessByDateVo> findAppBusinessCountByDate(String appKey, String business, String startTime,
                                                                String endTime, String sortName,
                                                                String sortType) throws IOException {
        List<AppCount> appBusinessDateVos = dataparkAppPullerIntegration.getAppAppBusinessDateVos(appKey, business,
                                                                                                  startTime, endTime,
                                                                                                  sortName, sortType);
        List<AppBusinessByDateVo> appCountVoList = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(appBusinessDateVos)) {
            for (AppCount appCount : appBusinessDateVos) {
                AppBusinessByDateVo appByDate = new AppBusinessByDateVo();
                mapper.map(appCount, appByDate);
                Double perclickpv = appCount.getPerClickPv() == null ? 0.0 : appCount.getPerClickPv();
                appByDate.setPerClickPv(perclickpv);
                appByDate.setPerClickPvChange(getPerChangeName(appCount));
                appCountVoList.add(appByDate);
            }
        }
        // 4、返回结果集
        return appCountVoList;
    }

    @Override
    public Page<AppTicketVo> findAppTicketCount(String datetime, String appKey, Integer scene, String keyword,
                                                Integer pageSize, Integer pageNum, String sortName,
                                                String sortType) throws IOException {
        List<AdTicket> certificates = new ArrayList<>();
        // 广告券id集合
        List<Long> certificateids = new ArrayList<Long>();
        StringBuffer adshops = new StringBuffer("");
        Map<Long, AdTicket> infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keyword)) {
            // 现根据名称查找ae
            List<AdvertiserDto> adverList = reportCommonService.getAdvertiserByparams(keyword, null);
            // 根据广告券名称模糊查询广告券
            // certificates = infoActivityCertificateService.findCertificateByKeyword(keyword);
            certificates = infoActivityCertificateService.findCertificateByParams(keyword, adverList, null);

            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                        adshops.append(infoActivityCertificate.getAdvertiser()).append(","); // 这个应该是广告主id

                });
            } else {
                return new Page<AppTicketVo>();
            }
        }
        // 存放广告主的map
        Map<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        // 存放ae的map
        Map<Integer, String> mapAe = new HashMap<Integer, String>(16);
        // 调用datapark获取到信息
        Page<TicketCountCommon> ticketCountCommons = dataparkAppPullerIntegration.getAppTicketCount(datetime, appKey,
                                                                                                    scene,
                                                                                                    JSON.toJSONString(certificateids),
                                                                                                    pageSize, pageNum,
                                                                                                    sortName, sortType);
        // 取出datapark获取到的集合
        List<TicketCountCommon> listTemp = ticketCountCommons.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接adshops
            reportCommonService.getAdshops(keyword, adshops, listTemp, infoActivityCertificateMap);
        } else {
            return new Page<AppTicketVo>();
        }
        // 获取整合相关信息
        if (StringUtils.isNotEmpty(adshops)) {
            reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        // 声明并实例化结果集
        Page<AppTicketVo> page = new Page<AppTicketVo>();
        // 复制分页信息到新的结果集
        mapper.map(ticketCountCommons, page);
        List<AppTicketVo> ticketCountVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 整合广告券相关信息
            integrationAppTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, listTemp, ticketCountVoList);
            page.setList(ticketCountVoList);
        }
        return page;
    }

    @Override
    public List<AppTicketVo> findAppTicketCount(String datetime, String appKey, Integer scene,
                                                String keyword) throws IOException {

        List<AdTicket> certificates = new ArrayList<>();
        // 广告券id集合
        List<Long> certificateids = new ArrayList<Long>();
        StringBuffer adshops = new StringBuffer("");
        Map<Long, AdTicket> infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keyword)) {
            // 现根据名称查找ae
            List<AdvertiserDto> adverList = reportCommonService.getAdvertiserByparams(keyword, null);
            // 根据广告券名称模糊查询广告券
            // certificates = infoActivityCertificateService.findCertificateByKeyword(keyword);
            certificates = infoActivityCertificateService.findCertificateByParams(keyword, adverList, null);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                        adshops.append(infoActivityCertificate.getAdvertiser()).append(","); // 这个应该是广告主id
                });
            } else {
                return new ArrayList<AppTicketVo>();
            }
        }
        // 存放广告主的map
        Map<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        // 存放ae的map
        Map<Integer, String> mapAe = new HashMap<Integer, String>(16);
        // 调用datapark
        List<TicketCountCommon> ticketCountCommons = dataparkAppPullerIntegration.getAppTicketCount(datetime, appKey,
                                                                                                    scene,
                                                                                                    JSON.toJSONString(certificateids));
        if (CollectionUtils.isNotEmpty(ticketCountCommons)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接adshops
            reportCommonService.getAdshops(keyword, adshops, ticketCountCommons, infoActivityCertificateMap);
        } else {
            return new ArrayList<AppTicketVo>();
        }
        // 获取整合相关信息
        if (StringUtils.isNotEmpty(adshops)) {
            reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        // 声明并实例化结果集
        List<AppTicketVo> ticketCountVoList = new ArrayList<>();
        // 取出datapark获取到的集合
        if (CollectionUtils.isNotEmpty(ticketCountCommons)) {
            // 整合广告券相关信息
            integrationAppTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, ticketCountCommons,
                                     ticketCountVoList);
        }
        return ticketCountVoList;
    }

    private void integrationAppTicketData(Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe,
                                          Map<Long, AdTicket> infoActivityCertificateMap,
                                          List<TicketCountCommon> ticketCounts, List<AppTicketVo> ticketCountVoList) {
        ticketCounts.forEach(ticketCountCommon -> {
            // 实例化对象
            AppTicketVo appTicketVo = new AppTicketVo();
            mapper.map(ticketCountCommon, appTicketVo);
            // 获取礼券信息
            AdTicket infoActivityCertificate = infoActivityCertificateMap.get(appTicketVo.getCertificateid());
            if (infoActivityCertificate != null) {
                // 获取广告主ID
                String adshop = infoActivityCertificate.getAdvertiser()+"";
                if (StringUtil.isNotEmpty(adshop)) {
                    // 整合广告主信息
                    appTicketVo.setAdvertiserName(mapAdvertiser.get(Integer.valueOf(adshop)));
                    // 整合AE信息
                    appTicketVo.setAEName(mapAe.get(infoActivityCertificate.getId().intValue()));
                }
                // 整合券名称
                appTicketVo.setCertificateName(infoActivityCertificate.getName());
            }
            ticketCountVoList.add(appTicketVo);
        });
    }

    @Override
    public List<AppTicketDateVo> findAppTicketCountDate(String startTime, String endTime, String appKey,
                                                        Long certificateid, String sortName,
                                                        String sortType) throws IOException {
        // 从datapark获取信息
        List<TicketCountCommon> appCountPage = dataparkAppPullerIntegration.getAppTicketCountDate(startTime, endTime,
                                                                                                  appKey, certificateid,
                                                                                                  sortName, sortType);

        // 声明并实例化结果集
        List<AppTicketDateVo> appTicketDateVos = new ArrayList<AppTicketDateVo>();
        // 整合信息
        if (CollectionUtils.isNotEmpty(appCountPage)) {
            appCountPage.forEach(ticketCountCommon -> {
                AppTicketDateVo appTicketDateVo = new AppTicketDateVo();
                mapper.map(ticketCountCommon, appTicketDateVo);
                appTicketDateVos.add(appTicketDateVo);
            });
        }
        return appTicketDateVos;

    }

    @Override
    public Page<AppBusinessTicketVo> findAppBusinessTicketCount(String datetime, String appKey, String business,
                                                                Integer scene, String keyword, Integer pageSize,
                                                                Integer pageNum, String sortName, String sortType,
                                                                Integer ticketType) throws IOException {

        List<AdTicket> certificates = new ArrayList<>();
        // 广告券id集合
        List<Long> certificateids = new ArrayList<Long>();
        StringBuffer adshops = new StringBuffer("");
        Map<Long, AdTicket> infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keyword) || (null != ticketType && ticketType > 0)) {
            // 现根据名称查找ae
            List<AdvertiserDto> adverList = null;
            if (StringUtils.isNotEmpty(keyword)) {
                adverList = reportCommonService.getAdvertiserByparams(keyword, null);
            }
            // 根据广告券名称模糊查询广告券
            // certificates = infoActivityCertificateService.findCertificateByKeyword(keyword);
            certificates = infoActivityCertificateService.findCertificateByParams(keyword, adverList, ticketType);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                    // adshops.append(infoActivityCertificate.getCertificateid()+",");
                        adshops.append(infoActivityCertificate.getAdvertiser()).append(","); // 这个应该是广告主id

                });
            } else {
                return new Page<AppBusinessTicketVo>();
            }
        }

        // 存放广告主的map
        Map<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        // 存放ae的map
        Map<Integer, String> mapAe = new HashMap<Integer, String>(16);
        // 调用datapark获取到信息
        Page<TicketCountCommon> appCountPage = dataparkAppPullerIntegration.getAppBusinessTicketCount(datetime, appKey,
                                                                                                      business, scene,
                                                                                                      JSON.toJSONString(certificateids),
                                                                                                      pageSize, pageNum,
                                                                                                      sortName,
                                                                                                      sortType);
        // 取出datapark获取到的集合
        List<TicketCountCommon> listTemp = appCountPage.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接adshops
            reportCommonService.getAdshops(keyword, adshops, listTemp, infoActivityCertificateMap);
        } else {
            return new Page<AppBusinessTicketVo>();
        }
        // 获取整合相关信息
        if (StringUtils.isNotEmpty(adshops)) {
            reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        // 声明并实例化结果集
        Page<AppBusinessTicketVo> page = new Page<AppBusinessTicketVo>();
        // 复制分页信息到新的结果集
        mapper.map(appCountPage, page);
        List<AppBusinessTicketVo> ticketCountVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 整合广告券相关信息
            integrationAppBusinessTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, listTemp,
                                             ticketCountVoList);
            // 赋值礼券的信息 2018-7-6 11:20:22 新增 by kk.xie
            integrationTicketValue(ticketCountVoList, datetime, appKey, business);
            page.setList(ticketCountVoList);
        }
        return page;
    }

    @Override
    public Page<AppBusinessTicketVo> findAppBusinessTicketCountPageAfterLoadAll(String datetime, String appKey, String business,
                                                                         Integer scene, String keyword, Integer pageSize,
                                                                         Integer pageNum, String sortName, String sortType,
                                                                         Integer ticketType) throws IOException{
//        List<AppBusinessTicketVo> allVos = findAppBusinessTicketExport(datetime, appKey, business, scene, keyword, ticketType);
        Page<AppBusinessTicketVo> appBusinessTicketCount = findAppBusinessTicketCount(datetime, appKey, business, scene,
                keyword, Integer.MAX_VALUE, 1, sortName,
                sortType, ticketType);
        List<AppBusinessTicketVo> allVos = Lists.newArrayList();
        if(null != appBusinessTicketCount && CollectionUtils.isNotEmpty(appBusinessTicketCount.getList())){
            allVos = appBusinessTicketCount.getList();
        }
        Page page = new Page();
        if(CollectionUtils.isNotEmpty(allVos)){
            AppBusinessTicketVo sum = allVos.remove(0);
            page.setPageNum(pageNum);
            page.setPageSize(pageSize);
            page.setTotal((long) allVos.size());
            SortUtils.sort(allVos,sortName,sortType);
            List<AppBusinessTicketVo> returnPageList = new ArrayList<>();
            returnPageList.add(sum);
            returnPageList.addAll(ListUtil.getTotalPage(allVos,allVos.size(),pageNum,pageSize));
            page.setList(returnPageList);
        }
        return page;
    }
    /**
     * 赋值礼券的OCPC,CPC,CPA
     *
     * @param ticketCountVoList  * @param datetime 2018-07-03
     * @return void
     * @throws @author kk.xie
     * @date 2018/7/4 11:13
     */
    private void integrationTicketValue(List<AppBusinessTicketVo> ticketCountVoList, String datetime, String appKey,
                                        String business) {
        // 获取结果集中的礼券ID集
        List<Long> certificateIds = Lists.newArrayList();
        ticketCountVoList.forEach(appBusinessTicketVo -> certificateIds.add(appBusinessTicketVo.getCertificateid()));

        // 查询2.0中的礼券表信息
        List<AdTicket> adTicketList = adTicketMapper.findAllByIds(certificateIds);
        Map<Long, AdTicket> adTicketMap = Maps.newHashMap();
        adTicketList.forEach(adTicket -> adTicketMap.put(adTicket.getId(), adTicket));

        // 查询2.0是否支持OCPC
        List<AdTicketOcpcConf> adTicketOcpcConfList = adTicketOcpcMapper.selectByTicketIdList(certificateIds);
        Map<Long, AdTicketOcpcConf> adTicketOcpcMap = Maps.newHashMap();
        adTicketOcpcConfList.forEach(adTicketOcpcConf -> adTicketOcpcMap.put(adTicketOcpcConf.getTicketId(),
                                                                             adTicketOcpcConf));

        for (AppBusinessTicketVo appBusinessTicketVo : ticketCountVoList) {
            appendTicketInfo(datetime, appKey, business, adTicketMap, adTicketOcpcMap, appBusinessTicketVo);
        }
    }

    private void appendTicketInfo(String datetime, String appKey, String business, Map<Long, AdTicket> adTicketMap,
                                  Map<Long, AdTicketOcpcConf> adTicketOcpcMap,
                                  AppBusinessTicketVo appBusinessTicketVo) {
        Long ticketId = appBusinessTicketVo.getCertificateid();
        if (ticketId == null) {
            return;
        }
        // 结算方式查询结果合并
        AdTicket adTicket = adTicketMap.get(ticketId);
        AdTicketOcpcConf adTicketOcpcConf = adTicketOcpcMap.get(ticketId);
        if (adTicket != null) {
            short settleType = adTicket.getSettleType();
            boolean supportOcpc = adTicketOcpcConf == null ? false : (adTicketOcpcConf.getIsSupportOcpc() == 1 ? true : false);
            if (settleType == AdTicket.CPC && supportOcpc) {
                appBusinessTicketVo.setSettleType("OCPC");
            } else if (settleType == AdTicket.CPC && !supportOcpc) {
                appBusinessTicketVo.setSettleType("CPC");
            } else if (settleType == AdTicket.CPA) {
                appBusinessTicketVo.setSettleType("CPA");
            }
            // 如果广告券没有选择流量包，则直接显示广告券出价
            appBusinessTicketVo.setPackagePrice(new BigDecimal(adTicket.getPrice()).divide(new BigDecimal(1000), 2,
                                                                                           BigDecimal.ROUND_HALF_DOWN));
        }

        // 礼券所属的流量包及出价
        String positionId = appKey + (StringUtils.isEmpty(business) ? "" : business.replaceAll("ad", ""));
        String positonGoup = fetcher.hfetch(TicketKeyGenerator.Filter.getPositionGroup(new BigInteger(String.valueOf(ticketId))),
                                            positionId, String.class);
        if (StringUtils.isNotEmpty(positonGoup)) {
            JSONObject groupObject = JSONObject.parseObject(positonGoup);
            String groupId = groupObject.getString("groupId");
            if (StringUtils.isNotEmpty(groupId)) {
                AdTicketFlowPackageConf adTicketFlowPackageConf = adTicketFlowPackageMapper.selectPackageById(groupId);
                if (adTicketFlowPackageConf != null) {
                    appBusinessTicketVo.setPackageName(adTicketFlowPackageConf.getPackageName());
                    try {
                        BigDecimal price = groupObject.getBigDecimal("price");
                        appBusinessTicketVo.setPackagePrice(price.divide(new BigDecimal(1000), 2,
                                                                         BigDecimal.ROUND_HALF_DOWN));
                    } catch (Exception e) {
                        logger.error("出价类型转换出错！", e);
                    }

                }
            }
        }

        // 赋值
        // 礼券的券操作日志条数-datatime天
        try {
            if (StringUtils.isNotBlank(appBusinessTicketVo.getDatetime())) {
                appBusinessTicketVo.setTicketOperationLog(getTicketLogSize(appBusinessTicketVo.getDatetime(),
                                                                           ticketId));
            } else {
                appBusinessTicketVo.setTicketOperationLog(getTicketLogSize(datetime, ticketId));
            }
        } catch (Exception e) {
            logger.error("获取礼券的券操作日志条数出错！", e);
        }
        // 礼券对应的发券时间 -- 20180709-- 交于数据处理
        // appBusinessTicketVo.setSendTicketTime(getTicketLogTimes(datetime, ticketId));
    }

    private int getTicketLogSize(String datetime, Long ticketId) {
        long dateTimeStamp = DateFormatUtil.getMillisecondByDate(datetime);
        long dateTimePlusOneDayStamp = DateFormatUtil.getMillisecondByPlusDate(datetime, 1);
        long pageSize = getPageTotal(dateTimeStamp, dateTimePlusOneDayStamp, ticketId);
        return (int) pageSize;
    }

    /**
     * 取datatime 天有几条修改记录，例如：查询20180705的数据 即 2018-07-05 00:00:00 的时间戳 到 2018-07-06 00:00:00 的时间戳范围的数据
     *
     * @param dateTimeStamp 查询的时间
     * @param dateTimePlusOneDayStamp 查询结束的时间，加一天的值
     * @param ticketId
     * @return long
     * @throws @author kk.xie
     * @date 2018/7/5 10:03
     */
    private long getPageTotal(long dateTimeStamp, long dateTimePlusOneDayStamp, Object ticketId) {
        LogModelDto dto = new LogModelDto();
        dto.setPageNum(1);
        dto.setPageSize(1);
        dto.setStartDateTime(dateTimeStamp);
        dto.setEndDateTime(dateTimePlusOneDayStamp);
        dto.setAdticketId(String.valueOf(ticketId));
        dto.setCollectionName(CollectionName.ADSMANAGER);
        com.bxm.log.facade.dao.Page<LogModel> logModelPage = logsService.find(dto);
        return logModelPage.getTotal();
    }

    @Override
    public List<AppBusinessTicketVo> findAppBusinessTicketExport(String datetime, String appKey, String business,
                                                                 Integer scene, String keyword,
                                                                 Integer ticketType) throws IOException {
        List<AdTicket> certificates = new ArrayList<>();
        // 广告券id集合
        List<Long> certificateids = new ArrayList<Long>();
        StringBuffer adshops = new StringBuffer("");
        Map<Long, AdTicket> infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keyword)) {
            // 现根据名称查找ae
            List<AdvertiserDto> adverList = reportCommonService.getAdvertiserByparams(keyword, null);
            // 根据广告券名称模糊查询广告券
            // certificates = infoActivityCertificateService.findCertificateByKeyword(keyword);
            certificates = infoActivityCertificateService.findCertificateByParams(keyword, adverList, ticketType);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                        adshops.append(infoActivityCertificate.getAdvertiser()).append(",");

                });
            } else {
                return new ArrayList<AppBusinessTicketVo>();
            }
        }
        // 存放广告主的map
        Map<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        // 存放ae的map
        Map<Integer, String> mapAe = new HashMap<Integer, String>(16);
        // 获取整合相关信息
        // 调用datapark获取到信息
        List<TicketCountCommon> ticketCounts = dataparkAppPullerIntegration.getAppBusinessTicketExport(datetime, appKey,
                                                                                                       business, scene,
                                                                                                       JSON.toJSONString(certificateids));
        if (CollectionUtils.isNotEmpty(ticketCounts)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接adshops
            reportCommonService.getAdshops(keyword, adshops, ticketCounts, infoActivityCertificateMap);
        } else {
            return new ArrayList<AppBusinessTicketVo>();
        }
        // 获取整合相关信息
        if (StringUtils.isNotEmpty(adshops)) {
            reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        // 声明并实例化结果集
        List<AppBusinessTicketVo> ticketCountVoList = new ArrayList<AppBusinessTicketVo>();
        // 取出datapark获取到的集合
        if (CollectionUtils.isNotEmpty(ticketCounts)) {
            // 整合广告券相关信息
            integrationAppBusinessTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, ticketCounts,
                                             ticketCountVoList);
        }
        return ticketCountVoList;
    }

    private void integrationAppBusinessTicketData(Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe,
                                                  Map<Long, AdTicket> infoActivityCertificateMap,
                                                  List<TicketCountCommon> ticketCounts,
                                                  List<AppBusinessTicketVo> ticketCountVoList) {
        ticketCounts.forEach(ticketCountCommon -> {
            // 实例化对象
            AppBusinessTicketVo appTicketVo = new AppBusinessTicketVo();
            mapper.map(ticketCountCommon, appTicketVo);
            // 获取礼券信息
            AdTicket infoActivityCertificate = infoActivityCertificateMap.get(appTicketVo.getCertificateid());
            if (infoActivityCertificate != null) {
                // 获取广告主ID
                String adshop = infoActivityCertificate.getAdvertiser()+"";
                if (StringUtil.isNotEmpty(adshop)) {
                    // 整合广告主信息
                    appTicketVo.setAdvertiserName(mapAdvertiser.get(Integer.valueOf(adshop)));
                    // 整合AE信息
                    appTicketVo.setAEName(mapAe.get(infoActivityCertificate.getId().intValue()));
                }
                // 整合券名称
                appTicketVo.setCertificateName(infoActivityCertificate.getName());
            }
            ticketCountVoList.add(appTicketVo);
        });
    }

    @Override
    public PaginationTemp<ActivityVo> findAppBusinessActivity(String json, String datetime, String appKey, String business,
                                                              String activityType, String activityPlanner, Integer pageSize,
                                                              Integer pageNum, String sortName, String sortType) throws IOException {
        List<Long> activityIds = Lists.newArrayList();
        if (StringUtils.isNotBlank(json)) {
            Map<String, Object> parm = new HashMap<>();
            parm.put("activityname", json);
            activityIds = activityMapper.findListByKeywordsNew(parm);
            if (CollectionUtils.isEmpty(activityIds)) {
                return PaginationTemp.noneDataPage();
            }
        }
        Page<ActivityCount> page = dataparkAppPullerIntegration.appBusinessActivity(JSON.toJSONString(activityIds), datetime, appKey, business, activityType,
                activityPlanner, pageSize, pageNum, sortName, sortType);
        List<ActivityCount> activityCountList = page.getList();
        if (CollectionUtils.isEmpty(activityCountList) || activityCountList.size() < 2) {
            return PaginationTemp.noneDataPage();
        }

        // 遍历一次获取活动 ID
        for (ActivityCount activityCount : activityCountList) {
            if (activityCount.getActivityId() != null) {
                activityIds.add(activityCount.getActivityId());
            }
        }
        // 没有活动ID时，返回空分页
        if (CollectionUtils.isEmpty(activityIds)) {
            return PaginationTemp.noneDataPage();
        }

        // 根据活动 ID 查询活动信息
        Map<String, Object> map = Maps.newHashMap();
        map.put("ids", activityIds);
        List<ActivityWithBLOBs> activityWithBLOBsList = activityMapper.findList(map);
        // 放入 map 减少遍历
        Map<Long, String> activityWithBLOBsNameMap;
        if (CollectionUtils.isEmpty(activityWithBLOBsList)) {
            activityWithBLOBsNameMap = Collections.emptyMap();
        } else {
            activityWithBLOBsNameMap = activityWithBLOBsList.stream().collect(HashMap::new, (m, v) -> m.put(v.getId(), v.getActivityName()), HashMap::putAll);
        }
        List<ActivityVo> activityVos = Lists.newArrayListWithCapacity(activityCountList.size());
        for (ActivityCount activityCount : activityCountList) {
            ActivityVo activityVo = new ActivityVo();
            mapper.map(activityCount, activityVo);
            activityVo.setActivityName(activityWithBLOBsNameMap.getOrDefault(activityCount.getActivityId(), ""));
            activityVo.setActivityModelName(activityCount.getActivityType());
            activityVo.setPerClickPv(activityCount.getPerClickPv() == null ? 0.0 : activityCount.getPerClickPv());
            activityVo.setPerClickPvChange(getPerChangeName(activityCount));
            activityVos.add(activityVo);
        }
        return PaginationTemp.instance(page.getPageNum(), page.getSize(), page.getTotal().intValue(), activityVos);
    }

    @Override
    public List<ActivityVo> appBusinessActivityExport(String datetime, String appKey, String business,
                                                      String keyword) throws IOException {
        List<Long> activity = new ArrayList<>();
        if (!StringUtils.isEmpty(keyword)) {
            Map<String, Object> parm = new HashMap<>();
            parm.put("activityname", keyword);
            activity = activityMapper.findListByKeywordsNew(parm);
        }
        List<ActivityCount> activityCounts = dataparkAppPullerIntegration.appBusinessActivityExport(JSON.toJSONString(activity),
                                                                                                    datetime, appKey,
                                                                                                    business);
        // 转换VO
        List<ActivityWithBLOBs> activityWithBLOBs = new ArrayList<>();
        if (activity.size() > 0) {
            Map<String, Object> map = new HashMap<>();
            map.put("ids", activity);
            activityWithBLOBs = activityMapper.findList(map);
        } else {
            // 遍历一次获取活动 ID
            for (ActivityCount activityCount : activityCounts) {
                if (activityCount.getActivityId() != null) {
                    activity.add(activityCount.getActivityId());
                }
            }
            // 根据活动 ID 查询活动信息
            Map<String, Object> map = new HashMap<>();
            map.put("ids", activity);
            activityWithBLOBs = activityMapper.findList(map);
        }

        Map<String, ActivityWithBLOBs> activityWithBLOBsMap = new HashMap<>();
        for (ActivityWithBLOBs activityWithBLOBs1 : activityWithBLOBs) {
            activityWithBLOBsMap.put(activityWithBLOBs1.getId() + "", activityWithBLOBs1);
        }
        List<ActivityVo> activityVos = new ArrayList<>();
        for (ActivityCount activityCount : activityCounts) {
            ActivityVo activityVo = new ActivityVo();
            mapper.map(activityCount, activityVo);
            ActivityWithBLOBs activityWithBLOBs1 = activityWithBLOBsMap.getOrDefault(activityCount.getActivityId() + "",
                                                                                     new ActivityWithBLOBs());
            String activityName = activityWithBLOBs1.getActivityName();
            String activityType = activityWithBLOBs1.getActivityType();
            Dictionaries dictionaries = dictionariesService.findByCode(StringUtils.isEmpty(activityType) ? "" : activityType,"acttype");
            if (dictionaries != null) {
                activityVo.setActivityModelName(dictionaries.getTypename());
            }
            activityVo.setActivityName(activityName);
            // activityVo.setActivityModelName(StringUtils.isEmpty(activityName) ? "" :activityName);
            activityVos.add(activityVo);
        }
        return activityVos;
    }

    // 处理子链接修改之后涉及到的一些数据重新计算
    private List<AppBusinessVo> getUpdateList(List<AppCount> listPre, List<AppBusinessVo> list, String datetime,
                                              String appKey, Long total, Integer size) {
        // 按今日和appKey查出所有的修改过的子链接 然后循环遍历通过business逐一筛选
        Map<String, Object> map = new HashMap<>();
        map.put("datetime", datetime);
        map.put("appKey", appKey);
        List<TblAdIconClickPvUpdate> updateList = tblAdIconClickPvUpdateMapperExt.findByDateAndAppkey(map);
        // 无修改直接返回
        // if (updateList.size()==0){
        // return list;
        // }
        Map<String, TblAdIconClickPvUpdate> mapTemp = new HashMap<>();
        updateList.forEach(tblAdIconClickPvUpdate -> {
            mapTemp.put(tblAdIconClickPvUpdate.getBusiness(), tblAdIconClickPvUpdate);
        });

        Map<String, AppCount> mapPre = new HashMap<>();
        if (listPre == null || listPre.size() == 0) {
            List<AppCount> listTemp = new ArrayList<>();
            AppCount appCountTemp = new AppCount();
            appCountTemp.setIconPv(0);
            appCountTemp.setEcpm(0.0);
            appCountTemp.setmEcpm(0.0);
            appCountTemp.setIconPv(0);
            appCountTemp.setMidPageRate(0.0);
            listTemp.add(appCountTemp);

            listTemp.forEach(appCount -> {
                mapPre.put(appCount.getBusiness(), appCount);
            });

        } else {
            listPre.forEach(appCount -> {
                mapPre.put(appCount.getBusiness(), appCount);
            });
        }

        for (AppBusinessVo appBusinessVo : list) {

            for (String key : mapTemp.keySet()) {
                if (key.equals(appBusinessVo.getBusiness())) {

                    int iconPv = 0;
                    if (mapTemp.get(key) != null && null != mapTemp.get(key).getIconPv()) {
                        iconPv = mapTemp.get(key).getIconPv();
                    }

                    int iconClickPv = 0;

                    if (mapTemp.get(key) != null && null != mapTemp.get(key).getIconClickPv()) {
                        iconClickPv = mapTemp.get(key).getIconClickPv();
                    }

                    // 此链接已经被修改过需重新计算数据
                    // 仅修改广告位曝光 会影响 合计 涨幅 ecpm mEcpm
                    if (iconPv != 0 && iconClickPv == 0) {
                        appBusinessVo.setIconPv(iconPv);
                        appBusinessVo.setEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getIncome(), iconPv));
                        appBusinessVo.setmEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getBusinessIncome(), iconPv));

                        for (String business : mapPre.keySet()) {
                            if (key.equals(appBusinessVo.getBusiness())) {
                                // 计算涨幅
                                appBusinessVo.setIconChange(DateParkUtil.dealChange(mapPre.get(business).getIconPv(),
                                                                                    iconPv));
                                appBusinessVo.setEcpmChange(DateParkUtil.dealChange(mapPre.get(business).getEcpm(),
                                                                                    appBusinessVo.getEcpm()));
                                appBusinessVo.setmEcpmChange(DateParkUtil.dealChange(mapPre.get(business).getmEcpm(),
                                                                                     appBusinessVo.getmEcpm()));
                            }
                        }

                        // 仅修改广告位点击 会影响 合计 涨幅 点击到达率
                    } else if (iconPv == 0 && iconClickPv != 0) {
                        appBusinessVo.setIconClickPv(iconClickPv);
                        appBusinessVo.setMidPageRate(DateParkUtil.getArpuOrEcpm(appBusinessVo.getMidPagePv().toString(),
                                                                                iconClickPv));

                        for (String business : mapPre.keySet()) {
                            if (key.equals(appBusinessVo.getBusiness())) {
                                // 计算涨幅
                                appBusinessVo.setIconClickChange(DateParkUtil.dealChange(mapPre.get(business).getIconClickPv(),
                                                                                         iconClickPv));
                                appBusinessVo.setMidPageRateChange(DateParkUtil.dealChange(mapPre.get(business).getMidPageRate(),
                                                                                           appBusinessVo.getMidPageRate()));
                            }
                        }

                        // 都被修改
                    } else if (iconPv != 0) {
                        appBusinessVo.setIconPv(iconPv);
                        appBusinessVo.setIconClickPv(iconClickPv);
                        appBusinessVo.setEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getIncome(), iconPv));
                        appBusinessVo.setmEcpm(DateParkUtil.getArpuOrEcpm(appBusinessVo.getBusinessIncome(), iconPv));
                        appBusinessVo.setMidPageRate(DateParkUtil.getArpuOrEcpm(appBusinessVo.getMidPagePv().toString(),
                                                                                iconClickPv));

                        for (String business : mapPre.keySet()) {
                            if (StringUtils.isNotBlank(business) && business.equals(appBusinessVo.getBusiness())) {
                                // 计算涨幅
                                appBusinessVo.setIconChange(DateParkUtil.dealChange(mapPre.get(business).getIconPv(),
                                                                                    iconPv));
                                appBusinessVo.setEcpmChange(DateParkUtil.dealChange(mapPre.get(business).getEcpm(),
                                                                                    appBusinessVo.getEcpm()));
                                appBusinessVo.setmEcpmChange(DateParkUtil.dealChange(mapPre.get(business).getmEcpm(),
                                                                                     appBusinessVo.getmEcpm()));
                                appBusinessVo.setIconClickChange(DateParkUtil.dealChange(mapPre.get(business).getIconClickPv(),
                                                                                         iconClickPv));
                                appBusinessVo.setMidPageRateChange(DateParkUtil.dealChange(mapPre.get(business).getMidPageRate(),
                                                                                           appBusinessVo.getMidPageRate()));
                            }
                        }

                    }

                }

            }

            // 给前端返回广告位是否可编辑
            if (StringUtils.isEmpty(appBusinessVo.getAppKey())) {
                continue;
            }
            Integer dockMethod = appEntranceFacadeIntegration.queryDockMethod(appBusinessVo.getAppKey(),
                                                                              appBusinessVo.getBusiness().replace("ad-",
                                                                                                                  ""));
            if (dockMethod == null) {
                continue;
            }
            logger.info("dockMethod:{}, iconPv:{}, iconClickPv:{}", dockMethod, appBusinessVo.getIconPv(),
                        appBusinessVo.getIconClickPv());
            appBusinessVo.setIconPvEditable(dockMethod == 0 && appBusinessVo.getIconPv() == 0);
            appBusinessVo.setIconClickPvEditable(dockMethod == 0 && appBusinessVo.getIconClickPv() == 0);

        }
        // 合计 广告位曝光数，广告位点击数，点击到达率（中间页曝光数/广告位点击数），ecpm（券收入/广告位曝光数）媒体ecpm（子链接收益/广告位曝光数）

        Map<String, Object> mapSum = new HashMap<>();
        // 抛开合计重新计算(将合计拎出来其他的重新算)
        List<AppBusinessVo> listSum = new ArrayList<>();
        for (int i = 1; i <= list.size() - 1; i++) {
            listSum.add(list.get(i));
        }
        // 广告位曝光 广告位点击 中间页曝光 券收入 子链接收益
        int iconPvSum = 0;
        int iconClickPvSum = 0;
        int midPagePvSum = 0;
        Double incomeSum = 0d;
        Double businessIncomeSum = 0d;
        for (AppBusinessVo aListSum : listSum) {
            iconPvSum += aListSum.getIconPv();
            iconClickPvSum += aListSum.getIconClickPv();
            midPagePvSum += aListSum.getMidPagePv();
            incomeSum += aListSum.getIncome();
            businessIncomeSum += aListSum.getBusinessIncome();
        }
        Double midPageRateSum = DoubleUtil.formatDouble(midPagePvSum + "", iconClickPvSum + "");
        Double ecpmSum = DateParkUtil.getArpuOrEcpm(incomeSum, iconPvSum);
        Double mEcpmSum = DateParkUtil.getArpuOrEcpm(businessIncomeSum, iconPvSum);
        // 将修改之后的合计list(如果查出的总条数大于当前页码显示数就不显示)
        list.get(0).setIconPv(iconPvSum);
        list.get(0).setIconClickPv(iconClickPvSum);
        list.get(0).setMidPageRate(midPageRateSum);
        list.get(0).setEcpm(ecpmSum);
        list.get(0).setmEcpm(mEcpmSum);

        if (total > size) {
            Integer kong = null;
            list.get(0).setIconPv(null);
            list.get(0).setIconClickPv(null);
            list.get(0).setMidPageRate(null);
            list.get(0).setEcpm(null);
            list.get(0).setmEcpm(null);
        }
        if (list == null) {
            return new ArrayList<AppBusinessVo>();
        }
        return list;
    }

    @Override
    public int updateIconOrClickPv(int iconPv, int iconClickPv, String dateTime, String business,
                                   String appKey) throws Exception {
        // 查询是否已经修改过即存在这条数据
        Map<String, Object> map = new HashMap<>();
        map.put("dateTime", dateTime);
        map.put("appKey", appKey);
        map.put("business", business);
        TblAdIconClickPvUpdate tblAdIconClickPvUpdate = tblAdIconClickPvUpdateMapperExt.findOne(map);
        if (tblAdIconClickPvUpdate != null) {
            // 如果存在说明已修改过
            if (tblAdIconClickPvUpdate.getIconClickPv() == 0) {
                tblAdIconClickPvUpdate.setIconClickPv(iconClickPv == 0 ? null : iconClickPv);
            }
            if (tblAdIconClickPvUpdate.getIconPv() == 0) {
                tblAdIconClickPvUpdate.setIconPv(iconPv == 0 ? null : iconPv);
            }
            return tblAdIconClickPvUpdateMapper.updateByPrimaryKeySelective(tblAdIconClickPvUpdate);
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        TblAdIconClickPvUpdate tblAdIconClickPvUpdateNew = new TblAdIconClickPvUpdate();
        tblAdIconClickPvUpdateNew.setBusiness(business);
        tblAdIconClickPvUpdateNew.setAppkey(appKey);
        tblAdIconClickPvUpdateNew.setDateTime(sf.parse(dateTime));
        tblAdIconClickPvUpdateNew.setIconPv(iconPv);
        tblAdIconClickPvUpdateNew.setIconClickPv(iconClickPv);
        tblAdIconClickPvUpdateNew.setUpdateTime(new Date());

        return tblAdIconClickPvUpdateMapper.insert(tblAdIconClickPvUpdateNew);
    }

    @Override
    public List<AppCountVo> findAppCountSumByDate(String startTime, String endTime, String keyword, User user,
                                                  String sortName, String sortType) throws Exception {
        // 查询当前用户的角色如果只为BD则只能看到自己的媒体信息 媒介只能看到与自己绑定的媒体 返回username
        String roleCode = getRoleCode(user);
        List<AppCountVo> appCountVoList = new ArrayList<>();
        // 1、根据关键字查询出开发者的信息
        List<InfoAppMsg> infoAppMsgs = new ArrayList<>();
        // 2、声明一个集合用于封装appKeys
        List<String> appKeysList = Lists.newArrayList();
        // 3、把所有查询出的所有appKey添加至appKeys,并存入map集合
        Map<String, InfoAppMsg> infoAppMsgMap = Maps.newHashMap();
        StringBuffer appKeys = new StringBuffer();
        if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(roleCode)) {
            infoAppMsgs = infoAppMsgService.findAllAppkeys(keyword, roleCode);
            if (CollectionUtils.isNotEmpty(infoAppMsgs)) {
                infoAppMsgs.forEach(infoAppMsg -> {
                    appKeysList.add(infoAppMsg.getAppkey());
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                    appKeys.append(infoAppMsg.getAppkey()).append(",");
                });
            } else {
                return new ArrayList<AppCountVo>();
            }
        }
        // 4、调用datapark
        List<AppCount> appCountVos = dataparkAppPullerIntegration.getAppCountVosSum(startTime, endTime, sortName,
                                                                                    sortType,
                                                                                    JSON.toJSONString(appKeysList));
        if (CollectionUtils.isEmpty(appCountVos)) {
            return new ArrayList<AppCountVo>();
        }
        // 5、声明并实例化结果集
        List<AppCountVo> list = new ArrayList<>();
        // 6、把数据添加至新的集合
        copyList(appCountVos, list);
        return list;
    }

    @Override
    public List<AppCountVo> appCountSumByDateExport(String startTime, String endTime, String keyword,
                                                    User user) throws Exception {
        // 查询当前用户的角色如果只为BD则只能看到自己的媒体信息 媒介只能看到与自己绑定的媒体 返回username
        String roleCode = getRoleCode(user);
        // 1、根据关键字查询出开发者的信息
        List<InfoAppMsg> infoAppMsgs = new ArrayList<>();
        // 2、声明一个集合用于封装appKeys
        List<String> appKeysList = Lists.newArrayList();
        // 3、把所有查询出的所有appKey添加至appKeys,并存入map集合
        Map<String, InfoAppMsg> infoAppMsgMap = Maps.newHashMap();
        // if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(roleCode)){
        infoAppMsgs = infoAppMsgService.findAllAppkeys(keyword, roleCode);
        if (CollectionUtils.isNotEmpty(infoAppMsgs)) {
            infoAppMsgs.forEach(infoAppMsg -> {
                appKeysList.add(infoAppMsg.getAppkey());
                infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
            });
        } else {
            return new ArrayList<AppCountVo>();
        }
        // }
        // 4、调用datapark
        List<AppCount> appCountVos = dataparkAppPullerIntegration.appCountVosSumExport(startTime, endTime,
                                                                                       JSON.toJSONString(appKeysList));
        if (CollectionUtils.isEmpty(appCountVos)) {
            return new ArrayList<AppCountVo>();
        }
        // 5、声明并实例化结果集
        List<AppCountVo> list = new ArrayList<>();
        // 6、把数据添加至新的集合
        copyList(appCountVos, list);
        // 数据正常获取（由于涉及到权限 如果是bd 必须清空赋值0部分字段数据）
        if (user.getRoleCodes().contains(RoleEnum.BD.getCode())
            && !user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode())) {
            for (int i = 0; i < list.size(); i++) {
                appCountVos.get(i).setMidPagePv(0);
                appCountVos.get(i).setMidPvChange("");
                appCountVos.get(i).setIndexPv(0);
                appCountVos.get(i).setIndexPvChange("");
                appCountVos.get(i).setIndexUv(0);
                appCountVos.get(i).setIndexUvChange("");
                appCountVos.get(i).setIncome(0.0);
                appCountVos.get(i).setIncomeChange("");
                appCountVos.get(i).setDeveloperIncome(0.0);
                appCountVos.get(i).setDeveloperIncomeChange("");
                appCountVos.get(i).setBxmIncome(0.0);
                appCountVos.get(i).setBxmIncomeChange("");
                appCountVos.get(i).setOpenPvAurp(0.0);
                appCountVos.get(i).setOpenPvAurpChange("");
                appCountVos.get(i).setUvAurp(0.0);
                appCountVos.get(i).setUvAurpChange("");
                appCountVos.get(i).setDeveloperAurp(0.0);
                appCountVos.get(i).setDeveloperAurpChange("");
                appCountVos.get(i).setBxmAurp(0.0);
                appCountVos.get(i).setBxmAurpChange("");
            }
            return list;
        }
        return list;
    }

    @Override
    public List<AppBusinessTicketDateVo> findAppBusinessTicketDateReport(String startTime, String endTime,
                                                                         String appKey, Long certificateid,
                                                                         String sortName, String sortType,
                                                                         String business) throws IOException {
        List<TicketCountCommon> lists = dataparkAppPullerIntegration.getAppBusinessTicketDateReport(startTime, endTime,
                                                                                                    appKey,
                                                                                                    certificateid,
                                                                                                    sortName, sortType,
                                                                                                    business);
        List<AppBusinessTicketDateVo> returnList = new ArrayList<>();
        List<AppBusinessTicketVo> tmpList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(lists)) {
            for (TicketCountCommon common : lists) {
                AppBusinessTicketVo vo = new AppBusinessTicketVo();
                mapper.map(common, vo);
                tmpList.add(vo);
            }
            // 填充券信息
            integrationTicketValue(tmpList, null, appKey, business);
            for (AppBusinessTicketVo source : tmpList) {
                AppBusinessTicketDateVo vo = new AppBusinessTicketDateVo();
                mapper.map(source, vo);
                returnList.add(vo);
            }
        }

        return returnList;
    }

    private String getPerChangeName(AppCount appCount) {
        return appCount.getPerClickPvChange() != null
               && appCount.getPerClickPvChange() != 0.0 ? appCount.getPerClickPvChange() + "%" : "-";
    }

    private String getPerChangeName(ActivityCount appCount) {
        return appCount.getPerClickPvChange() != null
               && appCount.getPerClickPvChange() != 0.0 ? appCount.getPerClickPvChange() + "%" : "-";
    }

    // 判断bd 媒介
    private String getRoleCode(User user) {
        String roleCode = "";
        if (!user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode())
            && !user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())) {
            if (user.getRoleCodes().contains(RoleEnum.BD.getCode())) {
                roleCode = user.getUserNameContainRole(RoleEnum.BD.getCode());
            } else if (user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
                roleCode = user.getUserNameContainRole(RoleEnum.MJ.getCode());
            }
        }
        return roleCode;
    }
}
