package com.bxm.report.service.report.impl;

import com.bxm.dao.dictionary.DictionariesMapper;
import com.bxm.report.facade.acl.AclUserIntegration;
import com.bxm.report.facade.advertiser.AdShopIntegration;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.report.service.report.ReportCommonService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.report.impl.ReportCommonServiceImpl.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-03 14:24:00
 * @modifier ganquan
 * @updated 2018-03-03 14:24:00
 */
@Component
@Configurable
public class ReportCommonServiceImpl implements ReportCommonService {

    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private InfoActivityCertificateService infoActivityCertificateService;
    @Autowired 
    private DictionariesMapper dictionariesMapper;
    @Resource
    private AclUserIntegration aclUserIntegration;

    /**
     * 获取广告主和ae 信息
     * @author 阿导
     * @time 2018/3/3
     * @CopyRight 杭州微财科技有限公司
     * @param adshops 广告主ID 以,分隔
     * @param mapAdvertiser
     * @param mapAe
     * @return void
     */
    @Override
    public void getAdvertiser(String adshops, Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe) throws IOException {
        //根据广告主 ID 查询广告主信息，其中，ids 是 adshop 以逗号分隔
        List<AdvertiserDto> list =  adShopIntegration.findAdShopMsgs(adshops);
        //从字典项获取 AE code 和 name
        Map<String, String> mapAeName = aclUserIntegration.queryUserByRoleCode("ae");
        //存储广告主信息至 map
        if(CollectionUtils.isNotEmpty(list)){
            //存入map,key 为广告主ID,也就是广告券里面adshop 字段
            list.stream().forEach(advertiserDto -> {
                mapAdvertiser.put(advertiserDto.getId(),advertiserDto.getCompany());

            });
        }
        //整合ae 通过广告主查券
        if (StringUtils.isNotBlank(adshops)){
            List<Long> idList = new ArrayList<>();
            for (String id : adshops.split(",")) {
                idList.add(Long.valueOf(id));
            }
            List<AdTicket> tickets = infoActivityCertificateService.findCertificateByAdvertiser(idList);
            if (CollectionUtils.isNotEmpty(tickets)){
                tickets.stream().forEach(adTicket -> {
                    Integer id = adTicket.getId().intValue();
                    String aeName = mapAeName.get(adTicket.getAe());
                    mapAe.put(id,aeName);
                });
            }
            //mapAe.put(advertiserDto.getId(),mapAeName.get(advertiserDto.getAe()));
        }
    }

    @Override
    public void getAdshops(String keyword, StringBuffer adshops, List<TicketCountCommon> ticketCounts, Map<Long,AdTicket> infoActivityCertificateMap) {
        StringBuffer dataparkCertificateids = new StringBuffer();
        if (StringUtils.isEmpty(keyword)){
            ticketCounts.stream().forEach(ticketCountCommon->{
                dataparkCertificateids.append(ticketCountCommon.getCertificateid()+",");
            });
            List<AdTicket> certificateInfoByCertificates = infoActivityCertificateService.findCertificateInfoByCertificates(dataparkCertificateids);
            if (CollectionUtils.isNotEmpty(certificateInfoByCertificates)){
                certificateInfoByCertificates.stream().forEach(certificate->{
                    infoActivityCertificateMap.put(certificate.getId(),certificate);
                    adshops.append(certificate.getAdvertiser()+",");
                });
            }
        }
    }

    /**
     * 获取根据关键词查找广告主列表
     * @author 拉拉
     * @time 2018/7/9
     * @CopyRight 杭州微财科技有限公司 
     * @param keywords
     * @param aeCode
     * @return void
     */
    @Override
    public List<AdvertiserDto> getAdvertiserByparams(String keywords,String aeCode) throws IOException {
        StringBuffer sb=new StringBuffer("");
        if(StringUtils.isNotBlank(aeCode)){
            sb.append(aeCode);
            // keyword 与ae  查询条件 是 and
            return  adShopIntegration.findAdShopMsgsByKeywordsAndAe(keywords,sb.toString());
        }else {
            //从字典项获取 AE code 和 name
            List<Dictionaries> aeList = dictionariesMapper.findByKeywords("ae", keywords);
            if (CollectionUtils.isNotEmpty(aeList)) {
                aeList.stream().forEach(ae -> {
                    sb.append(ae.getTypecode() + ",");
                });
            }
            // keyword 与ae  查询条件 是 or
            return  adShopIntegration.findAdShopMsgsByKeywords(keywords,sb.toString());
        }
    }


}
