/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.report.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.facade.Page;
import com.bxm.report.facade.datapark.DataparkTicketPullerIntegration;
import com.bxm.report.model.constant.ReportConstant;
import com.bxm.report.model.dao.adticket.AdTicket;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dao.app.InfoAppMsg;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.model.vo.adposition.AdpositionVo;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.adkeeper.InfoActivityCertificateService;
import com.bxm.report.service.adkeeper.InfoAppMsgService;
import com.bxm.report.service.report.AdTicketTagConfService;
import com.bxm.report.service.report.ITicketReportService;
import com.bxm.report.service.report.ReportCommonService;
import com.bxm.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 广告券报表，服务层实现
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.report.impl.TicketReportServiceImpl.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:33:00
 * @modifier 阿导
 * @updated 2018-02-27 11:33:00
 */
@Service
public class TicketReportServiceImpl implements ITicketReportService {
   private  static  final Logger logger = LoggerFactory.getLogger(TicketReportServiceImpl.class) ;

    @Autowired
    private DataparkTicketPullerIntegration dataParkTicketPullerIntegration;
    @Autowired
    private InfoAppMsgService               infoAppMsgService;
    @Autowired
    private AdPositionService               adPositionService;

    @Autowired
    private InfoActivityCertificateService  infoActivityCertificateService;
    @Autowired
    private ReportCommonService             reportCommonService;
    @Autowired
    private AdTicketTagConfService          adTicketTagConfService;

    @Autowired
    private Mapper                          mapper;

    @Override
    public Page<TicketCountVo> findTicketCount(String datetime, Integer scene, String keyword, Integer pageNum,
                                               Integer pageSize, String sortName, String sortType, String ae,
                                               Integer ticketType, Integer tagCode) throws IOException {

        List<AdTicket> certificates = new ArrayList<>();
        // 广告券id集合
        List<Long> certificateIds = new ArrayList<Long>();
        StringBuffer adShopStr = new StringBuffer("");
        // adshop 放set用于去重，防止调接口包含太多参数
        Set<Long> adshopsSet = new HashSet<>();
        Map<Long, AdTicket> infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(ae) || (null != ticketType && ticketType > 0)) {
            // keyword不去空格的话， 拼接url的时候 会报异常！
            keyword = keyword.replace(" ", "");

            // 现根据名称查找ae
            List<AdvertiserDto> adverList = null;
            //修改为券维度的ae条件查询
            String  aeNew = ae;
            ae=null;
            if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(ae)) {
                adverList = reportCommonService.getAdvertiserByparams(keyword, ae);
            }
            // 根据广告券名称模糊查询广告券
            // certificates = infoActivityCertificateService.findCertificateByKeyword(keyword);
            certificates = infoActivityCertificateService.findCertificateByParamsAndAe(keyword, adverList, ticketType,aeNew);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateIds.add(infoActivityCertificate.getId());
                        adshopsSet.add(infoActivityCertificate.getAdvertiser());
                });
                adshopsSet.stream().forEach(adshop -> {
                    adShopStr.append(adshop + ",");
                });
            } else {
                return new Page<TicketCountVo>();
            }
        }
        // 广告券类型
        if (null != tagCode) {
            if (CollectionUtils.isEmpty(certificateIds)) {
                List<Long> ticketIds = adTicketTagConfService.findTicketIdsByOneLevelTagCode(tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return new Page<>();
                }
                certificateIds.addAll(ticketIds);
            } else {
                List<Long> ticketIds = adTicketTagConfService.checkTicketBelongOneLevelTagCode(certificateIds, tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return new Page<>();
                }
                certificateIds.removeIf(ticketId -> !ticketIds.contains(ticketId));
            }
        }
        // 存放广告主的map
        Map<Integer, String> mapAdvertiser = new HashMap<>(16);
        // 存放ae的map
        Map<Integer, String> mapAe = new HashMap<>(16);
        // 调用datapark获取到信息
        Page<TicketCountCommon> ticketCountCommonPage = dataParkTicketPullerIntegration.getTicketCount(datetime, scene,
                                                                                                       JSON.toJSONString(certificateIds),
                                                                                                       pageNum,
                                                                                                       pageSize,
                                                                                                       sortName,
                                                                                                       sortType);
        // 取出datapark获取到的集合
        List<TicketCountCommon> listTemp = ticketCountCommonPage.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接adshops
            reportCommonService.getAdshops(keyword, adShopStr, listTemp, infoActivityCertificateMap);
        } else {
            return new Page<>();
        }
        // 获取整合相关信息
        if (StringUtils.isNotBlank(adShopStr.toString())) {
            reportCommonService.getAdvertiser(adShopStr.toString(), mapAdvertiser, mapAe);
        }
        // 声明并实例化结果集
        Page<TicketCountVo> page = new Page<>();
        // 复制分页信息到新的结果集
        mapper.map(ticketCountCommonPage, page);
        List<TicketCountVo> ticketCountVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 整合广告券相关信息
            integrationTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, listTemp, ticketCountVoList);
            page.setList(ticketCountVoList);
        }

        // 查询广告券一级标签的名称
        List<Long> ticketIds = ticketCountVoList.stream().map(TicketCountVo::getCertificateid).collect(Collectors.toList());
        Map<Long, String> tagNameMap = adTicketTagConfService.findClassifyTagName(ticketIds);
        for (TicketCountVo ticketCountVo : ticketCountVoList) {
            ticketCountVo.setTagName(tagNameMap.get(ticketCountVo.getCertificateid()));
        }
        return page;
    }

    @Override
    public List<TicketCountVo> findTicketCountExport(String datetime, Integer scene, String keyword, String ae,
                                                     Integer ticketType, Integer tagCode) throws IOException {
        // 根据广告券名称模糊查询广告券
        List<AdTicket> certificates = new ArrayList<>();
        // 广告券id集合
        List<Long> certificateids = new ArrayList<Long>();
        StringBuffer adshops = new StringBuffer("");
        Map<Long, AdTicket> infoActivityCertificateMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(ae) || (null != ticketType && ticketType > 0)) {
            // 现根据名称查找ae
            List<AdvertiserDto> adverList = null;
            //修改为券维度的ae条件查询
            String  aeNew = ae;
            ae=null;
            if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(ae)) {
                adverList = reportCommonService.getAdvertiserByparams(keyword, ae);
            }
            // 根据广告券名称模糊查询广告券
            // certificates = infoActivityCertificateService.findCertificateByKeyword(keyword);
            certificates = infoActivityCertificateService.findCertificateByParamsAndAe(keyword, adverList, ticketType,aeNew);
            if (CollectionUtils.isNotEmpty(certificates)) {
                certificates.stream().forEach(infoActivityCertificate -> {
                    infoActivityCertificateMap.put(infoActivityCertificate.getId(), infoActivityCertificate);
                    certificateids.add(infoActivityCertificate.getId());
                        adshops.append(infoActivityCertificate.getAdvertiser() + ",");
                });
            } else {
                return new ArrayList<>();
            }
        }
        // 广告券类型
        if (null != tagCode) {
            if (CollectionUtils.isEmpty(certificateids)) {
                List<Long> ticketIds = adTicketTagConfService.findTicketIdsByOneLevelTagCode(tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return Collections.emptyList();
                }
                certificateids.addAll(ticketIds);
            } else {
                List<Long> ticketIds = adTicketTagConfService.checkTicketBelongOneLevelTagCode(certificateids, tagCode);
                if (CollectionUtils.isEmpty(ticketIds)) {
                    return Collections.emptyList();
                }
                certificateids.removeIf(ticketId -> !ticketIds.contains(ticketId));
            }
        }
        // 存放广告主的map
        Map<Integer, String> mapAdvertiser = new HashMap<Integer, String>(16);
        // 存放ae的map
        Map<Integer, String> mapAe = new HashMap<Integer, String>(16);
        // 调用datapark获取到信息
        List<TicketCountCommon> ticketCounts = dataParkTicketPullerIntegration.getTicketCount(datetime, scene,
                                                                                              JSON.toJSONString(certificateids));
        if (CollectionUtils.isNotEmpty(ticketCounts)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接adshops
            reportCommonService.getAdshops(keyword, adshops, ticketCounts, infoActivityCertificateMap);
        } else {
            return new ArrayList<>();
        }
        // 获取整合相关信息
        if (StringUtils.isNotEmpty(adshops.toString())) {
            reportCommonService.getAdvertiser(adshops.toString(), mapAdvertiser, mapAe);
        }
        // 声明并实例化结果集
        List<TicketCountVo> ticketCountVoList = new ArrayList<>();
        // 取出datapark获取到的集合
        if (CollectionUtils.isNotEmpty(ticketCounts)) {
            // 整合广告券相关信息
            integrationTicketData(mapAdvertiser, mapAe, infoActivityCertificateMap, ticketCounts, ticketCountVoList);
        }
        // 查询广告券一级标签的名称
        List<Long> ticketIds = ticketCountVoList.stream().map(TicketCountVo::getCertificateid).collect(Collectors.toList());
        Map<Long, String> tagNameMap = adTicketTagConfService.findClassifyTagName(ticketIds);
        for (TicketCountVo ticketCountVo : ticketCountVoList) {
            ticketCountVo.setTagName(tagNameMap.get(ticketCountVo.getCertificateid()));
        }
        return ticketCountVoList;
    }

    private void integrationTicketData(Map<Integer, String> mapAdvertiser, Map<Integer, String> mapAe,
                                       Map<Long, AdTicket> infoActivityCertificateMap,
                                       List<TicketCountCommon> ticketCounts, List<TicketCountVo> ticketCountVoList) {
        ticketCounts.forEach(ticketCountCommon -> {
            // 实例化对象
            TicketCountVo ticketCountVo = new TicketCountVo();
            mapper.map(ticketCountCommon, ticketCountVo);

            // 获取礼券信息
            AdTicket infoActivityCertificate = infoActivityCertificateMap.get(ticketCountVo.getCertificateid());
            if (infoActivityCertificate != null) {
                // 获取广告主ID
                String adshop = infoActivityCertificate.getAdvertiser()+"";
                if (StringUtil.isNotEmpty(adshop)) {
                    // 整合广告主信息
                    ticketCountVo.setAdvertiserName(mapAdvertiser.get(Integer.valueOf(adshop)));
                    // 整合AE信息
                    ticketCountVo.setAEName(mapAe.get(infoActivityCertificate.getId().intValue()));
                }
                // 整合券名称
                ticketCountVo.setCertificateName(infoActivityCertificate.getName());
            }
            ticketCountVoList.add(ticketCountVo);

        });
    }

    @Override
    public Page<TicketAppVo> findTicketAppCount(String datetime, Long certificateid, String keyword, Integer pageNum,
                                                Integer pageSize, String sortName, String sortType) throws IOException {
        // 1、根据关键字查询出开发者的信息
        List<InfoAppMsg> adpositionVos = Lists.newArrayList();
        Map<String, InfoAppMsg> infoAppMsgMap = Maps.newHashMap();
        // 2、声明一个集合用于封装appKeys
        List<String> appKeyList = Lists.newArrayList();
        StringBuffer appKeys = new StringBuffer("");
        // 3、把所有查询出的所有appKey添加至appKeys
        if (StringUtils.isNotEmpty(keyword)) {
            adpositionVos = infoAppMsgService.findAllAppkeys(keyword, null);
            if (CollectionUtils.isNotEmpty(adpositionVos)) {
                adpositionVos.stream().forEach(infoAppMsg -> {
                    appKeyList.add(infoAppMsg.getAppkey());
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                    appKeys.append(infoAppMsg.getAppkey() + ",");
                });
            } else {
                return new Page<TicketAppVo>();
            }
        }
        // 4、把解析过后的appKeys赋值给appKeysJson
        // 5、调用datapark
        Page<TicketCountCommon> ticketCountCommonPage = dataParkTicketPullerIntegration.getTicketAppCount(datetime,
                                                                                                          certificateid,
                                                                                                          JSON.toJSONString(appKeyList),
                                                                                                          pageNum,
                                                                                                          pageSize,
                                                                                                          sortName,
                                                                                                          sortType);
        // 6、整合开发者信息
        List<TicketCountCommon> listTemp = ticketCountCommonPage.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接appkey
            getAppKeys(keyword, infoAppMsgMap, appKeyList, appKeys, listTemp);
        } else {
            return new Page<TicketAppVo>();
        }
        // 6、查询开发者子链接数
        Map<String, Integer> businessNumberMaps = adPositionService.getBusinessNumberByAppKeys(appKeyList);
        // 7、把相关信息复制到新实例化的结果集
        Page<TicketAppVo> appCountPageRs = new Page<TicketAppVo>();
        mapper.map(ticketCountCommonPage, appCountPageRs);
        List<TicketAppVo> list = new ArrayList<TicketAppVo>();
        if (appCountPageRs != null && CollectionUtils.isNotEmpty(listTemp)) {
            listTemp.stream().forEach(ticketCountCommon -> {
                // 实例化
                TicketAppVo ticketAppVo = new TicketAppVo();
                // 复制属性
                mapper.map(ticketCountCommon, ticketAppVo);
                ticketAppVo.setAppKey(ticketCountCommon.getAppkey());
                // 获取开发者名称并存入对象
                ticketAppVo.setAppName(infoAppMsgMap.getOrDefault(ticketAppVo.getAppKey(),
                                                                  new InfoAppMsg()).getAppname());
                // 获取开发者子链接数并存入对象
                Integer businessNumber = businessNumberMaps.getOrDefault(ticketCountCommon.getAppkey(),
                                                                         Integer.valueOf(ReportConstant.ZERO_S));
                ticketAppVo.setBusinessNumber(businessNumber == null ? "" : businessNumber.toString());
                // 存入集合
                list.add(ticketAppVo);
                // 放入结果集
            });
            appCountPageRs.setList(list);
        }
        // 8、返回结果集
        return appCountPageRs;
    }

    @Override
    public List<TicketAppVo> findTicketAppCountExport(String datetime, Long certificateid,
                                                      String keyword) throws IOException {
        // 1、根据关键字查询出开发者的信息
        List<InfoAppMsg> adpositionVos = Lists.newArrayList();
        Map<String, InfoAppMsg> infoAppMsgMap = Maps.newHashMap();
        // 2、声明一个集合用于封装appKeys
        List<String> appKeyList = Lists.newArrayList();
        StringBuffer appKeys = new StringBuffer("");
        // 3、把所有查询出的所有appKey添加至appKeys
        if (StringUtils.isNotEmpty(keyword)) {
            adpositionVos = infoAppMsgService.findAllAppkeys(keyword, null);
            if (CollectionUtils.isNotEmpty(adpositionVos)) {
                adpositionVos.stream().forEach(infoAppMsg -> {
                    appKeyList.add(infoAppMsg.getAppkey());
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                    appKeys.append(infoAppMsg.getAppkey() + ",");
                });
            } else {
                return new ArrayList<TicketAppVo>();
            }
        }
        // 4、把解析过后的appKeys赋值给appKeysJson
        // 5、调用datapark
        List<TicketCountCommon> ticketAppCounts = dataParkTicketPullerIntegration.getTicketAppCount(datetime,
                                                                                                    certificateid,
                                                                                                    JSON.toJSONString(appKeyList));
        // 6、整合开发者信息
        if (CollectionUtils.isNotEmpty(ticketAppCounts)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接appkey
            getAppKeys(keyword, infoAppMsgMap, appKeyList, appKeys, ticketAppCounts);
        } else {
            return new ArrayList<TicketAppVo>();
        }
        // 7、查询开发者子链接数
        Map<String, Integer> businessNumberMaps = adPositionService.getBusinessNumberByAppKeys(appKeyList);
        // 8、把相关信息复制到新实例化的结果集
        List<TicketAppVo> ticketAppVos = new ArrayList<TicketAppVo>();
        if (CollectionUtils.isNotEmpty(ticketAppCounts)) {
            ticketAppCounts.stream().forEach(ticketCountCommon -> {
                TicketAppVo appBusinessVo = new TicketAppVo();
                mapper.map(ticketCountCommon, appBusinessVo);
                appBusinessVo.setAppKey(ticketCountCommon.getAppkey());
                appBusinessVo.setAppName(infoAppMsgMap.getOrDefault(appBusinessVo.getAppKey(),
                                                                    new InfoAppMsg()).getAppname());
                // 获取开发者子链接数并存入对象
                Integer businessNumber = businessNumberMaps.getOrDefault(ticketCountCommon.getAppkey(),
                                                                         Integer.valueOf(ReportConstant.ZERO_S));
                appBusinessVo.setBusinessNumber(businessNumber == null ? "" : businessNumber.toString());
                ticketAppVos.add(appBusinessVo);
            });
        }
        return ticketAppVos;
    }

    private void getAppKeys(String keyword, Map<String, InfoAppMsg> infoAppMsgMap, List<String> appKeyList,
                            StringBuffer appKeys, List<TicketCountCommon> ticketAppCounts) {
        if (StringUtils.isEmpty(keyword)) {
            ticketAppCounts.stream().forEach(ticketCountCommon -> {
                appKeys.append(ticketCountCommon.getAppkey() + ",");
                appKeyList.add(ticketCountCommon.getAppkey());
            });
            List<InfoAppMsg> infoAppByAppkeys = infoAppMsgService.findInfoAppByAppkeys(appKeys);
            if (CollectionUtils.isNotEmpty(infoAppByAppkeys)) {
                infoAppByAppkeys.stream().forEach(infoAppMsg -> {
                    infoAppMsgMap.put(infoAppMsg.getAppkey(), infoAppMsg);
                });
            }
        }
    }

    @Override
    public Page<TicketAppBusinessVo> findTicketAppBusinessCount(String datetime, Long certificateid, String appKey,
                                                                String keyword, Integer pageNum, Integer pageSize,
                                                                String sortName, String sortType) throws IOException {
        List<AdpositionVo> adpositionVos = Lists.newArrayList();
        // 1、根据关键字查询出子链接的信息
        // 2、声明一个集合用于封装子链接
        List<String> businesses = Lists.newArrayList();
        Map<String, AdpositionVo> adpositionVoMap = Maps.newHashMap();
        // 3、把所有查询出的所有子链接添加至businesses,并把对象添加至map集合
        StringBuffer sbBusinesses = new StringBuffer("");
        if (StringUtils.isNotEmpty(keyword)) {
            adpositionVos = adPositionService.findBusinesses(appKey, keyword, null, null);
            if (CollectionUtils.isNotEmpty(adpositionVos)) {
                // 处理信息
                dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
            } else {
                return new Page<TicketAppBusinessVo>();
            }
        }
        Page<TicketCountCommon> ticketAppBusinessCount = dataParkTicketPullerIntegration.getTicketAppBusinessCount(datetime,
                                                                                                                   certificateid,
                                                                                                                   appKey,
                                                                                                                   JSON.toJSONString(businesses),
                                                                                                                   pageNum,
                                                                                                                   pageSize,
                                                                                                                   sortName,
                                                                                                                   sortType);
        // 5、把数据添加到新的结果集
        List<TicketCountCommon> listTemp = ticketAppBusinessCount.getList();
        if (CollectionUtils.isNotEmpty(listTemp)) {
            // 如果关键字为空,且listTemp集合不为空，则从datapark返回的数据拼接businesses
            getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, listTemp);
        } else {
            return new Page<TicketAppBusinessVo>();
        }

        List<TicketAppBusinessVo> list = new ArrayList<TicketAppBusinessVo>();
        // 6、声明并实例化结果集
        Page<TicketAppBusinessVo> appBusinessPageRs = new Page<TicketAppBusinessVo>();
        mapper.map(ticketAppBusinessCount, appBusinessPageRs);
        if (CollectionUtils.isNotEmpty(listTemp)) {
            listTemp.stream().forEach(ticketCountCommon -> {
                // 实例化
                TicketAppBusinessVo ticketAppBusinessVo = new TicketAppBusinessVo();
                // 复制属性
                mapper.map(ticketCountCommon, ticketAppBusinessVo);
                // 获取子链接名称并放入对象
                if (StringUtils.isNotEmpty(ticketAppBusinessVo.getBusiness())) {
                    ticketAppBusinessVo.setBusinessName(adpositionVoMap.getOrDefault(ticketAppBusinessVo.getBusiness().replaceAll("ad-",
                                                                                                                                  ""),
                                                                                     new AdpositionVo()).getName());
                }
                list.add(ticketAppBusinessVo);
            });
            appBusinessPageRs.setList(list);
        }
        // 7、返回结果集
        return appBusinessPageRs;
    }

    @Override
    public List<TicketAppBusinessVo> findTicketAppBusinessCountExport(String datetime, Long certificateid,
                                                                      String appKey,
                                                                      String keyword) throws IOException {
        List<AdpositionVo> adpositionVos = Lists.newArrayList();
        // 1、根据关键字查询出子链接的信息
        // 2、声明一个集合用于封装子链接
        List<String> businesses = Lists.newArrayList();
        Map<String, AdpositionVo> adpositionVoMap = Maps.newHashMap();
        // 3、把所有查询出的所有子链接添加至businesses,并把对象添加至map集合
        StringBuffer sbBusinesses = new StringBuffer("");
        if (StringUtils.isNotEmpty(keyword)) {
            adpositionVos = adPositionService.findBusinesses(appKey, keyword, null, null);
            if (CollectionUtils.isNotEmpty(adpositionVos)) {
                // 处理信息
                dealBusiness(adpositionVos, businesses, adpositionVoMap, sbBusinesses);
            } else {
                return new ArrayList<TicketAppBusinessVo>();
            }
        }
        List<TicketCountCommon> ticketCountCommons = dataParkTicketPullerIntegration.getTicketAppBusinessCountNew(datetime,
                                                                                                                  certificateid,
                                                                                                                  appKey,
                                                                                                                  JSON.toJSONString(businesses));
        if (CollectionUtils.isNotEmpty(ticketCountCommons)) {
            // 如果关键字为空,且ticketCountCommons集合不为空，则从datapark返回的数据拼接businesses
            getBusinesses(appKey, keyword, adpositionVoMap, sbBusinesses, ticketCountCommons);
        } else {
            return new ArrayList<TicketAppBusinessVo>();
        }
        // 5、声明并实例化结果集
        List<TicketAppBusinessVo> appBusinessList = new ArrayList<>();
        // 6、把数据添加到新的集合
        if (CollectionUtils.isNotEmpty(ticketCountCommons)) {
            for (TicketCountCommon ticketCountCommon : ticketCountCommons) {
                // 实例化
                TicketAppBusinessVo ticketAppBusinessVo = new TicketAppBusinessVo();
                // 复制属性
                mapper.map(ticketCountCommon, ticketAppBusinessVo);
                // 获取子链接名称并放入对象
                if (StringUtils.isNotEmpty(ticketAppBusinessVo.getBusiness())) {
                    ticketAppBusinessVo.setBusinessName(adpositionVoMap.getOrDefault(ticketAppBusinessVo.getBusiness().replaceAll("ad-",
                                                                                                                                  ""),
                                                                                     new AdpositionVo()).getName());
                }
                appBusinessList.add(ticketAppBusinessVo);
            }
        }
        // 9、返回结果集
        return appBusinessList;
    }

    private void dealBusiness(List<AdpositionVo> adpositionVos, List<String> businesses,
                              Map<String, AdpositionVo> adpositionVoMap, StringBuffer sbBusinesses) {
        adpositionVos.stream().forEach(adpositionVo -> {
            businesses.add("ad-" + adpositionVo.getBusiness().replaceAll("ad-", ""));
            adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), adpositionVo);
            sbBusinesses.append(adpositionVo.getBusiness().replaceAll("ad-", "") + ",");
        });
    }

    private void getBusinesses(String appKey, String keyword, Map<String, AdpositionVo> adpositionVoMap,
                               StringBuffer sbBusinesses, List<TicketCountCommon> ticketCountCommons) {
        if (StringUtils.isEmpty(keyword)) {
            ticketCountCommons.stream().forEach(ticketCountCommon -> {
                if (ticketCountCommon.getBusiness() != null) {
                    sbBusinesses.append(ticketCountCommon.getBusiness() + ",");
                }
            });
            List<AdpositionVo> byBusinesses = adPositionService.findByBusinesses(appKey, sbBusinesses);
            if (CollectionUtils.isNotEmpty(byBusinesses)) {
                byBusinesses.stream().forEach(adpositionVo -> {
                    if (adpositionVo.getBusiness() != null) {
                        adpositionVoMap.put(adpositionVo.getBusiness().replaceAll("ad-", ""), adpositionVo);
                    }
                });
            }
        }
    }

    @Override
    public List<TicketDateVo> findTicketCountDate(String startTime, String endTime, Long certificateid, String sortName,
                                                  String sortType) throws IOException {

        // 从datapark获取信息
        List<TicketCountCommon> ticketCountCommons = dataParkTicketPullerIntegration.getTicketCountDate(startTime,
                                                                                                        endTime,
                                                                                                        certificateid,
                                                                                                        sortName,
                                                                                                        sortType);

        // 声明并实例化结果集
        List<TicketDateVo> ticketDateVos = new ArrayList<TicketDateVo>();
        // 整合信息
        if (CollectionUtils.isNotEmpty(ticketCountCommons)) {
            ticketCountCommons.stream().forEach(ticketCountCommon -> {
                TicketDateVo ticketDateVo = new TicketDateVo();
                mapper.map(ticketCountCommon, ticketDateVo);
                ticketDateVos.add(ticketDateVo);
            });
        }
        return ticketDateVos;
    }

}
