package com.bxm.report.service.tbltag;

import com.alibaba.fastjson.JSONObject;
import com.bxm.report.model.dao.tbltag.TblAdPostionTag;
import com.bxm.report.model.dto.tbltag.TblAdTagDto;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import com.github.pagehelper.PageInfo;

import java.util.List;


/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.tbltag.TblAdTagService.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-25 16:57:00
 * @modifier ganquan
 * @updated 2018-04-25 16:57:00
 */
public interface TblAdTagService {

    /**
     * 根据类型查询 标签集合
     * 
     * @param type 1 多选标签 2 层级标签
     * @return
     */
    public List<TblAdTagVo> findTblAdTagListByType(Integer parentId, Integer type);

    /**
     * 根据 Id返回 子集合
     * 
     * @param parentId
     * @return
     */
    public List<TblAdTagVo> findTblAdTagById(Integer parentId);

    public TblAdTagVo updateFindTblAdTag(Integer id, Integer type);

    /**
     * 新增标签
     * 
     * @param tblAdTag
     * @return
     */
    public boolean addTag(TblAdPostionTag tblAdTag) throws Exception;

    /**
     * 修改标签
     * 
     * @param tblAdTagDto
     * @return
     */
    public Boolean updateTag(TblAdTagDto tblAdTagDto, String user);

    public PageInfo<TblAdTagVo> findfindTblAdTagByNameAndID(String param, String type);

    public PageInfo<TblAdTagVo> findAll(Integer pageNum, Integer pageSize, String name);

    public JSONObject findTblAdTagByCodeStr(String str);

    /**
     * 查找一级标签
     * 
     * @param
     * @return
     */
    public List<TblAdTagVo> tblTagByFirstCode();

    /**
     * 根据条件查找标签
     * 
     * @param
     * @return
     */
    public PageInfo<TblAdTagVo> findNewTreeAll(Integer pageNum, Integer pageSize, Integer type, String name, Integer parentId);
    
    public PageInfo<TblAdTagVo> findNewAll(Integer pageNum, Integer pageSize, String name, Integer type);

    /**
     * Description: 查询一级标签
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/26 16:33
     */
    List<TblAdPostionTag> findOneLevelTag(Integer tagType);

}
