package com.bxm.report.service.tbltag.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.dao.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.report.model.constant.TicketConstant;
import com.bxm.report.model.dao.tbltag.TblAdPostionTag;
import com.bxm.report.model.dto.tbltag.TblAdTagDto;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import com.bxm.report.service.tbltag.TblAdTagService;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author gaoshihao
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.service.tbltag.impl.TblAdTagServiceImpl.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-25 17:00:00
 * @modifier gaoshihao
 * @updated 2018-04-25 17:00:00
 */
@Service
public class TblAdTagServiceImpl implements TblAdTagService {

    @Autowired
    private TblAdPostionTagMapperExt tblAdTagMapperExt;

    List<TblAdTagVo>                 parentList = null;

    /**
     * 根据类型查询标签集合(所有)
     * 
     * @param type 1 多选标签 2 层级标签
     * @return
     */
    @Override
    public List<TblAdTagVo> findTblAdTagListByType(Integer parentId, Integer type) {
        List<TblAdTagVo> list = recursiveFindTblAdTag(parentId, type);
        return list;
    }

    /**
     * 根据id 返回所有 子集合
     * 
     * @param parentId
     * @return
     */
    @Override
    public List<TblAdTagVo> findTblAdTagById(Integer parentId) {

        List<TblAdTagVo> list = tblAdTagMapperExt.findTblAdTagList(parentId, 2, null);

        return list;
    }

    /**
     * 根据 id 返回实体(修改时使用)
     * 
     * @param id
     * @return
     */
    @Override
    public TblAdTagVo updateFindTblAdTag(Integer id, Integer type) {
        parentList = new ArrayList<TblAdTagVo>();
        TblAdTagVo tblAdTag = tblAdTagMapperExt.selectByPrimaryKey(id);
        if (tblAdTag.getParentId() == 0) {
            return tblAdTag;
        } else {
            List<TblAdTagVo> parentList = findParentList(tblAdTag.getId(), "1");
            parentList.stream().forEach(vo -> {
                vo.setBrotherList(tblAdTagMapperExt.findTblAdTagList(vo.getParentId(), type, null));
            });
            tblAdTag.setParentList(parentList);
            tblAdTag.setBrotherList(tblAdTagMapperExt.findTblAdTagList(tblAdTag.getParentId(), type, null));

        }
        return tblAdTag;
    }

    /**
     * 新增 标签
     * 
     * @param tblAdTag
     * @return
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED, isolation = Isolation.DEFAULT, timeout = 36000, rollbackFor = Exception.class)
    public boolean addTag(TblAdPostionTag tblAdTag) throws ValidateException {

        TblAdTagVo tblAdTagVo = this.findParentTag(tblAdTag.getParentId());
        Integer code = tblAdTagMapperExt.findMaxCode();
        tblAdTag.setCode(code + 1);
        tblAdTag.setCreateTime(new Date());
        this.buildTagFullInfo(tblAdTag, tblAdTagVo);
        return tblAdTagMapperExt.insert(tblAdTag) > 0;

    }

    /**
     * 修改 标签
     * 
     * @param tblAdTagDto
     * @return
     * @throws ValidateException
     */
    @Transactional(propagation = Propagation.REQUIRED, isolation = Isolation.DEFAULT, timeout = 36000, rollbackFor = Exception.class)
    @Override
    public Boolean updateTag(TblAdTagDto tblAdTagDto, String user) throws ValidateException {

        TblAdTagVo entity = tblAdTagMapperExt.selectByPrimaryKey(tblAdTagDto.getId());
        if (null == entity) {
            throw new NullPointerException("未查询到标签！");
        }

        TblAdTagVo tblAdTagVo = this.findParentTag(tblAdTagDto.getParentId());
        TblAdPostionTag tblAdTag = new TblAdPostionTag();
        BeanUtils.copyProperties(tblAdTagDto, tblAdTag);
        tblAdTag.setModifyUser(user);
        tblAdTag.setModifyTime(new Date());
        this.buildTagFullInfo(entity, tblAdTagVo);
        tblAdTag.setFullCodePath(entity.getFullCodePath());
        tblAdTag.setFullNameStr(entity.getFullNameStr());
        return tblAdTagMapperExt.updateByPrimaryKeySelective(tblAdTag) > 0;
    }

    private TblAdTagVo findParentTag(Integer parentId){
        TblAdTagVo tblAdTagVo = null;
        if (!parentId.equals(TicketConstant.TicketTag.BASIC_PARENT_ID)) {
            tblAdTagVo = tblAdTagMapperExt.selectByPrimaryKey(parentId);
            if (null == tblAdTagVo){
                throw new NullPointerException("未查询到父标签！");
            }
        }
        return tblAdTagVo;
    }

    /**
     * Description: 给标签的完整code 和 名称 两个字段赋值
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/23 20:25
     */
    private void buildTagFullInfo(TblAdPostionTag entity, TblAdPostionTag parent) {
        if (null != parent) {
            entity.setFullCodePath(StringUtils.join(parent.getFullCodePath(), entity.getCode(), "."));
            entity.setFullNameStr(StringUtils.join(parent.getFullNameStr(), entity.getName(), "."));
        } else {
            entity.setFullCodePath(entity.getCode().toString() + ".");
            entity.setFullNameStr(entity.getName() + ".");
        }
    }

    /**
     * 获取所有标签子标签
     * 
     * @param parentId
     * @param type
     * @return
     */
    private List<TblAdTagVo> recursiveFindTblAdTag(Integer parentId, Integer type) {
        List<TblAdTagVo> list = null;
        if (type == 1) {
            return tblAdTagMapperExt.findTblAdTagList(0, 1, null);
        } else {
            list = tblAdTagMapperExt.findTblAdTagList(parentId, type, null);
            if (list == null) {
                return null;
            }
            list.stream().forEach((vo) -> {
                List<TblAdTagVo> childList = recursiveFindTblAdTag(vo.getId(), type);
                vo.setChildList(childList);
            });

        }
        return list;
    }

    /**
     * 返回 实体的父类列表
     * 
     * @param id
     * @param type
     * @return
     */
    private List<TblAdTagVo> findParentList(Integer id, String type) {
        TblAdTagVo tblAdTagVo = tblAdTagMapperExt.selectByPrimaryKey(id);
        if (!type.equals("1")) {
            parentList.add(tblAdTagVo);
        }
        if (tblAdTagVo.getParentId() == 0) {
            return parentList;
        }
        findParentList(tblAdTagVo.getParentId(), type);
        return parentList;
    }

    /**
     * 根据id/name查询
     * 
     * @param param id/name
     * @param type 1 包含 自身 2 不包含自身
     * @return
     */
    @Override
    public PageInfo<TblAdTagVo> findfindTblAdTagByNameAndID(String param, String type) {
        Map<String, String> paramMap = new HashMap<>();
        if (StringUtils.isNotEmpty(param)) {
            paramMap.put("param", param);
        } else {
            paramMap.put("param", "");
        }
        List<TblAdTagVo> list = tblAdTagMapperExt.findTblAdTagChildByName(paramMap);
        // 查询不带子集合
        TblAdTagVo tblAdTagVo = tblAdTagMapperExt.findTblAdTagByName(paramMap);
        if (tblAdTagVo == null) {
            return null;
        }
        list = getLabelList(type, list, tblAdTagVo);
        return new PageInfo<>(list);
    }

    @Override
    public PageInfo<TblAdTagVo> findAll(Integer pageNum, Integer pageSize, String name) {
        if (StringUtils.isNotEmpty(pageNum + "") && StringUtils.isNotEmpty(pageSize + "")) {
            PageHelper.startPage(pageNum, pageSize);
        }
        List<TblAdTagVo> list = tblAdTagMapperExt.findTblAdTagList(-1, 2, name);
        PageInfo<TblAdTagVo> page = new PageInfo<TblAdTagVo>(list);
        page.setList(getLabelList("1", list, null));
        return page;
    }

    /**
     * 根据 codestr 查询标签
     * 
     * @param str
     * @return
     */
    @Override
    public JSONObject findTblAdTagByCodeStr(String str) {
        List<TblAdTagVo> categoryLableList = new ArrayList<>();
        List<TblAdTagVo> attrlableList = new ArrayList<>();
        JSONObject entity = new JSONObject();
        String[] codes = str.split(",");
        Arrays.stream(codes).forEach(code -> {
            parentList = new ArrayList<>();
            Map<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("codestr", code);
            TblAdTagVo tblAdTagVo = tblAdTagMapperExt.findTblAdTagByName(paramMap);
            if (tblAdTagVo != null) {
                if (tblAdTagVo.getTypeTag() == 1) {
                    attrlableList.add(tblAdTagVo);
                } else {
                    if (tblAdTagVo.getParentId() == 0) {
                        categoryLableList.add(tblAdTagVo);
                    } else {
                        List<TblAdTagVo> parentList = findParentList(tblAdTagVo.getParentId(), "2");
                        tblAdTagVo.setParentList(parentList);
                        categoryLableList.add(tblAdTagVo);
                    }
                }
            }
        });
        entity.put("attributeLable", attrlableList);
        entity.put("categoryLagle", categoryLableList);
        return entity;
    }

    private List<TblAdTagVo> getLabelList(String type, List<TblAdTagVo> list, TblAdTagVo tblAdTagVo) {
        if (type.equals("1")) {
            if (tblAdTagVo != null) {
                list.add(tblAdTagVo);
            }

        } else {
            list.stream().sorted(Comparator.comparing(TblAdTagVo::getCode)).forEach(vo -> {
                vo.setBrotherList(null);
                vo.setParentList(null);
                vo.setChildList(null);
            });
        }
        list.stream().forEach(vo -> {
            parentList = new ArrayList<>();
            vo.setBrotherList(null);
            vo.setParentList(null);
            vo.setChildList(null);
            if (vo.getParentId() == 0) {
                vo.setParentFirstName("--");
                vo.setParentScendName("--");
            } else {
                List<TblAdTagVo> listchile = findParentList(vo.getId(), "2");
                listchile = listchile.stream().filter(childvo -> !childvo.getName().equals(vo.getName())).collect(Collectors.toList());
                listchile = listchile.stream().sorted(Comparator.comparing(TblAdTagVo::getCode)).collect(Collectors.toList());
                if (listchile.size() > 1) {
                    vo.setParentFirstName(listchile.get(0).getName());
                    vo.setParentScendName(listchile.get(1).getName());
                } else {
                    vo.setParentFirstName(listchile.get(0).getName());
                    vo.setParentScendName("--");
                }
            }
        });
        list = list.stream().sorted(Comparator.comparing(TblAdTagVo::getId)).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<TblAdTagVo> tblTagByFirstCode() {
        return tblAdTagMapperExt.tblTagByFirstCode();
    }

    @Override
    public PageInfo<TblAdTagVo> findNewTreeAll(Integer pageNum, Integer pageSize, Integer type, String name,
                                               Integer parentId) {
        PageHelper.startPage(pageNum, pageSize);
        List<TblAdTagVo> list = new ArrayList<>();
        //下面是递归查找标签
        list = findNewTreeAllTblAdTag(parentId, type,name);
        PageInfo<TblAdTagVo> page = new PageInfo<TblAdTagVo>(list);
        return page;
    } 
    /**
     * 获取所有标签子标签
     * 
     * @param parentId
     * @param type
     * @return
     */
    private List<TblAdTagVo> findNewTreeAllTblAdTag(Integer parentId, Integer type,String name) {
        List<TblAdTagVo> list = null;
        if (type == 1) {
            return tblAdTagMapperExt.findTblAdTagList(0, type, name);
        } else {
            list = tblAdTagMapperExt.findTblAdTagList(parentId, type, name);
            if (list == null) {
                return null;
            }
            list.stream().forEach((vo) -> {
                //递归子标签就没有按照名称搜索
                List<TblAdTagVo> childList = findNewTreeAllTblAdTag(vo.getId(), type,null);
                vo.setChildList(childList);
            });

        }
        return list;
    }
    
    @Override
    public PageInfo<TblAdTagVo> findNewAll(Integer pageNum, Integer pageSize, String name, Integer type) {
        if (StringUtils.isNotEmpty(pageNum + "") && StringUtils.isNotEmpty(pageSize + "")) {
            PageHelper.startPage(pageNum, pageSize);
        }
        List<TblAdTagVo> list = tblAdTagMapperExt.findTblAdTagList(-1, type, name);
        PageInfo<TblAdTagVo> page = new PageInfo<TblAdTagVo>(list);
        page.setList(getNewLabelList("1", list, null,type));
        return page;
    }

    @Override
    public List<TblAdPostionTag> findOneLevelTag(Integer tagType) {
        return tblAdTagMapperExt.findOneLevelTag(tagType);
    }

    private List<TblAdTagVo> getNewLabelList(String bs, List<TblAdTagVo> list, TblAdTagVo tblAdTagVo,Integer type) {
        if (bs.equals("1")) {
            if (tblAdTagVo != null) {
                list.add(tblAdTagVo);
            }

        } else {
            list.stream().sorted(Comparator.comparing(TblAdTagVo::getCode)).forEach(vo -> {
                vo.setBrotherList(null);
                vo.setParentList(null);
                vo.setChildList(null);
            });
        }
        list.stream().forEach(vo -> {
            parentList = new ArrayList<>();
            vo.setBrotherList(null);
            vo.setParentList(null);
            vo.setChildList(null);
            if (vo.getParentId() == 0) {
                vo.setParentFirstName("--");
                vo.setParentScendName("--");
            } else {
             
                List<TblAdTagVo> listchile = findParentList(vo.getId(), type+"");
                listchile = listchile.stream().filter(childvo -> !childvo.getName().equals(vo.getName())).collect(Collectors.toList());
                listchile = listchile.stream().sorted(Comparator.comparing(TblAdTagVo::getCode)).collect(Collectors.toList());
                if (listchile.size() > 1) {
                    vo.setParentFirstName(listchile.get(0).getName());
                    vo.setParentScendName(listchile.get(1).getName());
                } else {
                    vo.setParentFirstName(listchile.get(0).getName());
                    vo.setParentScendName("--");
                }
            }
        });
        list = list.stream().sorted(Comparator.comparing(TblAdTagVo::getId)).collect(Collectors.toList());
        return list;
    }
}
