package com.bxm.report.service.utils;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/26 10:20
 * 修 改 人：
 * 日 期：
 * 描 述： 集合对象 copy工具类
 * 版 本 号： v1
 */
public class CollectionDataCopyUtil {


    /**
     * Description: sources:资源集合， clazz:目标对象类
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/26 14:10
     */
    public static <T> List<T> copyList(List<?> sources, Class<T> clazz) {
        if (CollectionUtils.isEmpty(sources)) {
            return Collections.emptyList();
        }
        List<T> result = new ArrayList<>(sources.size());
        try {
            for (Object source : sources) {
                T target = clazz.newInstance();
                BeanUtils.copyProperties(source, target);
                result.add(target);
            }

        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("copy list fail!");
        }
        return result;
    }

}
