package com.bxm.report.service.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * 日期工具类
 *
 * @ClassName DateFormatUtil
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/4 16:52
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/4 16:52
 **/
public class DateFormatUtil {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    /**
     * String 格式的时间 yyyy-MM-dd 转化为毫秒
     *
     * @param date
     * @return java.lang.Long
     * @throws
     * @author kk.xie
     * @date 2018/7/4 16:55
     */
    public static Long getMillisecondByDate(String date){
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    /**
     * String 格式的时间 yyyy-MM-dd 转化为毫秒 加1天
     *
     * @param date
     * @return java.lang.Long
     * @throws
     * @author kk.xie
     * @date 2018/7/4 19:05
     */
    public static Long getMillisecondByPlusDate(String date, long days){
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        localDateTime = localDateTime.plusDays(days);
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    /**
     * String 格式的时间 yyyy-MM-dd 转化为毫秒 加1天
     *
     * @param date
     * @return java.lang.Long
     * @throws
     * @author kk.xie
     * @date 2018/7/4 19:05
     */
    public static Long getMillisecondByMinusDate(String date, long days){
        LocalDateTime localDateTime = LocalDateTime.from(LocalDate.parse(date, dateTimeFormatter).atStartOfDay());
        localDateTime = localDateTime.minusDays(days);
        long timestamp = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timestamp;
    }

    /**
     * 获取Date的小时
     *
     * @param date
     * @return int
     * @throws
     * @author kk.xie
     * @date 2018/7/4 19:05
     */
    public static int getDateHour(Date date){
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.getHour();
    }
}
