package com.bxm.report.service.utils;

import com.bxm.util.StringUtil;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateParkUtil {





    /**
     * 计算arpu或ecpm
     * */
    public static Double getArpuOrEcpm(Double income , Integer number){
        if (number==null || number.intValue()==0 || income==null){
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        String sArpu = df.format(income/(double)number);
        return Double.parseDouble(sArpu);
    }
    public static Double getArpuOrEcpm(String income , Integer number){
        if (number==null || number.intValue()==0 || income==null){
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        Integer aIncome = Integer.parseInt(income);
        String sarpu = df.format((double)aIncome/number);
        return Double.parseDouble(sarpu);
    }


    /**
     * 获取后一天或前一天
     *
     * @param dateTime
     * @return
     */
    public static String getNextDate(String dateTime) {
        return getDate(dateTime, 1);
    }

    public static String getPreDate(String dateTime) {
        return getDate(dateTime, -1);
    }

    public static String getDate(String dateTime, Integer amount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(sdf.parse(dateTime));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.add(Calendar.DATE, amount);
        return sdf.format(calendar.getTime());
    }

    /**
     * 计算涨幅度
     *
     * @author
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param pre
     * @param now
     * @return java.lang.String
     */
    public static String dealChange(BigDecimal pre, BigDecimal now){
        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || Integer.valueOf(0).doubleValue()==pre.doubleValue()) {
            return "-";
        }
        return formatDouble((now.doubleValue() - pre.doubleValue()) * Integer.valueOf(100) /  pre.doubleValue()) + "%";
    }
    public static Double dealChangeDouble(BigDecimal pre,BigDecimal now){
        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || Integer.valueOf(0).doubleValue()==pre.doubleValue()) {
            return null;
        }
        return  Double.valueOf(formatDouble((now.doubleValue() - pre.doubleValue()) * Integer.valueOf(100) /  pre.doubleValue()));
    }
    public static Double dealChangeDouble(Double pre,BigDecimal now){
        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || Integer.valueOf(0).doubleValue()==pre.doubleValue()) {
            return null;
        }
        return  Double.valueOf(formatDouble((now.doubleValue() - pre.doubleValue()) * Integer.valueOf(100) /  pre.doubleValue()));
    }
    public static String dealChange(Double pre,Double now){

        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || Integer.valueOf(0).doubleValue()==pre.doubleValue() ) {
            return "-";
        }
        return formatDouble((now - pre) * 100 / pre);
    }
    public static String dealChange(Integer pre,Integer now){

        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || "0".equals(pre)) {
            return "-";
        }
        return formatDouble((now - pre) * 100 / (double) pre) + "%";
    }


    /**
     * 保留两位小数
     *
     * @param d
     * @return
     */
    public static String formatDouble(Double d) {
        return formatDouble(d, "#.00");
    }
    public static String formatDouble(Double d, String fomat) {
        DecimalFormat df = new DecimalFormat(fomat);
        String rs = df.format(d);
        if (rs.indexOf("-") != Integer.valueOf(-1).intValue()) {
            return rs.indexOf(".") == Integer.valueOf(1).intValue() ? rs.replaceFirst("-", "-0") : rs;
        } else {
            return rs.indexOf(".") == Integer.valueOf(0).intValue() ? "-0" + rs : rs;
        }
    }
}
