package com.bxm.report.service.utils;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.util.StringUtil;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/28 14:54
 */
public class DoubleUtil {
    private static NumberFormat formatter;

    static {
        formatter = DecimalFormat.getPercentInstance();
        formatter.setMaximumFractionDigits(2);
    }

	/**
	 * @description 两个数据相除，保留两位小数
	 * @author hcmony
	 * @time 2017/12/20
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param num1
	 * @param num2
	 * @return java.lang.Double
	 */
	public static Double formatDouble(String num1,String num2) {

		if(StringUtils.isBlank(num1)||StringUtils.isBlank(num2)){
			return null;
		}
		if(!(StringUtil.isPositiveNumber(num1))||!(StringUtil.isPositiveNumber(num2))){
			return null;
		}

		BigDecimal b1 = new BigDecimal(Double.valueOf(num1));
		BigDecimal b2 = new BigDecimal(Double.valueOf(num2));
		double num = 0.00;
		if(b2.compareTo(new BigDecimal(BigInteger.ZERO))!=0){
			num = b1.divide(b2,BigDecimal.ROUND_HALF_UP,BigDecimal.ROUND_DOWN  ).multiply(new BigDecimal(100)).doubleValue();
		}
		return num;
	}

	/**
	 *两数据相加
	 * */
	public static Double doubleSum(Double num1,Double num2){

		BigDecimal b1 = new BigDecimal(num1.toString());
		BigDecimal b2 = new BigDecimal(num2.toString());
		return new Double(b1.add(b2).doubleValue());

	}
	public static String percent(Double number){
	    if (number == null){
	        return null;
        }
        return formatter.format(number);
    }

}
