package com.bxm.report.service.utils;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */



import java.util.List;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/26 11:29
 */
public class ListUtil {

	/**
	 * @description 将数据分页
	 * @author hcmony
	 * @time 2017/12/26
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param obj
	 * @param listSize
	 * @param startNum
	 * @param endNum
	 * @return java.util.List<T>
	 */
	public static  <T> List<T> getTotalPage(List<T> obj , int listSize, int startNum, int endNum) {
		// 总的页数
		int pageCount = 0;
        /* 计算出总共能分成多少页 */
		if (listSize % endNum > 0) // 数据总数和每页显示的总数不能整除的情况
		{
			pageCount = listSize / endNum + 1;
		} else // 数据总数和每页显示的总数能整除的情况
		{
			pageCount = listSize / endNum;
		}
		if (listSize > 0) {
			if (startNum <= pageCount) {
				if (startNum == 1) // 当前页数为第一页
				{
					if (listSize <= endNum) // 数据总数小于每页显示的数据条数
					{
						// 截止到总的数据条数(当前数据不足一页，按一页显示)，这样才不会出现数组越界异常
						obj = obj.subList(0, listSize);
					} else {
						obj = obj.subList(0, endNum);
					}
				} else {
					// 截取起始下标
					int fromIndex = (startNum - 1) * endNum;
					// 截取截止下标
					int toIndex = startNum * endNum;
                    /* 计算截取截止下标 */
					if ((listSize - toIndex) % endNum >= 0) {
						toIndex = startNum * endNum;
					} else {
						toIndex = (startNum - 1) * endNum + (listSize % endNum);
					}
					if (listSize >= toIndex) {
						obj = obj.subList(fromIndex, toIndex);
					}
				}
			} else {
				obj = null;
			}
		}
		return obj;
	}

}
