/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.report.service.utils;

import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;

import java.io.Serializable;

/**
 * <h3>result model factory</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
public final class ResultModelFactory {

    private ResultModelFactory() {}

    public static <T extends Serializable> ResultModel<T> FAIL() {
        return FAIL(ErrorCode.SERVER_ERROR.getErrorCode(), ErrorCode.SERVER_ERROR.getErrorMessage());
    }

    public static <T extends Serializable> ResultModel<T> FAIL500(String message) {
        return FAIL(ErrorCode.SERVER_ERROR.getErrorCode(), message);
    }

    public static <T extends Serializable> ResultModel<T> FAIL400(String message) {
        return FAIL(ErrorCode.ILLEGAL_PARAMS.getErrorCode(), message);
    }

    public static <T extends Serializable> ResultModel<T> FAIL(String errCode, String message) {
        ResultModel<T> rs = ResultModel.newInstance();
        rs.setSuccessed(false);
        rs.setErrorCode(errCode);
        rs.setErrorDesc(message);
        return rs;
    }

    public static <T extends Serializable> ResultModel<T> SUCCESS() {
        return SUCCESS(null);
    }

    public static <T extends Serializable> ResultModel<T> SUCCESS(T returning) {
        ResultModel<T> rs = ResultModel.newInstance();
        rs.setSuccessed(true);
        if (null != returning) {
			rs.setReturnValue(returning);
		}
        return rs;
    }
}
