package com.bxm.report.service.utils;

import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.dao.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.datapark.facade.Page;
import com.bxm.report.facade.app.AppEntranceFacadeIntegration;
import com.bxm.report.facade.app.ProviderAppFacadeIntegration;
import com.bxm.report.facade.constant.IntegrationConstant;
import com.bxm.report.model.vo.analysis.*;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/15 11:31
 * 修 改 人：
 * 日 期：
 * 描 述： 券分析 结果转换拼装 帮助类
 * 版 本 号： v1
 */
@Component
public class TicketAnalysisHelper {

    @Autowired
    private ProviderAppFacadeIntegration appFacadeIntegration;
    @Autowired
    private AppEntranceFacadeIntegration appEntranceFacadeIntegration;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;

    /**
     * Description: 批量获取app 的名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/16 16:38
     */
    private Map<String, String> getAppNameMap(List<String> appKeys) {
        if (CollectionUtils.isEmpty(appKeys)) {
            return Collections.emptyMap();
        }
        List<ProviderAppAdRo> infoAppMsgs = appFacadeIntegration.getListByAppKeys(appKeys);
        if (CollectionUtils.isEmpty(infoAppMsgs)) {
            return Collections.emptyMap();
        }
        return infoAppMsgs.stream().collect(HashMap::new, (k, v) -> k.put(v.getAppKey(), v.getAppName()), HashMap::putAll);
    }

    /**
     * Description: 批量获取广告位 的名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/16 16:38
     */
    private Map<String, String> getPositionNameMap(List<String> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return Collections.emptyMap();
        }
        List<AppEntranceAdRo> adPositions = appEntranceFacadeIntegration.getListByPositionIds(positionIds);
        if (CollectionUtils.isEmpty(adPositions)) {
            return Collections.emptyMap();
        }
        return adPositions.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v.getAppEntranceName()), HashMap::putAll);
    }

    /**
     * Description: 批量获取广告一级标签的名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/16 18:05
     */
    private Map<Integer, String> getTagTypeName(List<Integer> tagCodes) {
        if (CollectionUtils.isEmpty(tagCodes)) {
            return Collections.emptyMap();
        }
        List<TblAdTagVo> tblAdTagVos = tblAdPostionTagMapperExt.findByCodes(tagCodes);
        if (CollectionUtils.isEmpty(tblAdTagVos)) {
            return Collections.emptyMap();
        }
        return tblAdTagVos.stream().collect(HashMap::new, (k, v) -> k.put(v.getCode(), v.getName()), HashMap::putAll);
    }

    /**
     * Description: 转换并构建媒体分析VO
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:25
     */
    public Page<AnalysisMediaVO> convertAndBuildByMedia(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisMediaVO> page) {
        Page<AnalysisMediaVO> resultPage = this.pageCopy(page, AnalysisMediaVO.class);
        //DO something
        List<AnalysisMediaVO> list = resultPage.getList();
        if (CollectionUtils.isEmpty(list)) {
            return resultPage;
        }
        // 0 是合计
        AnalysisMediaVO mediaVO = list.get(1);
        if (null == mediaVO) {
            return resultPage;
        }
        if (StringUtils.isNotBlank(mediaVO.getAppKey())) {
            List<String> appKeys = list.stream().map(AnalysisMediaVO::getAppKey).collect(Collectors.toList());
            Map<String, String> groupByAppKey = this.getAppNameMap(appKeys);
            list.get(0).setAppName("合计");
            list.forEach(analysisMediaVO -> analysisMediaVO.setAppName(groupByAppKey.get(analysisMediaVO.getAppKey())));
        } else if (StringUtils.isNotBlank(mediaVO.getPositionId())) {
            List<String> positionIds = list.stream().map(AnalysisMediaVO::getPositionId).collect(Collectors.toList());
            Map<String, String> groupByAppKey = this.getPositionNameMap(positionIds);
            list.get(0).setPositionName("合计");
            list.forEach(analysisMediaVO -> analysisMediaVO.setPositionName(groupByAppKey.get(analysisMediaVO.getPositionId())));
        }
        return resultPage;
    }

    /**
     * Description: 转换并构建手机操作系统分析VO
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:25
     */
    public Page<AnalysisAppOSVO> convertAndBuildByAppOS(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisAppOSVO> page) {
        Page<AnalysisAppOSVO> analysisAppOSVOPage = this.pageCopy(page, AnalysisAppOSVO.class);
        if (CollectionUtils.isEmpty(analysisAppOSVOPage.getList())) {
            return analysisAppOSVOPage;
        }
        AnalysisAppOSVO total = analysisAppOSVOPage.getList().get(0);
        if (null == total) {
            return analysisAppOSVOPage;
        }
        total.setAppOSName("合计");
        return analysisAppOSVOPage;
    }

    /**
     * Description: 转换并构建支付类型分析VO
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:25
     */
    public Page<AnalysisPaymentTypeVO> convertAndBuildByPaymentType(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisPaymentTypeVO> page) {
        Page<AnalysisPaymentTypeVO> resultPage = this.pageCopy(page, AnalysisPaymentTypeVO.class);
        if (CollectionUtils.isEmpty(resultPage.getList())) {
            return resultPage;
        }
        AnalysisPaymentTypeVO total = resultPage.getList().get(0);
        if (null == total) {
            return resultPage;
        }
        total.setUaName("合计");
        return resultPage;
    }

    /**
     * Description: 转换并构建区域分析VO
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:25
     */
    public Page<AnalysisRegionVO> convertAndBuildByRegion(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisRegionVO> page) {
        Page<AnalysisRegionVO> resultPage = this.pageCopy(page, AnalysisRegionVO.class);
        List<AnalysisRegionVO> list = resultPage.getList();
        if (CollectionUtils.isEmpty(list)) {
            return resultPage;
        }
        AnalysisRegionVO analysisRegionVO = list.get(1);
        if (null != analysisRegionVO) {
            if (StringUtils.isNotBlank(analysisRegionVO.getCity())) {
                resultPage.getList().get(0).setCity("合计");
            } else {
                resultPage.getList().get(0).setProvince("合计");
            }
        }
        return resultPage;
    }

    /**
     * Description: 转换并构建标签类型分析VO
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:25
     */
    public Page<AnalysisTagTypeVO> convertAndBuildByTagType(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTagTypeVO> page) {
        Page<AnalysisTagTypeVO> resultPage = this.pageCopy(page, AnalysisTagTypeVO.class);
        List<AnalysisTagTypeVO> list = resultPage.getList();
        if (CollectionUtils.isEmpty(list)) {
            return resultPage;
        }
        AnalysisTagTypeVO total = list.get(0);
        if (null == total) {
            return resultPage;
        }
        total.setAdTypeName("合计");
        List<Integer> tagCodes = list.stream().map(AnalysisTagTypeVO::getAdTypeCode).collect(Collectors.toList());
        Map<Integer, String> groupByCode = this.getTagTypeName(tagCodes);
        list.forEach(analysisTagTypeVO -> analysisTagTypeVO.setAdTypeName(groupByCode.get(analysisTagTypeVO.getAdTypeCode())));
        return resultPage;
    }

    /**
     * Description: 转换并构建趋势分析VO
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:25
     */
    public Page<AnalysisTrendVO> convertAndBuildByTrend(Page<com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTrendVO> page) {
        Page<AnalysisTrendVO> resultPage = this.pageCopy(page, AnalysisTrendVO.class);
        List<AnalysisTrendVO> list = resultPage.getList();
        if (CollectionUtils.isEmpty(list)) {
            return resultPage;
        }
        AnalysisTrendVO analysisTrendVO = list.get(1);
        if (null != analysisTrendVO) {
            if (StringUtils.isNotBlank(analysisTrendVO.getHour())) {
                resultPage.getList().get(0).setHour("合计");
            } else {
                resultPage.getList().get(0).setCreateTime("合计");
            }
        }
        return resultPage;
    }

    /**
     * Description: page 赋值
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/15 11:46
     */
    private <T> Page<T> pageCopy(Page<? extends com.bxm.datapark.facade.ticket.model.vo.analysis.BaseAnalysisVO> page, Class<T> clazz) {
        Page<T> resultPage = new Page<>();
        BeanUtils.copyProperties(page, resultPage);
        List<T> list = CollectionDataCopyUtil.copyList(page.getList(), clazz);
        resultPage.setList(list);
        return resultPage;
    }

    //
    // 下面是图表
    //

    /**
     * Description: 广告券分析图表的key翻译
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    public Map<String, Map<String, Double>> commonAnalysisChat(Map<String, Map<String, Double>> map, String analysisType, String groupByField) {
        switch (analysisType) {
            case IntegrationConstant.Analysis.ANALYSIS_TYPE_MEDIA:
                // 按媒体分组(默认)，则把key翻译成媒体名称， 否则按广告位
                Set<String> ids = new HashSet<>();
                for (Map<String, Double> childMap : map.values()) {
                    ids.addAll(childMap.keySet());
                }
                if (StringUtils.isBlank(groupByField) || IntegrationConstant.Analysis.MEDIA_DEFAULT_FIELD_NAME.equals(groupByField)) {
                    Map<String, String> appNameMap = this.getAppNameMap(new ArrayList<>(ids));
                    if (MapUtils.isEmpty(appNameMap)) {
                        return map;
                    }
                    return this.translateMapKey(map, appNameMap);
                } else {
                    Map<String, String> positionNameMap = this.getPositionNameMap(new ArrayList<>(ids));
                    if (MapUtils.isEmpty(positionNameMap)) {
                        return map;
                    }
                    return this.translateMapKey(map, positionNameMap);
                }
            case IntegrationConstant.Analysis.ANALYSIS_TYPE_TAG_TYPE:
                // 按媒体分组(默认)，则把key翻译成媒体名称， 否则按广告位
                Set<String> tagCodes = new HashSet<>();
                for (Map<String, Double> childMap : map.values()) {
                    tagCodes.addAll(childMap.keySet());
                }
                List<Integer> tagCodeList = new ArrayList<>(tagCodes.size());
                for (String tagCode : tagCodes) {
                    if (StringUtils.isNumeric(tagCode)) {
                        tagCodeList.add(Integer.valueOf(tagCode));
                    }
                }
                Map<Integer, String> tagNameMap = this.getTagTypeName(tagCodeList);
                Map<String, String> newTagNameMap = new HashMap<>(tagNameMap.size());
                for (Map.Entry<Integer, String> entry : tagNameMap.entrySet()) {
                    newTagNameMap.put(entry.getKey().toString(), entry.getValue());
                }
                return this.translateMapKey(map, newTagNameMap);
            default:
                return map;
        }
    }

    /**
     * Description: 翻译 二级map里的id/code 什么的
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/16 17:09
     */
    private Map<String, Map<String, Double>> translateMapKey(Map<String, Map<String, Double>> target, Map<String, String> source) {
        Map<String, Map<String, Double>> resultMap = new HashMap<>(target.size());
        for (Map.Entry<String, Map<String, Double>> parentEntry : target.entrySet()) {
            Map<String, Double> newChildMap = new HashMap<>(parentEntry.getValue().size());
            Double other = parentEntry.getValue().get("其他");
            if (null != other) {
                newChildMap.put("其他", other);
                parentEntry.getValue().remove("其他");
            }
            for (Map.Entry<String, Double> doubleEntry : parentEntry.getValue().entrySet()) {
                String name = source.get(doubleEntry.getKey());
                name = StringUtils.isBlank(name) ? "--" + doubleEntry.getKey() + "--" : name;
                newChildMap.put(name, doubleEntry.getValue());
            }
            resultMap.put(parentEntry.getKey(), newChildMap);
        }
        return resultMap;
    }

}
