/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.model.redis;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

@Component
public class RedisNewClient {
    private static final Logger log = LoggerFactory.getLogger(RedisNewClient.class);
    @Autowired
    @Qualifier(value="redis1PoolFactory")
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrRedis(String key) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.incr(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrRedisWhitDB(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (null != dbIndex) {
                jedis.select(dbIndex.intValue());
            }
            jedis.incr(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedis(String key) {
        String result = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            result = jedis.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWithDB(String key, String value, Long seconds, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key, value);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedisWhitDB(String key, Integer dbIndex) {
        String result = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PfAdd(String key, String value, Integer dbIndex, Long seconds) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.pfadd(key, new String[]{value});
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer pfCount(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Integer n = (int)jedis.pfcount(key);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sadd(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.sadd(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Set set = jedis.smembers(key);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void srem(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.srem(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchHset(String key, Map<String, Set<Integer>> map, Long seconds, Integer dbIndex) {
        try (Jedis jedis = new Jedis();){
            jedis = this.jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            int index = 0;
            for (String mapKey : map.keySet()) {
                if (map.get(mapKey) != null) {
                    pipeline.hset(key, mapKey, JSON.toJSONString(map.get(mapKey)));
                }
                if (++index % 1000 != 0) continue;
                pipeline.sync();
            }
            pipeline.sync();
            if (seconds != null) {
                pipeline.expire(key.toString(), seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchHsetForAct(String key, Map<String, String> map, Long seconds, Integer dbIndex) {
        try (Jedis jedis = new Jedis();){
            jedis = this.jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            int index = 0;
            for (String mapKey : map.keySet()) {
                if (map.get(mapKey) != null) {
                    pipeline.hset(key, mapKey, map.get(mapKey));
                }
                if (++index % 1000 != 0) continue;
                pipeline.sync();
            }
            pipeline.sync();
            if (seconds != null) {
                pipeline.expire(key.toString(), seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchSAdd(String key, Set<String> set, Long seconds, Integer dbIndex) {
        try (Jedis jedis = new Jedis();){
            jedis = this.jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            int index = 0;
            for (String s : set) {
                if (s != null) {
                    pipeline.sadd(key, new String[]{s});
                }
                if (++index % 1000 != 0) continue;
                pipeline.sync();
            }
            pipeline.sync();
            if (seconds != null) {
                pipeline.expire(key.toString(), seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delKey(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.del(key);
        }
    }

    public void tenMinKey(String key, Integer dbIndex) {
        this.expireKey(key, dbIndex, 1800);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireKey(String key, Integer dbIndex, Integer time) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.expire(key, time.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hset(String key, String filed, String value, Integer dbIndex, Long seconds) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.hset(key, filed, value);
            if (seconds != null) {
                jedis.expire(key.toString(), seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hdel(String key, String filed, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.hdel(key, new String[]{filed});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hGet(String key, String field, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.hget(key, field);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hGetAll(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Map map = jedis.hgetAll(key);
            return map;
        }
    }
}

