/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.model.resttemplate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateClient<T> {
    @Autowired
    RestTemplate restTemplate;

    public T getNoParamsForObject(String url, Class<T> responseType) {
        return (T)this.restTemplate.getForObject(URI.create(url), responseType);
    }

    public Map<String, Object> getForEntity(String url, Class<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(URI.create(url), responseType);
        HashMap map = Maps.newHashMap();
        map.put("statusCode", responseEntity.getStatusCode());
        map.put("header", responseEntity.getHeaders());
        map.put("body", responseEntity.getBody());
        return map;
    }

    public T getNoParams(String url, Class<T> responseType) {
        RequestEntity requestEntity = RequestEntity.get((URI)URI.create(url)).build();
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, responseType);
        return (T)responseEntity.getBody();
    }

    public T postNoParamsObject(String url, Object obj, Class<T> responseType) {
        return (T)this.restTemplate.postForObject(URI.create(url), obj, responseType);
    }

    public Map<String, Object> postForEntity(String url, Object obj, Class<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(URI.create(url), obj, responseType);
        HashMap map = Maps.newHashMap();
        map.put("statusCode", responseEntity.getStatusCode());
        map.put("header", responseEntity.getHeaders());
        map.put("body", responseEntity.getBody());
        return map;
    }

    public T postNoParams(String url, Class<T> responseType) {
        RequestEntity requestEntity = RequestEntity.post((URI)URI.create(url)).build();
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, responseType);
        return (T)responseEntity.getBody();
    }

    public String getByHeadParams(String url, Map<String, Object> params, Map<String, Object> headerParams, HttpMethod method) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        if (MapUtils.isNotEmpty(headerParams)) {
            Set<String> set = headerParams.keySet();
            for (String string : set) {
                headers.set(string, (String)headerParams.get(string));
            }
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap p = new LinkedMultiValueMap();
        if (MapUtils.isNotEmpty(params)) {
            Set<Map.Entry<String, Object>> entries = params.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                Object value = entry.getValue();
                if (null == value) continue;
                p.put((Object)entry.getKey(), (List)Lists.newArrayList((Object[])new String[]{value.toString()}));
            }
        }
        HttpEntity requestEntity = new HttpEntity((Object)p, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, method, requestEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public String getByParams(String url, Map<String, Object> params, HttpMethod method, MediaType mediaType) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (null != mediaType) {
            headers.setContentType(mediaType);
        }
        LinkedMultiValueMap p = new LinkedMultiValueMap();
        if (MapUtils.isNotEmpty(params)) {
            Set<Map.Entry<String, Object>> entries = params.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                Object value = entry.getValue();
                if (null == value) continue;
                p.put((Object)entry.getKey(), (List)Lists.newArrayList((Object[])new String[]{value.toString()}));
            }
        }
        HttpEntity requestEntity = new HttpEntity((Object)p, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, method, requestEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }
}

