/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.model.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DataParkUtils {
    public static String getPercent(Double old) {
        if (old != null) {
            return old + "%";
        }
        return null;
    }

    public static String getQualityFactorShow(Double old) {
        if (old != null) {
            return old + "";
        }
        return "0";
    }

    public static Double changeZero(Double num) {
        if (num == null || num.toString().isEmpty()) {
            return 0.0;
        }
        return num;
    }

    public static String getNextDate(String dateTime) {
        return DataParkUtils.getDate(dateTime, 1);
    }

    public static String getPreDate(String dateTime) {
        return DataParkUtils.getDate(dateTime, -1);
    }

    public static String getDate(String dateTime, Integer amount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(sdf.parse(dateTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ((Calendar)calendar).add(5, amount);
        return sdf.format(calendar.getTime());
    }

    public static String formatDouble(Double d) {
        return DataParkUtils.formatDouble(d, "#.00");
    }

    public static String formatDouble(Double d, String fomat) {
        DecimalFormat df = new DecimalFormat(fomat);
        String rs = df.format(d);
        if (rs.indexOf("-") != Integer.valueOf(-1).intValue()) {
            return rs.indexOf(".") == Integer.valueOf(1).intValue() ? rs.replaceFirst("-", "0") : rs;
        }
        return rs.indexOf(".") == Integer.valueOf(0).intValue() ? "0" + rs : rs;
    }
}

