/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.model.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtil {
    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getDayFirsttime(Date date) {
        if (null == date) {
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isBefore(Date configDate, Date entryDate) {
        boolean bool = entryDate.before(configDate);
        return bool;
    }

    public static boolean isAfter(Date configDate, Date entryDate) {
        boolean bool = entryDate.after(configDate);
        return bool;
    }

    public static Date convertStr2Date(String str) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    public static Date convertStr3Date(String str) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    public static Date StringToDate(String str) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formate.parse(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date increaseDate(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date increaseHour(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date lastDayByMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Integer getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static String dateTo8String(Date date) {
        if (date == null) {
            return null;
        }
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo14StringCH(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo8StringCH(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5  HH:mm:ss");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo14String(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo12String(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo8String1(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo8String2(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateTo8String3(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dates = sdf.format(date);
        return dates;
    }

    public static String dateToYMD(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-d");
        dates = sdf.format(date);
        return dates;
    }

    public static Integer dateTo8Integer(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        dates = sdf.format(date);
        return Integer.valueOf(dates);
    }

    public static Date string8ToDate(String str) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    public static boolean validate(String dateString) {
        Pattern p = Pattern.compile("\\d{4}+\\d{1,2}+\\d{1,2}+");
        Matcher m = p.matcher(dateString);
        if (!m.matches()) {
            return false;
        }
        int year = Integer.valueOf(dateString.substring(0, 4));
        int month = Integer.valueOf(dateString.substring(4, 6));
        int day = Integer.valueOf(dateString.substring(6, 8));
        if (month < 1 || month > 12) {
            return false;
        }
        int[] monthLengths = new int[]{0, 31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        monthLengths[2] = DateUtil.isLeapYear(year) ? 29 : 28;
        int monthLength = monthLengths[month];
        return day >= 1 && day <= monthLength;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static Date now() {
        return new Date();
    }

    public static Date getDate(String year, String month, String day) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String str = year + "-" + month + "-" + day;
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    public static int countDiffDateDays(Date startDate, Date endDate) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(startDate);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(endDate);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static long countDiffDateDays2(Date fDate, Date oDate) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTimeInMillis(0L);
        aCalendar.setTime(fDate);
        fDate = DateUtil.getDate(aCalendar.get(1), aCalendar.get(2), aCalendar.get(6));
        aCalendar.setTime(oDate);
        oDate = DateUtil.getDate(aCalendar.get(1), aCalendar.get(2), aCalendar.get(6));
        long quot = (oDate.getTime() - fDate.getTime()) / 1000L / 60L / 60L / 24L;
        if (quot < 0L) {
            quot = -quot;
        }
        return quot;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(6, day);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date convertDate2Date(Date date) {
        String dateStr = DateUtil.dateTo8String(date);
        Date adate = DateUtil.convertStr2Date(dateStr);
        return adate;
    }

    public static int getYear(Date date) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(date);
        return aCalendar.get(1);
    }

    public static int getDay(Date date) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(date);
        return aCalendar.get(5);
    }

    public static int compareOnlyDate(Date date1, Date date2) {
        String date1str = DateUtil.dateTo8String(date1);
        Date newDate1 = DateUtil.convertStr2Date(date1str);
        String date2str = DateUtil.dateTo8String(date2);
        Date newDate2 = DateUtil.convertStr2Date(date2str);
        return newDate1.compareTo(newDate2);
    }

    public static boolean compareDate(Long date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null && date2 != null) {
            return false;
        }
        if (date1 != null && date2 == null) {
            return false;
        }
        return date1.longValue() == date2.getTime();
    }

    public static long getBetweenDays(Date date1, Date date2) {
        if (date2.before(date1)) {
            Date date3 = date1;
            date1 = date2;
            date2 = date3;
        }
        long to = date1.getTime();
        long from = date2.getTime();
        return (from - to) / 86400000L;
    }

    public static String dateToFormat(Date date, String format) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        dates = sdf.format(date);
        return dates;
    }

    public static Date getTheDayBefore(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, -1);
        Date beforeDate = calendar.getTime();
        return beforeDate;
    }

    public static Date getTheDayAfter(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        Date afterDate = calendar.getTime();
        return afterDate;
    }

    public static Timestamp increaseDateAndToTimestamp(Date date, Number days) {
        Timestamp timestamp = null;
        if (date == null) {
            return timestamp;
        }
        int intDays = days.intValue();
        Date increaseDate = DateUtil.increaseDate(date, intDays);
        timestamp = new Timestamp(increaseDate.getTime());
        return timestamp;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp timestamp = null;
        if (date == null) {
            return timestamp;
        }
        timestamp = new Timestamp(date.getTime());
        return timestamp;
    }

    public static String timestampToSMMdd(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = new Date(timestamp.getTime());
        String dateStr = DateUtil.dateToFormat(date, "MM-dd");
        return dateStr;
    }

    public static String timestampToSYYYYMMdd(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = new Date(timestamp.getTime());
        String dateStr = DateUtil.dateToFormat(date, "yyyy-MM-dd");
        return dateStr;
    }

    public static String timestampTo14String(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = new Date(timestamp.getTime());
        String dateStr = DateUtil.dateTo14String(date);
        return dateStr;
    }

    public static String calcDateDifference(long timeStart, long timeEnd) {
        long between = 0L;
        String returnStr = "";
        between = timeEnd - timeStart;
        long second = 1000L;
        long minute = 60L * second;
        long hour = minute * 60L;
        long day = hour * 24L;
        long month = day * 30L;
        long year = month * 12L;
        if (between >= 0L && between < second) {
            returnStr = "\u521a\u521a";
        } else if (second >= 0L && between < minute) {
            returnStr = between / second + "\u79d2\u524d";
        } else if (between >= minute && between < hour) {
            returnStr = between / minute + "\u5206\u949f\u524d";
        } else if (between >= hour && between < day) {
            returnStr = between / hour + "\u5c0f\u65f6\u524d";
        } else if (between >= day && between < month) {
            returnStr = between / day + "\u5929\u524d";
        } else if (between >= month && between < year) {
            returnStr = between / month + "\u4e2a\u6708\u524d";
        } else if (between >= year) {
            returnStr = between / year + "\u5e74\u524d";
        }
        return returnStr;
    }

    public static Date strToDate(String str) throws Exception {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
    }

    public static Timestamp strToTimestamp(String str) throws Exception {
        Timestamp timestamp = new Timestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str).getTime());
        return timestamp;
    }

    public static Boolean isSameDay(Date day1, Date day2) {
        Calendar calDateA = Calendar.getInstance();
        calDateA.setTime(day1);
        Calendar calDateB = Calendar.getInstance();
        calDateB.setTime(day2);
        return calDateA.get(1) == calDateB.get(1) && calDateA.get(2) == calDateB.get(2) && calDateA.get(5) == calDateB.get(5);
    }

    public static Date setBeginTimeInOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setEndTimeInOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateUtil.dateTo8String(DateUtil.increaseDate(DateUtil.StringToDate("2017-07-22"), -6)));
    }
}

