/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sms.model.v20160927.SingleSendSmsRequest;
import com.bxm.util.CommonValidate;
import com.bxm.util.StringUtil;

public class AliYunSmsUtil {
    private static final String REGION_ID = "cn-hangzhou";
    private static final String PRODUCT = "Sms";
    private static final String DOMAIN = "sms.aliyuncs.com";
    private static final String PARAM_STRING = "{\"code\":\" msgContent \"}";

    public static boolean sendValidateCodeMsg(String accessKeyId, String secret, String signName, String phone, String msgContent, String msgTemplateCode) {
        CommonValidate.me.checkParam(accessKeyId);
        CommonValidate.me.checkParam(secret);
        CommonValidate.me.checkParam(signName);
        CommonValidate.me.checkParam(phone);
        CommonValidate.me.checkParam(msgContent);
        CommonValidate.me.checkParam(msgTemplateCode);
        boolean isSendSuccess = false;
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)secret);
            DefaultProfile.addEndpoint((String)REGION_ID, (String)REGION_ID, (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            SingleSendSmsRequest request = new SingleSendSmsRequest();
            request.setSignName(signName);
            request.setTemplateCode(msgTemplateCode);
            request.setParamString(PARAM_STRING.replace("msgContent", msgContent));
            request.setRecNum(phone);
            client.getAcsResponse((AcsRequest)request);
            isSendSuccess = true;
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return isSendSuccess;
    }

    public static boolean sendMsg(String accessKeyId, String secret, String signName, String phone, String msgContent, String msgTemplateCode) {
        CommonValidate.me.checkParam(accessKeyId);
        CommonValidate.me.checkParam(secret);
        CommonValidate.me.checkParam(signName);
        CommonValidate.me.checkParam(phone);
        CommonValidate.me.checkParam(msgTemplateCode);
        boolean isSendSuccess = false;
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)secret);
            DefaultProfile.addEndpoint((String)REGION_ID, (String)REGION_ID, (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            SingleSendSmsRequest request = new SingleSendSmsRequest();
            request.setSignName(signName);
            request.setTemplateCode(msgTemplateCode);
            if (StringUtil.isNotBlank((CharSequence)msgContent)) {
                request.setParamString(msgContent);
            }
            request.setRecNum(phone);
            client.getAcsResponse((AcsRequest)request);
            isSendSuccess = true;
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return isSendSuccess;
    }
}

