/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class FileUtil {
    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String toUtf8String(HttpServletRequest request, String s) throws Exception {
        boolean isFireFox;
        String agent = request.getHeader("User-Agent");
        boolean bl = isFireFox = agent != null && agent.toLowerCase().indexOf("firefox") != -1;
        if (isFireFox) {
            s = new String(s.getBytes("UTF-8"), "ISO8859-1");
        } else {
            s = FileUtil.toUtf8String(s);
            if (agent != null && agent.indexOf("MSIE") != -1 && s.length() > 150) {
                s = new String(s.getBytes("UTF-8"), "ISO8859-1");
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertTextToFile(String text, String savePath) throws IOException {
        OutputStream outputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            char[] chars;
            File file = new File(savePath);
            if (file.exists()) {
                file.delete();
            }
            outputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (char c : chars = text.toCharArray()) {
                bufferedWriter.write(c);
            }
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
                outputStreamWriter.close();
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        StringBuffer textSb = new StringBuffer();
        for (int i = 0; i < 1000000; ++i) {
            textSb.append("2836d8095b5d431bab3b1a48e881d205-2836d8095b5d431bab3b1a48e881d205-2836d8095b5d431bab3b1a48e881d205" + i + "-bxm\n");
        }
        FileUtil.convertTextToFile(textSb.toString(), "D:\\test.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertFileToText(String filePath) {
        File file = new File(filePath);
        String fileContent = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            if (file.isFile() && file.exists()) {
                String line;
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    fileContent = fileContent + line;
                }
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStreamReader.close();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileContent;
    }

    public static InputStream getStringStream(String inputString) {
        if (StringUtil.isNotBlank((CharSequence)inputString)) {
            try {
                ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(inputString.getBytes());
                return tInputStringStream;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static long getFileSize(String fileUrl) {
        if (StringUtil.isNotBlank((CharSequence)fileUrl)) {
            try {
                URL url = new URL(fileUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(10000);
                String fileLength = conn.getHeaderField("Content-Length");
                if (StringUtil.isNotBlank((CharSequence)fileLength)) {
                    return Long.valueOf(fileLength);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }
}

