/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListUtil {
    public static <T> List<List<T>> splitList(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return null;
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    public static List<Object> getTotalPage(int listSize, int startNum, int endNum) {
        List<Object> obj = new ArrayList<Object>();
        int pageCount = 0;
        pageCount = listSize % endNum > 0 ? listSize / endNum + 1 : listSize / endNum;
        if (listSize > 0) {
            if (startNum <= pageCount) {
                if (startNum == 1) {
                    obj = listSize <= endNum ? obj.subList(0, listSize) : obj.subList(0, endNum);
                } else {
                    int fromIndex = (startNum - 1) * endNum;
                    int toIndex = startNum * endNum;
                    toIndex = (listSize - toIndex) % endNum >= 0 ? startNum * endNum : (startNum - 1) * endNum + listSize % endNum;
                    if (listSize >= toIndex) {
                        obj = obj.subList(fromIndex, toIndex);
                    }
                }
            } else {
                obj = null;
            }
        }
        return obj;
    }

    public static Object[] listToArray(List<Object> params) {
        Object[] objs = new Object[]{};
        if (params != null && params.size() > 0) {
            objs = new Object[params.size()];
            int index = 0;
            Iterator<Object> iterator = params.iterator();
            while (iterator.hasNext()) {
                Object object;
                objs[index] = object = iterator.next();
                ++index;
            }
        }
        return objs;
    }
}

