/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.Prop;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PropUtil {
    private static String DEFAULT_ENCODING = "UTF-8";
    private static Prop prop = null;
    private static final Map<String, Prop> map = new HashMap<String, Prop>();

    private PropUtil() {
    }

    public static Prop use(String fileName) {
        return PropUtil.use(fileName, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop use(String fileName, String encoding) {
        Prop result = map.get(fileName);
        if (result == null) {
            Map<String, Prop> map = PropUtil.map;
            synchronized (map) {
                result = PropUtil.map.get(fileName);
                if (result == null) {
                    result = new Prop(fileName, encoding);
                    PropUtil.map.put(fileName, result);
                    if (prop == null) {
                        prop = result;
                    }
                }
            }
        }
        return result;
    }

    public static Prop use(File file) {
        return PropUtil.use(file, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop use(File file, String encoding) {
        Prop result = map.get(file.getName());
        if (result == null) {
            Map<String, Prop> map = PropUtil.map;
            synchronized (map) {
                result = PropUtil.map.get(file.getName());
                if (result == null) {
                    result = new Prop(file, encoding);
                    PropUtil.map.put(file.getName(), result);
                    if (prop == null) {
                        prop = result;
                    }
                }
            }
        }
        return result;
    }

    public static Prop useless(String fileName) {
        Prop previous = map.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        map.clear();
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking PropUtil.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return map.get(fileName);
    }

    public static String get(String key) {
        return PropUtil.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return PropUtil.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return PropUtil.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return PropUtil.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return PropUtil.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return PropUtil.getProp().getLong(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return PropUtil.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return PropUtil.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return PropUtil.getProp().containsKey(key);
    }
}

