/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate;

import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractValidator
implements Validator {
    private final Field field;
    private final String fieldName;

    public AbstractValidator(Field field) {
        if (null == field) {
            throw new NullPointerException("field");
        }
        this.field = field;
        this.fieldName = field.getName();
    }

    protected String getFieldDesc(Field f) {
        return new StringBuilder(64).append(f.getDeclaringClass().getName()).append(".").append(this.getField().getName()).toString();
    }

    protected String getFieldDesc() {
        return this.getFieldDesc(this.getField());
    }

    @Override
    public void validate(Object input) throws ValidateException, ConstraintViolationException {
        if (null == input) {
            throw new NullPointerException("input");
        }
        try {
            this.doValidate(input);
        }
        catch (Exception e) {
            if (e instanceof ValidateException) {
                throw (ValidateException)e;
            }
            throw new ValidateException(e);
        }
    }

    protected abstract void doValidate(Object var1) throws Exception;

    protected Object getValue(Object input) throws IllegalArgumentException, IllegalAccessException {
        try {
            return PropertyUtils.getProperty((Object)input, (String)this.fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ValidateException("getValue:", e);
        }
        catch (NoSuchMethodException e) {
            throw new ValidateException("getValue:", e);
        }
    }

    protected Field getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.getConstraintDesc();
    }
}

