/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.base;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.report.facade.logs.LogsIntegration;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.service.utils.IPUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseController {
    public static final String SESSION_USER_NAME = "user";
    private static final Logger logger = Logger.getLogger(BaseController.class);
    @Autowired
    private LogsIntegration logsIntegration;

    public User getUser(HttpServletRequest request, HttpServletResponse response) {
        User user = new User();
        try {
            UserVo userVo = (UserVo)request.getAttribute(SESSION_USER_NAME);
            if (userVo != null) {
                BeanUtils.copyProperties((Object)userVo, (Object)user);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        user.setIp(IPUtils.getIp(request));
        return user;
    }

    public void addLogs(User user, String content, String adticketId) {
        try {
            String userAccount = "-";
            if (user != null) {
                userAccount = user.getUserAllRole();
            }
            LogModel logModel = new LogModel.Builder().userName(userAccount).userAccount(user.getUsername()).parentAccount(userAccount).content(content).adticketId(adticketId).ip(user.getIp()).build();
            this.logsIntegration.add(logModel);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

