/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.common;

import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.report.model.vo.adposition.QueryMediaNameVo;
import com.bxm.report.model.vo.ticket.QueryTicketNameVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.ticket.AdTicketService;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reportor/common"})
public class CommonController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdPositionService adPositionService;

    @RequestMapping(value={"/findTicketAll"}, method={RequestMethod.GET})
    public ResultModel<List<QueryTicketNameVo>> findTicketByParam(@RequestParam(value="keyWords") String keyWords) {
        ResultModel rs = new ResultModel();
        rs.setReturnValue(this.adTicketService.queryTicketIdOrNameByKeywords(keyWords));
        return rs;
    }

    @RequestMapping(value={"/findMediaAll"}, method={RequestMethod.GET})
    public ResultModel<List<QueryMediaNameVo>> findMediaAll(@RequestParam(value="keyWords") String keyWords) {
        ResultModel rs = new ResultModel();
        rs.setReturnValue(this.adPositionService.queryMediaIdOrNameByKeywords(keyWords));
        return rs;
    }

    @RequestMapping(value={"/findPositionAll"}, method={RequestMethod.GET})
    public ResultModel<List<QueryPositionIdAndNameVo>> findMediaAll(@RequestParam(value="keyWords", required=false) String keyWords, @RequestParam(value="appKey", required=false) String appKey) {
        ResultModel rs = new ResultModel();
        rs.setReturnValue(this.adPositionService.queryPositionIdOrNameByKeywords(keyWords, appKey));
        return rs;
    }
}

