/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.common;

import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.common.Dictionaries;
import com.bxm.report.service.adkeeper.DictionariesService;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class DictionariesController {
    private static final Logger logger = Logger.getLogger(DictionariesController.class);
    @Autowired
    private DictionariesService dictionariesService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findAll(String typegroupid) {
        ResultModel rs = new ResultModel();
        try {
            if (typegroupid == null) {
                rs.setSuccessed(false);
                rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
                rs.setErrorDesc("typegroupid\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                return rs;
            }
            List<Dictionaries> list = this.dictionariesService.findAll(typegroupid);
            rs.setReturnValue(list);
        }
        catch (Exception e) {
            logger.error((Object)("\u6839\u636e\u5b57\u5178id\u67e5\u627e\u6240\u6709\u5b57\u5178\u51fa\u9519" + e.getMessage()), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            rs.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        return rs;
    }
}

