/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.common;

import com.alibaba.fastjson.JSONObject;
import com.bxm.report.model.constant.TicketConstant;
import com.bxm.report.model.dao.tbltag.TblAdPostionTag;
import com.bxm.report.model.vo.tbltag.TblAdTagDropdownBoxVo;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import com.bxm.report.service.tbltag.TblAdTagService;
import com.bxm.report.service.utils.CollectionDataCopyUtil;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tbladtag/"})
public class TblAdTagController
extends BaseController {
    private Logger log = LoggerFactory.getLogger(TblAdTagController.class);
    @Autowired
    private TblAdTagService tblAdTagService;

    @RequestMapping(value={"find/tblAdTagByType"}, method={RequestMethod.GET})
    public ResultModel<List<TblAdTagVo>> findTblAdTagListByType(@RequestParam(value="parentId") Integer parentId, @RequestParam(value="type") Integer type) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.tblAdTagService.findTblAdTagListByType(parentId, type));
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/tblAdTagByParentId"})
    public ResultModel<List<TblAdTagVo>> findTblAdTagByParentId(@RequestParam(value="id") Integer id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.tblAdTagService.findTblAdTagById(id));
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/TblAdTagListByParam"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<TblAdTagVo>> findTblAdTagListByParam(@RequestParam(value="param", defaultValue="") String param, @RequestParam(value="type", defaultValue="") String type, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            resultModel.setReturnValue(this.tblAdTagService.findfindTblAdTagByNameAndID(param, type));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/TblTagAll"})
    public ResultModel<PageInfo<TblAdTagVo>> findAllTblTag(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="name", defaultValue="") String name) {
        ResultModel resultModel = new ResultModel();
        try {
            PageInfo<TblAdTagVo> list = this.tblAdTagService.findAll(pageNum, pageSize, name);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/TblTagByCodeStr"}, method={RequestMethod.GET})
    public ResultModel<JSONObject> findTblTagByCodeStr(@RequestParam(value="codeStr") String codeStr) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.findTblAdTagByCodeStr(codeStr));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/tblTagByFirstCode"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<List<TblAdTagVo>> tblTagByFirstCode() {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.tblAdTagService.tblTagByFirstCode());
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/findNewTreeAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<TblAdTagVo>> findNewTreeAll(@RequestParam(value="parentId", defaultValue="0") Integer parentId, @RequestParam(value="type", defaultValue="1") Integer type, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        try {
            PageInfo<TblAdTagVo> pag = this.tblAdTagService.findNewTreeAll(pageNum, pageSize, type, name, parentId);
            resultModel.setReturnValue(pag);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/findNewAll"})
    public ResultModel<PageInfo<TblAdTagVo>> findNewAll(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="type", defaultValue="1") Integer type) {
        ResultModel resultModel = new ResultModel();
        try {
            PageInfo<TblAdTagVo> list = this.tblAdTagService.findNewAll(pageNum, pageSize, name, type);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"findOneLevelTag"})
    public ResultModel<List<TblAdTagDropdownBoxVo>> findOneLevelTag(Integer tagType) {
        if (null == tagType) {
            tagType = TicketConstant.TicketTag.TAG_TYPE_CLASSIFY;
        }
        ResultModel resultModel = new ResultModel();
        List<TblAdPostionTag> tblAdPostionTags = this.tblAdTagService.findOneLevelTag(tagType);
        if (CollectionUtils.isEmpty(tblAdPostionTags)) {
            resultModel.setReturnValue(Collections.emptyList());
            return resultModel;
        }
        resultModel.setReturnValue(CollectionDataCopyUtil.copyList(tblAdPostionTags, TblAdTagDropdownBoxVo.class));
        return resultModel;
    }
}

