/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityReportDto;
import com.bxm.report.facade.datapark.DataparkActivityPullerIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activityReport"})
public class ActivityReportController {
    @Autowired
    private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;
    @Autowired
    private DataparkActivityService dataparkActivityService;

    @RequestMapping(value={"/newActivityReport"}, method={RequestMethod.POST})
    public ResultModel aciticityReport(ActivityReportDto dto) {
        System.out.println(dto);
        ResultModel resultModel = this.dataparkActivityPullerIntegration.pullNewActivityData(dto);
        return this.dataparkActivityService.pullNewActivityData((ResultModel<Page>)resultModel);
    }

    @RequestMapping(value={"/activityReport"}, method={RequestMethod.GET})
    public ResultModel<Pagination> activityReport(ActivityReportRo activityReportRo) {
        ResultModel resultModel = new ResultModel();
        if (StringUtils.isEmpty((CharSequence)activityReportRo.getDatetime())) {
            resultModel.setErrorDesc("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        String json = this.dataparkActivityService.getActivityIds(activityReportRo);
        if (json == null) {
            resultModel.setSuccessed(true);
            return resultModel;
        }
        resultModel = this.dataparkActivityPullerIntegration.pullActivityData(activityReportRo, json);
        return this.dataparkActivityService.pullActivityData((ResultModel<Pagination>)resultModel);
    }

    @RequestMapping(value={"/activityReportApp"}, method={RequestMethod.GET})
    public ResultModel activityReportApp(@RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="keywords") String keywords, @RequestParam(required=false, name="activityId") Long activityId, @RequestParam(required=false, name="pageSize") Integer pageSize, @RequestParam(required=false, name="pageNum") Integer pageNum, @RequestParam(required=false, name="sortName") String sortName, @RequestParam(required=false, name="sortType") String sortType) {
        String json = this.dataparkActivityService.getAppKeys(keywords);
        ResultModel resultModel = this.dataparkActivityPullerIntegration.activityReportApp(datetime, json, activityId, pageSize, pageNum, sortName, sortType);
        return this.dataparkActivityService.pullActivityAppData((ResultModel<Pagination>)resultModel);
    }

    @RequestMapping(value={"/activityReportAppBusiness"}, method={RequestMethod.GET})
    public ResultModel activityReportAppBusiness(@RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="keywords") String keywords, @RequestParam(required=false, name="activityId") Long activityId, @RequestParam(required=false, name="appKey") String appKey, @RequestParam(required=false, name="pageSize") Integer pageSize, @RequestParam(required=false, name="pageNum") Integer pageNum, @RequestParam(required=false, name="sortName") String sortName, @RequestParam(required=false, name="sortType") String sortType) {
        String json = this.dataparkActivityService.getBusiness(appKey, keywords);
        ResultModel resultModel = this.dataparkActivityPullerIntegration.activityReportAppBusiness(datetime, json, activityId, appKey, pageSize, pageNum, sortName, sortType);
        return this.dataparkActivityService.pullActivityAppBusinessData((ResultModel<Pagination>)resultModel);
    }

    @RequestMapping(value={"/activityReportByDate"}, method={RequestMethod.GET})
    public ResultModel activityReportByDate(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="activityId", required=false) Long activityId, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportByDate(startTime, endTime, activityId, sortName, sortType);
        return this.dataparkActivityService.pullActivityByDate(activityCounts);
    }

    @RequestMapping(value={"/activityReportBusinessByDate"}, method={RequestMethod.GET})
    public ResultModel activityReportBusinessByDate(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="activityId") Long activityId, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime, endTime, activityId, appKey, business, sortName, sortType);
        return this.dataparkActivityService.pullActivityBusinessByDate(activityCounts);
    }
}

