/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.report.facade.datapark.DataparkActivityPullerIntegration;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.vo.app.AppBusinessByDateVo;
import com.bxm.report.model.vo.app.AppBusinessTicketVo;
import com.bxm.report.model.vo.app.AppBusinessVo;
import com.bxm.report.model.vo.app.AppByDateVo;
import com.bxm.report.model.vo.app.AppTicketDateVo;
import com.bxm.report.model.vo.app.AppTicketVo;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.model.vo.ticket.TicketWeightHourVo;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.report.service.datapark.DataparkTicketWeightService;
import com.bxm.report.service.report.IAppReportService;
import com.bxm.report.service.utils.ResultModelFactory;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class AppReportController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(AppReportController.class);
    @Autowired
    private IAppReportService appReportService;
    @Autowired
    private DataparkTicketWeightService dataparkTicketWeightService;
    @Autowired
    private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;
    @Autowired
    private DataparkActivityService dataparkActivityService;

    @RequestMapping(value={"/app/getAppCount"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel<Page<AppCountVo>> getAppCount(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="sortName", required=false, defaultValue="openPv") String sortName, @RequestParam(name="sortType", required=false, defaultValue="desc") String sortType, @RequestParam(name="onlineStart", required=false) String onlineStart, @RequestParam(name="onlineEnd", required=false) String onlineEnd) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        User user = this.getUser(request, response);
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.getAppCount(datetime, keyword, user, pageSize, pageNum, sortName, sortType, onlineStart, onlineEnd));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u65e5\u62a5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/business"})
    @ResponseBody
    public ResultModel<Page<AppBusinessVo>> findAppBusinessCount(HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="appKey") String appKey, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="sortName", required=false, defaultValue="openPv") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType, @RequestParam(name="onlineStart", required=false) String onlineStart, @RequestParam(name="onlineEnd", required=false) String onlineEnd) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppBusinessCount(datetime, keyword, appKey, pageSize, pageNum, sortName, sortType, onlineStart, onlineEnd));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u65e5\u62a5\u6309\u5b50\u94fe\u63a5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/date"})
    @ResponseBody
    public ResultModel<List<AppByDateVo>> findAppCountByDate(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppCountDate(appKey, startTime, endTime, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u65e5\u62a5\u6309\u65e5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/business/date"})
    @ResponseBody
    public ResultModel<List<AppBusinessByDateVo>> findAppBusinessCountByDate(HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppBusinessCountByDate(appKey, business, startTime, endTime, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u6309\u65e5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/ticket"})
    @ResponseBody
    public ResultModel<Page<AppTicketVo>> findAppTicket(@RequestParam(name="datetime") String datetime, @RequestParam(name="appKey") String appKey, @RequestParam(name="scene", required=false) Integer scene, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppTicketCount(datetime, appKey, scene, keyword, pageSize, pageNum, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u4e0b\u9762\u7684\u5e7f\u544a\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/ticket/date"})
    @ResponseBody
    public ResultModel<List<AppTicketDateVo>> findAppTicketDate(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppTicketCountDate(startTime, endTime, appKey, certificateid, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u4e0b\u9762\u7684\u5e7f\u544a\u5238\u6309\u65e5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/business/ticketByDay"})
    @ResponseBody
    public ResultModel findAppBusinessTicketByDay(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppBusinessTicketDateReport(startTime, endTime, appKey, certificateid, sortName, sortType, business));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u5e7f\u544a\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/business/ticket"})
    @ResponseBody
    public ResultModel<Page<AppBusinessTicketVo>> findAppBusinessTicket(@RequestParam(name="datetime") String datetime, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="scene", required=false) Integer scene, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType, @RequestParam(name="ticketType", required=false) Integer ticketType) {
        ResultModel resultModel = new ResultModel();
        try {
            if ("packagePrice".equals(sortName)) {
                resultModel.setReturnValue(this.appReportService.findAppBusinessTicketCountPageAfterLoadAll(datetime, appKey, business, scene, keyword, pageSize, pageNum, sortName, sortType, ticketType));
            } else {
                resultModel.setReturnValue(this.appReportService.findAppBusinessTicketCount(datetime, appKey, business, scene, keyword, pageSize, pageNum, sortName, sortType, ticketType));
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u5e7f\u544a\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/business/ticketWeightHour"})
    @ResponseBody
    public ResultModel findAppBusinessTicketWeight(@RequestParam(value="datetime") String datetime, @RequestParam(value="appKey") String appKey, @RequestParam(value="business") String business, @RequestParam(value="ticketId") String ticketId, @RequestParam(required=false, defaultValue="1") int pageNum, @RequestParam(required=false, defaultValue="10") int pageSize) {
        ResultModel resultModel = new ResultModel();
        com.bxm.datapark.facade.weight.TicketWeightHourVo ticketWeightHourVo = this.dataparkTicketWeightService.getTicketHourWeight(datetime, appKey, business, ticketId, pageNum, pageSize);
        TicketWeightHourVo ticketWeightHour = new TicketWeightHourVo();
        ticketWeightHour.setHourList(ticketWeightHourVo.getHourList());
        ticketWeightHour.setWeightList(ticketWeightHourVo.getWeightList());
        ticketWeightHour.setCalculateList(ticketWeightHourVo.getCalculateList());
        resultModel.setReturnValue((Object)ticketWeightHour);
        return resultModel;
    }

    @RequestMapping(value={"/app/business/activity"})
    @ResponseBody
    public ResultModel findAppBusinessActivity(@RequestParam(name="datetime", required=false) String datetime, @RequestParam(name="appKey", required=false) String appKey, @RequestParam(name="business", required=false) String business, @RequestParam(name="keywords", required=false) String keyword, @RequestParam(name="activityType", required=false, defaultValue="") String activityType, @RequestParam(name="activityPlanner", required=false, defaultValue="") String activityPlanner, @RequestParam(name="pageNum", required=false) Integer pageNum, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) throws IOException {
        return this.appReportService.findAppBusinessActivity(keyword, datetime, appKey, business, activityType, activityPlanner, pageSize, pageNum, sortName, sortType);
    }

    @RequestMapping(value={"/app/update"})
    @ResponseBody
    public ResultModel update(@RequestParam(name="iconPv", required=false, defaultValue="0") String iconPv, @RequestParam(name="iconClickPv", required=false, defaultValue="0") String iconClickPv, @RequestParam(name="datetime") String dateTime, @RequestParam(name="business") String business, @RequestParam(name="appKey") String appKey) {
        ResultModel resultModel = new ResultModel();
        resultModel.setSuccessed(false);
        try {
            int result = this.appReportService.updateIconOrClickPv(Integer.parseInt(iconPv), Integer.parseInt(iconClickPv), dateTime, business, appKey);
            if (result == 1) {
                resultModel.setSuccessed(true);
            }
            return resultModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u7f16\u8f91\u5e7f\u544a\u4f4d\u66dd\u5149\u70b9\u51fb\u91cf\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return resultModel;
        }
    }

    @RequestMapping(value={"/app/appCountSumByDate"})
    @ResponseBody
    public ResultModel findAppCountSumByDate(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="desc") String sortType) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        User user = this.getUser(request, response);
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.appReportService.findAppCountSumByDate(startTime, endTime, keyword, user, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u8005\u65e5\u62a5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/app/business/activityByDay"})
    @ResponseBody
    public ResultModel findAppBusinessActivityDateReport(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="activityId") Long activityId, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime, endTime, activityId, appKey, business, sortName, sortType);
        return this.dataparkActivityService.pullActivityBusinessByDate(activityCounts);
    }
}

