/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.position.model.dto.PositionSpareTicketDto;
import com.bxm.datapark.facade.position.model.dto.PositionUserPortraitDto;
import com.bxm.datapark.facade.position.model.vo.PositionSpareTicketVo;
import com.bxm.datapark.facade.position.model.vo.PositionUserPortraitVo;
import com.bxm.report.facade.datapark.DataparkPositionPullerIntegration;
import com.bxm.report.model.dao.monitor.WarnConfig;
import com.bxm.report.model.enums.WarnConfigEnum;
import com.bxm.report.service.monitor.PositionWarnConfigService;
import com.bxm.report.service.monitor.WarnConfigService;
import com.bxm.report.service.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/positionReport"})
public class PositionReportController {
    private static final Logger logger = LoggerFactory.getLogger(PositionReportController.class);
    @Autowired
    private PositionWarnConfigService positionWarnConfigService;
    @Autowired
    private WarnConfigService warnConfigService;
    @Autowired
    private DataparkPositionPullerIntegration positionPullerIntegration;

    @RequestMapping(value={"/spareTicket"}, method={RequestMethod.GET})
    public ResultModel<Page<PositionSpareTicketVo>> analysisBusinessOrder(HttpServletRequest request, PositionSpareTicketDto param) {
        if (null == param) {
            param = new PositionSpareTicketDto();
        }
        try {
            List<String> positionIds;
            WarnConfig warnConfig = this.warnConfigService.selectByConfigKey(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
            if (warnConfig != null && StringUtils.isNotBlank((String)warnConfig.getPropValue())) {
                String propValue = warnConfig.getPropValue();
                String[] param1 = propValue.split(",");
                if (StringUtils.isNumeric((String)param1[0])) {
                    param.setOpenPv(Double.valueOf(param1[0]));
                }
                if (StringUtils.isNotBlank((String)param1[1])) {
                    String[] param2 = param1[1].split("-");
                    if (StringUtils.isNotBlank((String)param2[0]) && StringUtils.isNumeric((String)param2[0])) {
                        param.setSpareOpenProportionMin(Double.valueOf(param2[0]));
                    }
                    if (StringUtils.isNotBlank((String)param2[1]) && StringUtils.isNumeric((String)param2[1])) {
                        param.setSpareOpenProportionMax(Double.valueOf(param2[1]));
                    }
                }
            }
            if (!CollectionUtils.isEmpty(positionIds = this.positionWarnConfigService.getAllConfigPositionId(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey()))) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < positionIds.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(positionIds.get(i));
                }
                param.setExcludePositionIds(sb.toString());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e7f\u544a\u4f4d\u5907\u7528\u5238\u62a5\u8868\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return this.positionPullerIntegration.analysisPositionSpareTicket(param);
    }

    @RequestMapping(value={"/userPortrait"}, method={RequestMethod.GET})
    public ResultModel<Page<PositionUserPortraitVo>> analysisPositionUserPortrait(HttpServletRequest request, PositionUserPortraitDto param) {
        if (null == param) {
            param = new PositionUserPortraitDto();
        }
        return this.positionPullerIntegration.analysisPositionUserPortrait(param);
    }

    @RequestMapping(value={"/userPortraitNoPage"}, method={RequestMethod.GET})
    public ResultModel<List<PositionUserPortraitVo>> analysisPositionUserPortraitNoPage(HttpServletRequest request, PositionUserPortraitDto param) {
        ResultModel resultModel;
        if (null == param) {
            param = new PositionUserPortraitDto();
        }
        if ((resultModel = this.positionPullerIntegration.exportPositionUserPortrait(param)) != null && resultModel.isSuccessed() && !CollectionUtils.isEmpty((Collection)((Collection)resultModel.getReturnValue()))) {
            List list = (List)resultModel.getReturnValue();
            list.remove(0);
            resultModel.setReturnValue((Object)list);
        }
        return resultModel;
    }
}

