/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.report.model.dto.analysis.AnalysisParamsDTO;
import com.bxm.report.model.vo.analysis.AnalysisAppOSVO;
import com.bxm.report.model.vo.analysis.AnalysisMediaVO;
import com.bxm.report.model.vo.analysis.AnalysisPaymentTypeVO;
import com.bxm.report.model.vo.analysis.AnalysisRegionVO;
import com.bxm.report.model.vo.analysis.AnalysisTagTypeVO;
import com.bxm.report.model.vo.analysis.AnalysisTrendVO;
import com.bxm.report.service.datapark.TicketAnalysisService;
import com.bxm.report.service.utils.ExcelUtil;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ticket/analysis"})
public class TicketAnalysisController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TicketAnalysisController.class);
    @Autowired
    private TicketAnalysisService ticketAnalysisService;

    @RequestMapping(value={"/trend"}, method={RequestMethod.GET})
    public ResultModel<Page<AnalysisTrendVO>> trend(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysis(paramsDTO, "TREND"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis by trend fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/media"}, method={RequestMethod.GET})
    public ResultModel<Page<AnalysisMediaVO>> media(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, @RequestParam(required=false) String mediaGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).mediaGroupType(mediaGroupType).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysis(paramsDTO, "MEDIA"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis by media fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/tagType"}, method={RequestMethod.GET})
    public ResultModel<Page<AnalysisTagTypeVO>> tagType(@RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysis(paramsDTO, "TAG_TYPE"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis by tagType fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/region"}, method={RequestMethod.GET})
    public ResultModel<Page<AnalysisRegionVO>> region(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, @RequestParam(required=false) String regionGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).regionGroupType(regionGroupType).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).regionGroupType(regionGroupType).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysis(paramsDTO, "REGION"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis by region fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/appOS"}, method={RequestMethod.GET})
    public ResultModel<Page<AnalysisAppOSVO>> appOS(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysis(paramsDTO, "APP_OS"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis by appOS fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/paymentType"}, method={RequestMethod.GET})
    public ResultModel<Page<AnalysisPaymentTypeVO>> paymentType(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysis(paramsDTO, "PAYMENT_TYPE"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis by paymentType fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/chart/trend"}, method={RequestMethod.GET})
    public ResultModel<Map<String, Map<String, Double>>> trendChart(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysisChart(paramsDTO, "TREND"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by trend fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/chart/media"}, method={RequestMethod.GET})
    public ResultModel<Map<String, Map<String, Double>>> mediaChart(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, @RequestParam(required=false) String mediaGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).mediaGroupType(mediaGroupType).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysisChart(paramsDTO, "MEDIA"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by media fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/chart/tagType"}, method={RequestMethod.GET})
    public ResultModel<Map<String, Map<String, Double>>> tagTypeChart(@RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysisChart(paramsDTO, "TAG_TYPE"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by tagType fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/chart/region"}, method={RequestMethod.GET})
    public ResultModel<Map<String, Map<String, Double>>> regionChart(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, @RequestParam(required=false) String regionGroupType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).regionGroupType(regionGroupType).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysisChart(paramsDTO, "REGION"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by region fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/chart/appOS"}, method={RequestMethod.GET})
    public ResultModel<Map<String, Map<String, Double>>> appOSChart(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysisChart(paramsDTO, "APP_OS"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by appOS fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/chart/paymentType"}, method={RequestMethod.GET})
    public ResultModel<Map<String, Map<String, Double>>> paymentTypeChart(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false, defaultValue="1") Integer pageNum, @RequestParam(required=false, defaultValue="20") Integer pageSize, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(pageNum).pageSize(pageSize).sortFieldName(sortFieldName).sortType(sortType).build();
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.ticketAnalysisService.analysisChart(paramsDTO, "PAYMENT_TYPE"));
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>analysis chart by paymentType fail!", (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc(e.getMessage());
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }

    @RequestMapping(value={"/export/trend"}, method={RequestMethod.GET})
    public void trendExport(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page page = this.ticketAnalysisService.analysis(paramsDTO, "TREND");
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisTrendVO.class, "\u8d8b\u52bf\u7ef4\u5ea6\u5206\u6790.xls", response);
        }
        catch (Exception e) {
            throw new RuntimeException("analysis export by trend fail", e);
        }
    }

    @RequestMapping(value={"/export/media"}, method={RequestMethod.GET})
    public void mediaExport(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, @RequestParam(required=false) String mediaGroupType, HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).mediaGroupType(mediaGroupType).startTime(startTime).endTime(endTime).sortFieldName(sortFieldName).sortType(sortType).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).build();
        try {
            Page page = this.ticketAnalysisService.analysis(paramsDTO, "MEDIA");
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisMediaVO.class, "\u5a92\u4f53\u7ef4\u5ea6\u5206\u6790.xls", response);
        }
        catch (Exception e) {
            throw new RuntimeException("analysis export by media fail", e);
        }
    }

    @RequestMapping(value={"/export/tagType"}, method={RequestMethod.GET})
    public void tagTypeExport(@RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().adPositionId(adPositionId).mediaId(mediaId).startTime(startTime).endTime(endTime).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page page = this.ticketAnalysisService.analysis(paramsDTO, "TAG_TYPE");
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisTagTypeVO.class, "\u5e7f\u544a\u7c7b\u578b\u7ef4\u5ea6\u5206\u6790.xls", response);
        }
        catch (Exception e) {
            throw new RuntimeException("analysis export by tagType fail", e);
        }
    }

    @RequestMapping(value={"/export/region"}, method={RequestMethod.GET})
    public void regionExport(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, @RequestParam(required=false) String regionGroupType, HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).regionGroupType(regionGroupType).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page page = this.ticketAnalysisService.analysis(paramsDTO, "REGION");
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisRegionVO.class, "\u533a\u57df\u7ef4\u5ea6\u5206\u6790.xls", response);
        }
        catch (Exception e) {
            throw new RuntimeException("analysis export by region fail", e);
        }
    }

    @RequestMapping(value={"/export/appOS"}, method={RequestMethod.GET})
    public void appOSExport(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page page = this.ticketAnalysisService.analysis(paramsDTO, "APP_OS");
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisAppOSVO.class, "\u64cd\u4f5c\u7cfb\u7edf\u7ef4\u5ea6\u5206\u6790.xls", response);
        }
        catch (Exception e) {
            throw new RuntimeException("analysis export by appOS fail", e);
        }
    }

    @RequestMapping(value={"/export/paymentType"}, method={RequestMethod.GET})
    public void paymentTypeExport(@RequestParam(required=false) Long ticketId, @RequestParam(required=false) String mediaId, @RequestParam(required=false) String adPositionId, @RequestParam String startTime, @RequestParam String endTime, @RequestParam(required=false) String sortFieldName, @RequestParam(required=false, defaultValue="desc") String sortType, HttpServletResponse response) {
        AnalysisParamsDTO paramsDTO = AnalysisParamsDTO.builder().ticketId(ticketId).mediaId(mediaId).adPositionId(adPositionId).startTime(startTime).endTime(endTime).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).sortFieldName(sortFieldName).sortType(sortType).build();
        try {
            Page page = this.ticketAnalysisService.analysis(paramsDTO, "PAYMENT_TYPE");
            ExcelUtil.exportExcel(page.getList(), null, null, AnalysisPaymentTypeVO.class, "\u652f\u4ed8\u7c7b\u578b\u7ef4\u5ea6\u5206\u6790.xls", response);
        }
        catch (Exception e) {
            throw new RuntimeException("analysis export by paymentType fail", e);
        }
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResultModel handleBadJSONException(HttpMessageNotReadableException ex) {
        ResultModel resultModel = new ResultModel();
        resultModel.setSuccessed(false);
        resultModel.setErrorCode("500");
        resultModel.setErrorDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53c2\u6570\uff01");
        return resultModel;
    }
}

