/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.TicketUrlDto;
import com.bxm.datapark.facade.ticket.model.vo.TicketUrlVo;
import com.bxm.report.facade.datapark.DataparkTicketPullerIntegration;
import com.bxm.report.model.dao.monitor.WarnConfig;
import com.bxm.report.model.enums.WarnConfigEnum;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;
import com.bxm.report.service.monitor.TicketWarnConfigService;
import com.bxm.report.service.monitor.WarnConfigService;
import com.bxm.report.service.report.ITicketReportService;
import com.bxm.report.service.utils.ResultModelFactory;
import com.bxm.report.web.controller.AppReportController;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class TicketReportController {
    private static final Logger logger = LoggerFactory.getLogger(AppReportController.class);
    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private ITicketReportService ticketReportService;
    @Autowired
    private WarnConfigService warnConfigService;
    @Autowired
    private TicketWarnConfigService ticketWarnConfigService;

    @RequestMapping(value={"/ticketReportHour"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel ticketReportHour(@RequestParam(name="certificateid") Long certificateid, @RequestParam(name="datetime") String datetime, @RequestParam(name="sHour", required=false) Integer sHour, @RequestParam(name="eHour", required=false) Integer eHour, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="pageNum", required=false) Integer pageNum, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        ResultModel resultModel = this.dataparkTicketPullerIntegration.ticketData(certificateid, null, null, datetime, sHour, eHour, pageSize, pageNum, sortName, sortType);
        return resultModel;
    }

    @RequestMapping(value={"/ticketAppReportHour"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel ticketAppReportHour(@RequestParam(name="certificateid") Long certificateid, @RequestParam(name="appKey", required=false) String appKey, @RequestParam(name="datetime") String datetime, @RequestParam(name="sHour", required=false) Integer sHour, @RequestParam(name="eHour", required=false) Integer eHour, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="pageNum", required=false) Integer pageNum, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        ResultModel resultModel = this.dataparkTicketPullerIntegration.ticketData(certificateid, appKey, null, datetime, sHour, eHour, pageSize, pageNum, sortName, sortType);
        return resultModel;
    }

    @RequestMapping(value={"/ticketBusinessReportHour"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel ticketBusinessReportHour(@RequestParam(name="certificateid") Long certificateid, @RequestParam(name="appKey", required=false) String appKey, @RequestParam(name="business", required=false) String business, @RequestParam(name="datetime") String datetime, @RequestParam(name="sHour", required=false) Integer sHour, @RequestParam(name="eHour", required=false) Integer eHour, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="pageNum", required=false) Integer pageNum, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        ResultModel resultModel = this.dataparkTicketPullerIntegration.ticketData(certificateid, appKey, business, datetime, sHour, eHour, pageSize, pageNum, sortName, sortType);
        return resultModel;
    }

    @RequestMapping(value={"/ticket"})
    @ResponseBody
    public ResultModel<Page<TicketCountVo>> findTicketCount(@RequestParam(name="datetime") String datetime, @RequestParam(name="scene", required=false) Integer scene, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType, @RequestParam(name="ae") String ae, @RequestParam(name="ticketType", required=false) Integer ticketType, Integer tagCode) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.ticketReportService.findTicketCount(datetime, scene, keyword, pageNum, pageSize, sortName, sortType, ae, ticketType, tagCode));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e7f\u544a\u5238\u7ef4\u5ea6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/ticket/app"})
    @ResponseBody
    public ResultModel<Page<TicketAppVo>> findTicketAppCount(@RequestParam(name="datetime") String datetime, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.ticketReportService.findTicketAppCount(datetime, certificateid, keyword, pageNum, pageSize, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e7f\u544a\u5238\u5f00\u53d1\u8005\u7ef4\u5ea6\u7ef4\u5ea6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/ticket/app/business"})
    @ResponseBody
    public ResultModel<Page<TicketAppBusinessVo>> findTicketAppBusinessCount(@RequestParam(name="datetime") String datetime, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="appKey") String appKey, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.ticketReportService.findTicketAppBusinessCount(datetime, certificateid, appKey, keyword, pageNum, pageSize, sortName, sortType));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e7f\u544a\u5238\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u7ef4\u5ea6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping(value={"/ticket/date"})
    @ResponseBody
    public ResultModel<List<TicketDateVo>> findTicketCountDate(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.ticketReportService.findTicketCountDate(startTime, endTime, certificateid, sortName, sortType));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            logger.error("\u5e7f\u544a\u5238\u6309\u65e5\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        return resultModel;
    }

    @RequestMapping(value={"/ticketUrl"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel<Page<TicketUrlVo>> analysisTicketUrl(HttpServletRequest request, TicketUrlDto param) {
        if (null == param) {
            param = new TicketUrlDto();
        }
        try {
            List<Long> ticketIds;
            WarnConfig warnConfig = this.warnConfigService.selectByConfigKey(WarnConfigEnum.TICKET_URL.getConfigKey());
            if (warnConfig != null && StringUtils.isNotBlank((CharSequence)warnConfig.getPropValue())) {
                String propValue = warnConfig.getPropValue();
                String[] param1 = propValue.split(",");
                if (StringUtils.isNumeric((CharSequence)param1[0])) {
                    param.setClickPv(Double.valueOf(param1[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)param1[1])) {
                    String[] param2 = param1[1].split("-");
                    if (StringUtils.isNotBlank((CharSequence)param2[0]) && StringUtils.isNumeric((CharSequence)param2[0])) {
                        param.setExposureRateMin(Double.valueOf(param2[0]));
                    }
                    if (StringUtils.isNotBlank((CharSequence)param2[1]) && StringUtils.isNumeric((CharSequence)param2[1])) {
                        param.setExposureRateMax(Double.valueOf(param2[1]));
                    }
                }
            }
            if (!CollectionUtils.isEmpty(ticketIds = this.ticketWarnConfigService.getAllConfigTicketId(WarnConfigEnum.TICKET_URL.getConfigKey()))) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < ticketIds.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(ticketIds.get(i));
                }
                param.setExcludeCertificateIds(sb.toString());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e7f\u544a\u5238\u843d\u5730\u9875\u62a5\u8868\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return this.dataparkTicketPullerIntegration.analysisTicketUrl(param);
    }
}

