/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.controller;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.report.service.datapark.VenueReportService;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class VenueReportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VenueReportController.class);
    @Autowired
    private VenueReportService venueReportService;

    @ResponseBody
    @RequestMapping(value={"/venue/report"}, produces={"application/json;charset=UTF-8"})
    public ResultModel<Page<VenueReportVo>> venueReport(VenueReportDto dto) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.venueReportService.venueReport(dto));
        }
        catch (Exception e) {
            resultModel.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("/venue/report error ", (Throwable)e);
        }
        return resultModel;
    }

    @ResponseBody
    @RequestMapping(value={"/venue/activity/report"}, produces={"application/json;charset=UTF-8"})
    public ResultModel<Page<VenueReportVo>> venueActivityReport(VenueReportDto dto) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.venueReportService.venueActivityReport(dto));
        }
        catch (Exception e) {
            resultModel.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("/venue/report error ", (Throwable)e);
        }
        return resultModel;
    }

    @ResponseBody
    @RequestMapping(value={"/venue/date/report"}, produces={"application/json;charset=UTF-8"})
    public ResultModel<Page<VenueReportVo>> venueDateReport(VenueReportDto dto) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue(this.venueReportService.venueDateReport(dto));
        }
        catch (Exception e) {
            resultModel.setSuccessed(Boolean.FALSE.booleanValue());
            LOGGER.error("/venue/report error ", (Throwable)e);
        }
        return resultModel;
    }
}

