/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.exclude;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityReportDto;
import com.bxm.datapark.facade.order.model.dto.BusinessOrderDto;
import com.bxm.datapark.facade.order.model.vo.BusinessOrderVo;
import com.bxm.datapark.facade.position.model.dto.PositionUserPortraitDto;
import com.bxm.datapark.facade.position.model.vo.PositionUserPortraitVo;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.report.facade.datapark.DataparkActivityPullerIntegration;
import com.bxm.report.facade.datapark.DataparkAnalysisDatePullerIntegration;
import com.bxm.report.facade.datapark.DataparkBusinessOrderPullerIntegration;
import com.bxm.report.facade.datapark.DataparkPositionPullerIntegration;
import com.bxm.report.facade.datapark.DataparkTicketPullerIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.adposition.PositionUserPortraitNewVo;
import com.bxm.report.model.dao.order.BusinessOrderNewVo;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.model.dao.venue.VenueActivityReportExcelVo;
import com.bxm.report.model.dao.venue.VenueDateReportExcelVo;
import com.bxm.report.model.dao.venue.VenueReportExcelVo;
import com.bxm.report.model.release.AnalysisDateVo;
import com.bxm.report.model.release.PutAnalysisEntityDto;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.report.model.vo.activity.ActivityVo;
import com.bxm.report.model.vo.app.AppBusinessByDateVo;
import com.bxm.report.model.vo.app.AppBusinessTicketDateVo;
import com.bxm.report.model.vo.app.AppBusinessTicketVo;
import com.bxm.report.model.vo.app.AppBusinessVo;
import com.bxm.report.model.vo.app.AppByDateVo;
import com.bxm.report.model.vo.app.AppTicketDateVo;
import com.bxm.report.model.vo.app.AppTicketVo;
import com.bxm.report.model.vo.appcount.AppCountVo;
import com.bxm.report.model.vo.ticket.TicketAppBusinessVo;
import com.bxm.report.model.vo.ticket.TicketAppVo;
import com.bxm.report.model.vo.ticket.TicketCountVo;
import com.bxm.report.model.vo.ticket.TicketDateVo;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.report.service.datapark.DataparkTicketService;
import com.bxm.report.service.datapark.VenueReportService;
import com.bxm.report.service.report.IAppReportService;
import com.bxm.report.service.report.ITicketReportService;
import com.bxm.report.service.utils.ExcelUtil;
import com.bxm.report.service.utils.ObjectUtils;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dozer.Mapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exclude"})
public class ExcludeReortController
extends BaseController {
    private static final Logger logger = Logger.getLogger(ExcludeReortController.class);
    @Autowired
    private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;
    @Autowired
    private DataparkActivityService dataparkActivityService;
    @Autowired
    private IAppReportService appReportService;
    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private DataparkTicketService dataparkTicketService;
    @Autowired
    private ITicketReportService ticketReportService;
    @Autowired
    private DataparkAnalysisDatePullerIntegration dataparkAnalysisDatePullerIntegration;
    @Autowired
    private DataparkPositionPullerIntegration positionPullerIntegration;
    @Autowired
    private DataparkBusinessOrderPullerIntegration businessOrderPullerIntegration;
    @Autowired
    private VenueReportService venueReportService;
    @Autowired
    private Mapper mapper;

    @RequestMapping(value={"/newActivityReportExport"}, method={RequestMethod.GET})
    public void activityReportByDateExport(HttpServletResponse response, ActivityReportDto dto) {
        List activityReportVos = this.dataparkActivityPullerIntegration.newActivityReportExport(dto);
        this.dataparkActivityService.newActivityReportExport(activityReportVos, response);
    }

    @RequestMapping(value={"/activityReportByDateExport"}, method={RequestMethod.GET})
    public void activityReportByDateExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="activityId") Long activityId, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportByDate(startTime, endTime, activityId, sortName, sortType);
        this.dataparkActivityService.activityReportByDateExport(activityCounts, response);
    }

    @RequestMapping(value={"/activityReportAppExport"}, method={RequestMethod.GET})
    public void activityReportAppExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="keywords") String keywords, @RequestParam(required=false, name="activityId") Long activityId) {
        String json = this.dataparkActivityService.getAppKeys(keywords);
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportAppExport(datetime, json, activityId);
        this.dataparkActivityService.activityReportAppExport(activityCounts, response);
    }

    @RequestMapping(value={"/activityReportAppBusinessExport"}, method={RequestMethod.GET})
    public void activityReportAppBusinessExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="keywords") String keywords, @RequestParam(required=false, name="activityId") Long activityId, @RequestParam(required=false, name="appKey") String appKey) {
        String json = this.dataparkActivityService.getBusiness(appKey, keywords);
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportAppBusinessExport(datetime, json, activityId, appKey);
        this.dataparkActivityService.activityReportAppBusinessExport(activityCounts, response);
    }

    @RequestMapping(value={"/activityReportBusinessByDateExport"}, method={RequestMethod.GET})
    public void activityReportBusinessByDateExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="activityId") Long activityId, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime, endTime, activityId, appKey, business, sortName, sortType);
        this.dataparkActivityService.activityReportBusinessByDateExport(activityCounts, response);
    }

    @RequestMapping(value={"/activityReportExport"}, method={RequestMethod.GET})
    public String activityReportExport(HttpServletRequest request, HttpServletResponse response, ActivityReportRo activityReportRo) {
        if (StringUtils.isEmpty((CharSequence)activityReportRo.getDatetime())) {
            return "\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String json = this.dataparkActivityService.getActivityIds(activityReportRo);
        if (json == null) {
            return "\u6ca1\u6709\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa";
        }
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportExport(activityReportRo.getDatetime(), json);
        this.dataparkActivityService.activityReportExport(activityCounts, response);
        return "";
    }

    @RequestMapping(value={"/app/business/export"})
    public void findAppBusinessCountExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="appKey") String appKey, @RequestParam(name="sortName", required=false, defaultValue="openPv") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType, @RequestParam(name="onlineStart", required=false) String onlineStart, @RequestParam(name="onlineEnd", required=false) String onlineEnd) {
        List<AppBusinessVo> appBusinessCounts = null;
        try {
            appBusinessCounts = this.appReportService.findAppBusinessCountExport(datetime, keyword, appKey, sortName, sortType, onlineStart, onlineEnd);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u65e5\u62a5\u6309\u5b50\u94fe\u63a5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appBusinessCounts, null, null, AppBusinessVo.class, "\u5f00\u53d1\u8005\u65e5\u62a5\u6309\u5b50\u94fe\u63a5.xls", response);
    }

    @RequestMapping(value={"/app/business/activityExport"})
    public void AppBusinessActivityExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime", required=false) String datetime, @RequestParam(name="appKey", required=false) String appKey, @RequestParam(name="business", required=false) String business, @RequestParam(name="keywords", required=false) String keyword) throws IOException {
        List<ActivityVo> list = this.appReportService.appBusinessActivityExport(datetime, appKey, business, keyword);
        ExcelUtil.exportExcel(list, null, null, ActivityVo.class, "\u5f00\u53d1\u8005\u5b50\u6e20\u9053\u6309\u6d3b\u52a8.xls", response);
    }

    @RequestMapping(value={"/app/business/date/export"})
    public void findAppBusinessCountByDateExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        List<AppBusinessByDateVo> appCounts = null;
        try {
            appCounts = this.appReportService.findAppBusinessCountByDate(appKey, business, startTime, endTime, sortName, sortType);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u6309\u65e5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appCounts, null, null, AppBusinessByDateVo.class, "\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u65e5\u62a5.xls", response);
    }

    @RequestMapping(value={"/app/business/ticket/export"})
    public void findAppBusinessTicketExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="scene", required=false) Integer scene, @RequestParam(name="datetime") String datetime, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="json", required=false) String keyword, @RequestParam(name="ticketType", required=false) Integer ticketType) {
        List<AppBusinessTicketVo> appBusinessTickets = null;
        try {
            appBusinessTickets = this.appReportService.findAppBusinessTicketExport(datetime, appKey, business, scene, keyword, ticketType);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u5e7f\u544a\u5238\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appBusinessTickets, null, null, AppBusinessTicketVo.class, "\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u5e7f\u544a\u5238.xls", response);
    }

    @RequestMapping(value={"/app/date/export"})
    public void findAppCountByDateExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        List<AppByDateVo> appCounts = null;
        try {
            appCounts = this.appReportService.findAppCountDate(appKey, startTime, endTime, sortName, sortType);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u65e5\u62a5\u6309\u65e5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appCounts, null, null, AppByDateVo.class, "\u5f00\u53d1\u8005\u65e5\u62a5\u6309\u65e5.xls", response);
    }

    @RequestMapping(value={"/app/export"}, method={RequestMethod.GET})
    public void getAppCountExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType, @RequestParam(name="onlineStart", required=false) String onlineStart, @RequestParam(name="onlineEnd", required=false) String onlineEnd) {
        User user = this.getUser(request, response);
        List<AppCountVo> appCounts = null;
        try {
            appCounts = this.appReportService.getAppCountExport(datetime, keyword, user, sortName, sortType, onlineStart, onlineEnd);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u65e5\u62a5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appCounts, null, null, AppCountVo.class, "\u5f00\u53d1\u8005\u65e5\u62a5.xls", response);
    }

    @RequestMapping(value={"/app/ticket/export"})
    public void appTicketExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="scene", required=false) Integer scene, @RequestParam(name="datetime") String datetime, @RequestParam(name="appKey") String appKey, @RequestParam(name="keyword", required=false) String keyword) {
        List<AppTicketVo> appTicketCounts = null;
        try {
            appTicketCounts = this.appReportService.findAppTicketCount(datetime, appKey, scene, keyword);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u4e0b\u9762\u7684\u5e7f\u544a\u5238\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appTicketCounts, null, null, AppTicketVo.class, "\u5f00\u53d1\u8005\u5e7f\u544a\u5238\u65e5\u62a5.xls", response);
    }

    @RequestMapping(value={"/app/ticket/date/export"})
    public void findAppTicketDateExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType) {
        List<AppTicketDateVo> appTicketCountDates = null;
        try {
            appTicketCountDates = this.appReportService.findAppTicketCountDate(startTime, endTime, appKey, certificateid, sortName, sortType);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u4e0b\u9762\u7684\u5e7f\u544a\u5238\u6309\u65e5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appTicketCountDates, null, null, AppTicketDateVo.class, "\u5f00\u53d1\u8005\u5e7f\u544a\u5238\u6309\u65e5.xls", response);
    }

    @RequestMapping(value={"/ticket/date/export"})
    public void findTicketCountDateExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="sortName", required=false, defaultValue="datetime") String sortName, @RequestParam(name="sortType", required=false, defaultValue="asc") String sortType, String customExportFieldStr, Integer showIncreaseFlag) {
        List<TicketDateVo> ticketCountDates = null;
        try {
            ticketCountDates = this.ticketReportService.findTicketCountDate(startTime, endTime, certificateid, sortName, sortType);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5e7f\u544a\u5238\u6309\u65e5\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.customFieldExport(ticketCountDates, TicketDateVo.class, customExportFieldStr, showIncreaseFlag, "\u5e7f\u544a\u5238\u6309\u65e5.xls", response);
    }

    @RequestMapping(value={"/ticket/app/export"})
    public void findTicketAppCountExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="json", required=false) String keyword, String customExportFieldStr, Integer showIncreaseFlag) {
        List<TicketAppVo> ticketAppCounts = null;
        try {
            ticketAppCounts = this.ticketReportService.findTicketAppCountExport(datetime, certificateid, keyword);
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2\u5e7f\u544a\u5238\u7ef4\u5ea6\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.customFieldExport(ticketAppCounts, TicketAppVo.class, customExportFieldStr, showIncreaseFlag, "\u5e7f\u544a\u5238\u5f00\u53d1\u8005.xls", response);
    }

    @RequestMapping(value={"/ticket/app/business/export"})
    public void findTicketAppBusinessCountExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="appKey") String appKey, @RequestParam(name="json", required=false) String keyword, String customExportFieldStr, Integer showIncreaseFlag) {
        List<TicketAppBusinessVo> ticketAppCounts = null;
        try {
            ticketAppCounts = this.ticketReportService.findTicketAppBusinessCountExport(datetime, certificateid, appKey, keyword);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5e7f\u544a\u5238\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u7ef4\u5ea6\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.customFieldExport(ticketAppCounts, TicketAppBusinessVo.class, customExportFieldStr, showIncreaseFlag, "\u5e7f\u544a\u5238\u5f00\u53d1\u8005\u5b50\u94fe\u63a5.xls", response);
    }

    @RequestMapping(value={"/ticketReportBusinessHourExport"}, method={RequestMethod.GET})
    public void ticketReportBusinessHourExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="appKey", required=false) String appKey, @RequestParam(name="business", required=false) String business, @RequestParam(name="datetime") String datetime, @RequestParam(name="sHour", required=false) Integer sHour, @RequestParam(name="eHour", required=false) Integer eHour, String customExportFieldStr, Integer showIncreaseFlag) {
        List list = this.dataparkTicketPullerIntegration.ticketHoursExport(datetime, certificateid, appKey, business, sHour, eHour);
        this.dataparkTicketService.ticketDataExport(list, customExportFieldStr, showIncreaseFlag, response);
    }

    @RequestMapping(value={"/ticketReportAppHourExport"}, method={RequestMethod.GET})
    public void ticketReportAppHourExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="appKey", required=false) String appKey, @RequestParam(name="datetime") String datetime, @RequestParam(name="sHour", required=false) Integer sHour, @RequestParam(name="eHour", required=false) Integer eHour, String customExportFieldStr, Integer showIncreaseFlag) {
        List list = this.dataparkTicketPullerIntegration.ticketHoursExport(datetime, certificateid, appKey, null, sHour, eHour);
        this.dataparkTicketService.ticketDataExport(list, customExportFieldStr, showIncreaseFlag, response);
    }

    @RequestMapping(value={"/ticketReportHourExport"}, method={RequestMethod.GET})
    public void ticketReportHourExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="datetime") String datetime, @RequestParam(name="sHour", required=false) Integer sHour, @RequestParam(name="eHour", required=false) Integer eHour, String customExportFieldStr, Integer showIncreaseFlag) {
        List list = this.dataparkTicketPullerIntegration.ticketHoursExport(datetime, certificateid, null, null, sHour, eHour);
        this.dataparkTicketService.ticketDataExport(list, customExportFieldStr, showIncreaseFlag, response);
    }

    @RequestMapping(value={"/ticket/export"})
    public void findTicketCount(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="datetime") String datetime, @RequestParam(name="scene", required=false) Integer scene, @RequestParam(name="json", required=false) String keyword, @RequestParam(name="ae", required=false) String ae, @RequestParam(name="ticketType", required=false) Integer ticketType, String customExportFieldStr, Integer showIncreaseFlag, Integer tagCode) {
        List<TicketCountVo> ticketCounts = null;
        try {
            ticketCounts = this.ticketReportService.findTicketCountExport(datetime, scene, keyword, ae, ticketType, tagCode);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5e7f\u544a\u5238\u7ef4\u5ea6\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.customFieldExport(ticketCounts, TicketCountVo.class, customExportFieldStr, showIncreaseFlag, "\u5e7f\u544a\u5238.xls", response);
    }

    @RequestMapping(value={"/app/appCountSumByDateExport"}, method={RequestMethod.GET})
    public void findAppCountSumByDate(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="keyword", required=false) String keyword) {
        User user = this.getUser(request, response);
        List<AppCountVo> appCounts = null;
        try {
            appCounts = this.appReportService.appCountSumByDateExport(startTime, endTime, keyword, user);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005\u65e5\u62a5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appCounts, null, null, AppCountVo.class, "\u5f00\u53d1\u8005\u5408\u8ba1\u6309\u65e5.xls", response);
    }

    @RequestMapping(value={"/app/business/ticketByDayExport"}, method={RequestMethod.GET})
    public void findAppCountSumByDate(HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="certificateid") Long certificateid, @RequestParam(name="sortName", defaultValue="openPv") String sortName, @RequestParam(name="sortType", defaultValue="desc") String sortType) {
        List<AppBusinessTicketDateVo> appBusinessTicketDateReport = null;
        try {
            appBusinessTicketDateReport = this.appReportService.findAppBusinessTicketDateReport(startTime, endTime, appKey, certificateid, sortName, sortType, business);
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u51fa\u5f00\u53d1\u8005-\u5b50\u94fe\u63a5-\u5e7f\u544a\u5238-\u65e5\u62a5\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        ExcelUtil.exportExcel(appBusinessTicketDateReport, null, null, AppBusinessTicketDateVo.class, "\u5f00\u53d1\u8005\u5b50\u94fe\u63a5\u5e7f\u544a\u5238\u6309\u65e5.xls", response);
    }

    @RequestMapping(value={"/analysis/export/AllList"}, method={RequestMethod.GET})
    public void findAnalysisPutDateExport(PutAnalysisEntityDto putAnalysisEntityDto, HttpServletResponse response) {
        ResultModel resultModel = null;
        try {
            putAnalysisEntityDto.setPage(false);
            Map<String, Object> map = ObjectUtils.objectToMap(putAnalysisEntityDto);
            resultModel = this.dataparkAnalysisDatePullerIntegration.pullAnalysisPutDateCount(map);
            Pagination pagination = (Pagination)resultModel.getReturnValue();
            if (pagination.getList().size() > 0) {
                ExcelUtil.exportExcel(pagination.getList(), null, null, pagination.getList().get(0).getClass(), "\u6295\u653e\u5206\u6790\u62a5\u8868.xls", response);
            } else {
                ExcelUtil.exportExcel(pagination.getList(), null, null, AnalysisDateVo.class, "\u6295\u653e\u5206\u6790\u62a5\u8868.xls", response);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/app/business/activityByDayExport"}, method={RequestMethod.GET})
    public void appBusinessActivityDateReportExport(HttpServletResponse response, @RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime, @RequestParam(name="activityId") Long activityId, @RequestParam(name="appKey") String appKey, @RequestParam(name="business") String business, @RequestParam(name="sortName", required=false) String sortName, @RequestParam(name="sortType", required=false) String sortType) {
        List activityCounts = this.dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime, endTime, activityId, appKey, business, sortName, sortType);
        this.dataparkActivityService.activityReportBusinessByDateExport(activityCounts, response);
        this.dataparkActivityService.appBusinessActivityDateReportExport(activityCounts, response);
    }

    @RequestMapping(value={"/positionReport/exportUserPortrait"}, method={RequestMethod.GET})
    public void exportPositionUserPortrait(HttpServletRequest request, HttpServletResponse response, PositionUserPortraitDto param) {
        if (null == param) {
            param = new PositionUserPortraitDto();
        }
        ResultModel resultModel = this.positionPullerIntegration.exportPositionUserPortrait(param);
        List list = null;
        list = resultModel != null && resultModel.isSuccessed() && !CollectionUtils.isEmpty((Collection)((Collection)resultModel.getReturnValue())) ? (List)resultModel.getReturnValue() : new ArrayList();
        ArrayList<PositionUserPortraitNewVo> resultList = null;
        if (!CollectionUtils.isEmpty(list)) {
            resultList = new ArrayList<PositionUserPortraitNewVo>();
            PositionUserPortraitNewVo newVo = null;
            for (PositionUserPortraitVo record : list) {
                newVo = new PositionUserPortraitNewVo();
                BeanUtils.copyProperties((Object)record, (Object)newVo);
                resultList.add(newVo);
            }
        } else {
            resultList = new ArrayList();
        }
        ExcelUtil.exportExcel(resultList, null, null, PositionUserPortraitNewVo.class, "\u5e7f\u544a\u4f4d\u7528\u6237\u753b\u50cf\u62a5\u8868.xls", response);
    }

    @RequestMapping(value={"/businessOrderReport/exportUserOrder"}, method={RequestMethod.GET})
    public void exportUserOrder(HttpServletRequest request, HttpServletResponse response, BusinessOrderDto param) {
        if (null == param) {
            param = new BusinessOrderDto();
        }
        ResultModel resultModel = this.businessOrderPullerIntegration.exportUserOrder(param);
        List list = null;
        list = resultModel != null && resultModel.isSuccessed() && !CollectionUtils.isEmpty((Collection)((Collection)resultModel.getReturnValue())) ? (List)resultModel.getReturnValue() : new ArrayList();
        ArrayList<BusinessOrderNewVo> resultList = null;
        if (!CollectionUtils.isEmpty(list)) {
            resultList = new ArrayList<BusinessOrderNewVo>();
            BusinessOrderNewVo newVo = null;
            for (BusinessOrderVo record : list) {
                newVo = new BusinessOrderNewVo();
                BeanUtils.copyProperties((Object)record, (Object)newVo);
                resultList.add(newVo);
            }
        } else {
            resultList = new ArrayList();
        }
        ExcelUtil.exportExcel(resultList, null, null, BusinessOrderNewVo.class, "\u8d27\u5230\u8ba2\u5355\u62a5\u8868.xls", response);
    }

    @RequestMapping(value={"/venue/exportVenueReport"})
    public void exportVenueReport(HttpServletResponse response, VenueReportDto dto) {
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        Page<VenueReportVo> venueReportVoPage = this.venueReportService.venueReport(dto);
        ArrayList<VenueReportExcelVo> list = new ArrayList<VenueReportExcelVo>();
        if (!CollectionUtils.isEmpty((Collection)venueReportVoPage.getList())) {
            for (VenueReportVo rs : venueReportVoPage.getList()) {
                VenueReportExcelVo newVo = new VenueReportExcelVo();
                BeanUtils.copyProperties((Object)rs, (Object)newVo);
                list.add(newVo);
            }
        }
        ExcelUtil.exportExcel(list, null, null, VenueReportExcelVo.class, "\u805a\u5408\u9875\u62a5\u8868.xls", response);
    }

    @RequestMapping(value={"/venue/exportVenueActivityReport"})
    public void exportVenueActivityReport(HttpServletResponse response, VenueReportDto dto) {
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        Page<VenueReportVo> venueReportVoPage = this.venueReportService.venueActivityReport(dto);
        ArrayList<VenueActivityReportExcelVo> list = new ArrayList<VenueActivityReportExcelVo>();
        if (!CollectionUtils.isEmpty((Collection)venueReportVoPage.getList())) {
            for (VenueReportVo rs : venueReportVoPage.getList()) {
                VenueActivityReportExcelVo newVo = new VenueActivityReportExcelVo();
                BeanUtils.copyProperties((Object)rs, (Object)newVo);
                list.add(newVo);
            }
        }
        ExcelUtil.exportExcel(list, null, null, VenueActivityReportExcelVo.class, "\u805a\u5408\u9875\u6d3b\u52a8\u62a5\u8868.xls", response);
    }

    @RequestMapping(value={"/venue/exportVenueDateReport"})
    public void exportVenueDateReport(HttpServletResponse response, VenueReportDto dto) {
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        Page<VenueReportVo> venueReportVoPage = this.venueReportService.venueDateReport(dto);
        ArrayList<VenueDateReportExcelVo> list = new ArrayList<VenueDateReportExcelVo>();
        if (!CollectionUtils.isEmpty((Collection)venueReportVoPage.getList())) {
            for (VenueReportVo rs : venueReportVoPage.getList()) {
                VenueDateReportExcelVo newVo = new VenueDateReportExcelVo();
                BeanUtils.copyProperties((Object)rs, (Object)newVo);
                list.add(newVo);
            }
        }
        ExcelUtil.exportExcel(list, null, null, VenueDateReportExcelVo.class, "\u805a\u5408\u9875\u6309\u65e5\u62a5\u8868.xls", response);
    }
}

