/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.web.interceptor;

import com.alibaba.fastjson.JSONArray;
import com.bxm.report.model.dao.user.User;
import com.bxm.report.service.auth.ValidationService;
import com.bxm.report.service.auth.impl.ValidationServiceImpl;
import com.bxm.report.service.utils.IPUtils;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
public class AuthInterceptor
extends HandlerInterceptorAdapter {
    private final Logger logger = Logger.getLogger(AuthInterceptor.class);
    private String AUTH_KEY_PRE = "AD:AUTH:";
    @Autowired
    private ValidationService validationService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String testOnOff;
        String token = request.getHeader("token");
        String ip = IPUtils.getIp(request);
        if (this.validationService == null) {
            WebApplicationContext factory = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
            this.validationService = (ValidationServiceImpl)factory.getBean("validationServiceImpl");
        }
        if ((testOnOff = (String)this.validationService.testOnOff()) != null) {
            User user = (User)JSONArray.parseObject((String)testOnOff, User.class);
            request.getSession().setAttribute("user", (Object)user);
            return true;
        }
        if (token == null) {
            request.getRequestDispatcher("/notLogin").forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        token = this.AUTH_KEY_PRE + token;
        String result = (String)this.validationService.verifyAccessToken(token);
        if (result == null) {
            request.getRequestDispatcher("/noAuth").forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        User user = (User)JSONArray.parseObject((String)result, User.class);
        request.getSession().setAttribute("user", (Object)user);
        this.logger.info((Object)("\u7528\u6237\u6743\u9650\u9a8c\u8bc1\u6210\u529fuser:" + user.getUsername() + ",ip:" + ip + ",\u8bbf\u95ee\u5185\u5bb9:" + request.getRequestURI()));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

