/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.advertiser;

import com.bxm.adsprod.facade.advertiser.Advertiser;
import com.bxm.report.facade.feignservice.AdvertiserFeignService;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dto.advertiser.AdvertiserDto;
import com.bxm.report.model.dto.advertiser.AdvertiserNewDto;
import com.bxm.report.model.vo.advertiser.AdvertiserVo;
import com.bxm.util.StringUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class AdShopIntegration {
    private static final Logger logger = Logger.getLogger(AdShopIntegration.class);
    @Autowired
    private AdvertiserFeignService advertiserFeignService;

    public List<AdvertiserDto> getAdShopList(AdvertiserDto search) throws Exception {
        if (null == search) {
            search = new AdvertiserDto();
        }
        List<Advertiser> listAdvertiser = this.advertiserFeignService.getList(search.getCompany(), null, search.getAccountType(), search.getAe(), search.getSale(), search.getId()).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty(listAdvertiser)) {
            for (Advertiser advertiser : listAdvertiser) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties(advertiser, advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public Pagination getAdvertiserList(AdvertiserNewDto search) throws Exception {
        if (null == search) {
            search = new AdvertiserNewDto();
        }
        if (StringUtil.isNotEmpty(search.getKeywords()) && StringUtil.isNumeric(search.getKeywords())) {
            search.setId(Integer.valueOf(search.getKeywords()));
        }
        Pagination pageBean = new Pagination();
        PageInfo<Advertiser> page = this.advertiserFeignService.getList(search.getPageNum(), search.getPageSize(), search.getOrderParam(), search.getOrderType(), search.getKeywords(), null, null, search.getAgentId(), search.getAccountType(), search.getAe(), search.getSale(), search.getId(), (byte)1).getReturnValue();
        ArrayList<AdvertiserVo> lists = new ArrayList<AdvertiserVo>();
        pageBean.setTotalCount(Integer.parseInt(page.getTotal() + ""));
        pageBean.setPageNo(Integer.parseInt(page.getPageNum() + ""));
        pageBean.setPageSize(Integer.parseInt(page.getPageSize() + ""));
        List<Advertiser> listAdvertiser = page.getList();
        if (CollectionUtils.isNotEmpty(listAdvertiser)) {
            for (Advertiser advertiser : listAdvertiser) {
                AdvertiserVo advertiserVo = new AdvertiserVo();
                BeanUtils.copyProperties(advertiser, advertiserVo);
                lists.add(advertiserVo);
            }
        }
        pageBean.setList(lists);
        return pageBean;
    }

    public Map<Integer, String> getAllAdvertiserMap() throws Exception {
        List<AdvertiserDto> adShopList = this.getAdShopList(new AdvertiserDto());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (CollectionUtils.isNotEmpty(adShopList)) {
            adShopList.forEach(e -> map.put(e.getId(), e.getCompany()));
        }
        return map;
    }

    public Pagination getAdvertiserPage(Map<String, Object> param) throws Exception {
        Integer id = null;
        String keywords = null;
        if (null != param.get("id") && StringUtil.isNotBlank(param.get("id") + "")) {
            id = Integer.parseInt(param.get("id") + "");
        }
        if (null != param.get("keywords") && StringUtil.isNotBlank(param.get("keywords") + "")) {
            keywords = param.get("keywords") + "";
        }
        PageInfo<Advertiser> page = this.advertiserFeignService.getList(Integer.parseInt(param.get("pageNum") + ""), Integer.parseInt(param.get("pageSize") + ""), null, null, keywords, null, null, null, null, null, null, id, (byte)1).getReturnValue();
        ArrayList<AdvertiserVo> lists = new ArrayList<AdvertiserVo>();
        Pagination pageBean = new Pagination();
        pageBean.setTotalCount(Integer.parseInt(page.getTotal() + ""));
        pageBean.setPageNo(Integer.parseInt(page.getPageNum() + ""));
        pageBean.setPageSize(Integer.parseInt(page.getPageSize() + ""));
        List<Advertiser> listAdvertiser = page.getList();
        if (CollectionUtils.isNotEmpty(listAdvertiser)) {
            for (Advertiser advertiser : listAdvertiser) {
                AdvertiserVo advertiserVo = new AdvertiserVo();
                BeanUtils.copyProperties(advertiser, advertiserVo);
                lists.add(advertiserVo);
            }
        }
        pageBean.setList(lists);
        return pageBean;
    }

    public List<AdvertiserDto> findAdShopMsgs(String ids) throws IOException {
        List<AdvertiserVo> advList = this.advertiserFeignService.getListByIds(ids).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty(advList)) {
            for (AdvertiserVo advertiser : advList) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties(advertiser, advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public List<AdvertiserDto> findAdShopMsgsByKeywords(String keywords, String ae) throws IOException {
        List<AdvertiserVo> advList = this.advertiserFeignService.getListByKeywords(keywords, ae).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty(advList)) {
            for (AdvertiserVo advertiser : advList) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties(advertiser, advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public AdvertiserDto findAdShopMsg(long id) throws IOException {
        Advertiser advertiser = this.advertiserFeignService.getById((int)id).getReturnValue();
        AdvertiserDto advertiserDto = new AdvertiserDto();
        BeanUtils.copyProperties(advertiser, advertiserDto);
        return advertiserDto;
    }

    public boolean updateAdShopMsg(AdvertiserNewDto update) throws Exception {
        Advertiser advertiser = new Advertiser();
        BeanUtils.copyProperties(update, advertiser);
        boolean result = this.advertiserFeignService.updateByJson(advertiser).getReturnValue();
        return result;
    }

    public List<AdvertiserDto> getAdvertiserListById(Integer id) throws IOException {
        List<Advertiser> list = this.advertiserFeignService.getAdvertiserListById(id).getReturnValue();
        ArrayList<AdvertiserDto> lists = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Advertiser advertiser : list) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties(advertiser, advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public List<AdvertiserDto> findAdShopMsgsByKeywordsAndAe(String keywords, String ae) throws IOException {
        List<Advertiser> advList = this.advertiserFeignService.getListByKeywordsAndAe(keywords, ae).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty(advList)) {
            for (Advertiser advertiser : advList) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties(advertiser, advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }
}

