/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.app;

import com.alibaba.fastjson.JSON;
import com.bxm.app.facade.AppEntranceFacadeService;
import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.util.dto.ResultModel;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppEntranceFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(AppEntranceFacadeIntegration.class);
    @Resource
    private AppEntranceFacadeService appEntranceFacadeService;

    public Integer queryDockMethod(String appKey, String appEntranceId) {
        try {
            ResultModel<Integer> result = this.appEntranceFacadeService.queryDockMethod(appKey, appEntranceId);
            return result == null ? null : result.getReturnValue();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42app\u7cfb\u7edf\u67e5\u8be2dockMethod\u53d1\u751f\u5f02\u5e38:", e);
            return null;
        }
    }

    public List<QueryPositionIdAndNameVo> getPositionIdAndName(String keyWords, String appKey) {
        try {
            ResultModel<List<QueryPositionIdAndNameVo>> resultModel = this.appEntranceFacadeService.getPositionIdAndName(keyWords, appKey);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.warn(">>>>>>>>>request AppEntranceFacadeIntegration.getPositionIdAndName get result fail! {}-{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>request AppEntranceFacadeIntegration.getPositionIdAndName fail by exception:", e);
        }
        return Collections.emptyList();
    }

    public List<AppEntranceAdRo> getListByPositionIds(List<String> positionIds) {
        try {
            positionIds.remove(null);
            ResultModel<List<AppEntranceAdRo>> resultModel = this.appEntranceFacadeService.getListByPositionIds(JSON.toJSONString(positionIds));
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.warn(">>>>>>>>>request AppEntranceFacadeIntegration.getListByPositionIds get result fail! {}-{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>request AppEntranceFacadeIntegration.getListByPositionIds fail by exception:", e);
        }
        return Collections.emptyList();
    }
}

