/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.app;

import com.alibaba.fastjson.JSON;
import com.bxm.app.facade.ProviderAppFacadeService;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.util.dto.ResultModel;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProviderAppFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(ProviderAppFacadeIntegration.class);
    @Resource
    private ProviderAppFacadeService providerAppFacadeService;

    public List<ProviderAppAdRo> getListByAppNameOrAppkey(String keyWords) {
        try {
            ResultModel<List<ProviderAppAdRo>> resultModel = this.providerAppFacadeService.getListByAppNameOrAppkey(keyWords);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.warn(">>>>>>>>>request ProviderAppFacadeIntegration.getListByAppNameOrAppkey get result fail! {}-{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>request ProviderAppFacadeIntegration.getListByAppNameOrAppkey fail by exception:", e);
        }
        return Collections.emptyList();
    }

    public List<ProviderAppAdRo> getListByAppKeys(List<String> appKeys) {
        try {
            appKeys.remove(null);
            ResultModel<List<ProviderAppAdRo>> resultModel = this.providerAppFacadeService.getListByAppKeys(JSON.toJSONString(appKeys));
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.warn(">>>>>>>>>request AppEntranceFacadeIntegration.getListByAppKeys get result fail! {}-{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>request AppEntranceFacadeIntegration.getListByAppKeys fail by exception:", e);
        }
        return Collections.emptyList();
    }
}

