/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.datapark;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.activity.ActivityCountVo;
import com.bxm.datapark.facade.activity.ActivityReportDto;
import com.bxm.datapark.facade.activity.ActivityReportService;
import com.bxm.datapark.facade.activity.ActivityReportVo;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.resttemplate.RestTemplateClient;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkActivityPullerIntegration {
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private RestTemplateClient restTemplateClient;
    @Autowired
    private ActivityReportService activityReportService;
    @Resource
    private Mapper mapper;
    private static final Logger logger = Logger.getLogger(DataparkActivityPullerIntegration.class);

    public ResultModel pullNewActivityData(ActivityReportDto dto) {
        ResultModel<Page<ActivityReportVo>> resultModel = this.activityReportService.findActivityReportByParms(dto);
        return resultModel;
    }

    public List<ActivityReportVo> newActivityReportExport(ActivityReportDto dto) {
        ResultModel<List<ActivityReportVo>> listResultModel = this.activityReportService.newActivityReportExport(dto);
        return listResultModel.getReturnValue();
    }

    public ResultModel<Pagination> pullActivityData(ActivityReportRo activityReportRo, String json) {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        ActivityReportDto condition = this.mapper.map((Object)activityReportRo, ActivityReportDto.class);
        condition.setJson(json);
        ResultModel<Page<ActivityCountVo>> rs = this.activityReportService.activityReport(condition);
        return this.pullDataFromCloud(resultModel, rs);
    }

    public List<ActivityCount> activityReportExport(String datetime, String json) {
        ActivityReportDto condition = new ActivityReportDto();
        condition.setDatetime(datetime);
        condition.setJson(json);
        ResultModel<List<ActivityCountVo>> rs = this.activityReportService.activityReportExport(condition);
        return this.pullDataFromCloudForExport(rs);
    }

    public ResultModel activityReportApp(String datetime, String json, Long activityId, Integer pageSize, Integer pageNum, String sortName, String sortType) {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        ActivityReportDto condition = new ActivityReportDto();
        condition.setDatetime(datetime);
        condition.setActivityId(activityId);
        condition.setJson(json);
        condition.setPageSize(pageSize);
        condition.setPageNum(pageNum);
        condition.setSortName(sortName);
        condition.setSortType(sortType);
        ResultModel<Page<ActivityCountVo>> rs = this.activityReportService.activityAppReport(condition);
        return this.pullDataFromCloud(resultModel, rs);
    }

    private ResultModel<Pagination> pullDataFromCloud(ResultModel<Pagination> resultModel, ResultModel<Page<ActivityCountVo>> rs) {
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (page.getList() == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        if (null != page && null != page.getList() && page.getList().size() > 0) {
            List<ActivityCount> list = JSON.parseArray(page.getList().toString(), ActivityCount.class);
            page.setList(list);
        }
        Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    public List<ActivityCount> activityReportAppExport(String datetime, String json, Long activityId) {
        ActivityReportDto condition = new ActivityReportDto();
        condition.setDatetime(datetime);
        condition.setActivityId(activityId);
        condition.setJson(json);
        ResultModel<List<ActivityCountVo>> rs = this.activityReportService.activityAppReportExport(condition);
        return this.pullDataFromCloudForExport(rs);
    }

    private List<ActivityCount> pullDataFromCloudForExport(ResultModel<List<ActivityCountVo>> rs) {
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<ActivityCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
    }

    public ResultModel activityReportAppBusiness(String datetime, String json, Long activityId, String appKey, Integer pageSize, Integer pageNum, String sortName, String sortType) {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        ActivityReportDto condition = new ActivityReportDto();
        condition.setDatetime(datetime);
        condition.setActivityId(activityId);
        condition.setAppKeys(appKey);
        condition.setJson(json);
        condition.setPageSize(pageSize);
        condition.setPageNum(pageNum);
        condition.setSortName(sortName);
        condition.setSortType(sortType);
        ResultModel<Page<ActivityCountVo>> rs = this.activityReportService.activityAppBusinessReport(condition);
        return this.pullDataFromCloud(resultModel, rs);
    }

    public ResultModel pullData(ResultModel<Pagination> resultModel, String url, Map<String, Object> parm) {
        try {
            String result = this.restTemplateClient.getByParams(this.DATAPARKURL + url, parm, HttpMethod.POST, null);
            Page page = JSON.parseObject(JSON.parseObject(result).getString("returnValue"), Page.class);
            if (page == null || page.getList() == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            if (page.getSize() > 0) {
                List<ActivityCount> list = JSON.parseArray(page.getList().toString(), ActivityCount.class);
                page.setList(list);
            }
            Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
            resultModel.setReturnValue(pagination);
            return resultModel;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25url:+" + url + e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25");
            return resultModel;
        }
    }

    public List<ActivityCount> activityReportAppBusinessExport(String datetime, String json, Long activityId, String appKey) {
        ActivityReportDto dto = new ActivityReportDto();
        dto.setDatetime(datetime);
        dto.setActivityId(activityId);
        dto.setAppKeys(appKey);
        dto.setJson(json);
        ResultModel<List<ActivityCountVo>> rs = this.activityReportService.activityAppBusinessReportExport(dto);
        return this.pullDataFromCloudForExport(rs);
    }

    public List<ActivityCount> pullExportData(String url, Map<String, Object> parm) {
        List<ActivityCount> activityCounts = Lists.newArrayList();
        try {
            String result = this.restTemplateClient.getByParams(this.DATAPARKURL + url, parm, HttpMethod.POST, null);
            activityCounts = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
            return activityCounts;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u5f00\u53d1\u8005\u7ef4\u5ea6\u5bfc\u51fa\u63a5\u53e3\u5931\u8d25" + e.getMessage(), e);
            return activityCounts;
        }
    }

    public List<ActivityCount> activityReportByDate(String startTime, String endTime, Long activityId, String sortName, String sortType) {
        ActivityReportDto condition = new ActivityReportDto();
        condition.setStartTime(startTime);
        condition.setEndTime(endTime);
        condition.setActivityId(activityId);
        condition.setSortType(sortType);
        condition.setSortName(sortName);
        ResultModel<List<ActivityCountVo>> rs = this.activityReportService.activityDateReport(condition);
        return this.pullDataFromCloudForExport(rs);
    }

    public List<ActivityCount> activityReportBusinessByDate(String startTime, String endTime, Long activityId, String appKey, String business, String sortName, String sortType) {
        ActivityReportDto condition = new ActivityReportDto();
        condition.setStartTime(startTime);
        condition.setEndTime(endTime);
        condition.setActivityId(activityId);
        condition.setSortType(sortType);
        condition.setSortName(sortName);
        condition.setAppKeys(appKey);
        condition.setBusiness(business);
        ResultModel<List<ActivityCountVo>> rs = this.activityReportService.activityAppBusinessDateReport(condition);
        return this.pullDataFromCloudForExport(rs);
    }
}

