/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.datapark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.datapark.facade.Page;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.release.AnalysisDateAdvertisingDate;
import com.bxm.report.model.release.AnalysisDateAppOs;
import com.bxm.report.model.release.AnalysisDateArea;
import com.bxm.report.model.release.AnalysisDateMedaVo;
import com.bxm.report.model.release.AnalysisDatePayWay;
import com.bxm.report.model.release.AnalysisDateVo;
import com.bxm.report.model.resttemplate.RestTemplateClient;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkAnalysisDatePullerIntegration {
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private RestTemplateClient restTemplateClient;
    private static final Logger logger = Logger.getLogger(DataparkAnalysisDatePullerIntegration.class);

    public ResultModel pullAnalysisPutDateCount(Map<String, Object> map) {
        Map<String, Object> parm = map;
        ResultModel resultModel = new ResultModel();
        resultModel = this.pullAnalysisDatePullerData(resultModel, "/analysis/find/AllList", parm);
        return resultModel;
    }

    public ResultModel pullAnalysisDatePpropertyListData(Map<String, Object> map) {
        Map<String, Object> parm = map;
        ResultModel resultModel = new ResultModel();
        resultModel = this.pullAnalysisDateJSONArryData(resultModel, "/analysis/find/propertyArays", parm);
        return resultModel;
    }

    private ResultModel pullAnalysisDateJSONArryData(ResultModel<JSONObject> resultModel, String url, Map<String, Object> parm) {
        try {
            String result = this.restTemplateClient.getByParams(this.DATAPARKURL + url, parm, HttpMethod.POST, null);
            JSONObject jsonObject = JSON.parseObject(JSON.parseObject(result).getString("returnValue"), JSONObject.class);
            resultModel.setReturnValue(jsonObject);
            return resultModel;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25url:+" + url + e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25");
            return resultModel;
        }
    }

    private ResultModel pullAnalysisDatePullerData(ResultModel<Pagination> resultModel, String url, Map<String, Object> parm) {
        try {
            String result = this.restTemplateClient.getByParams(this.DATAPARKURL + url, parm, HttpMethod.POST, null);
            Page page = JSON.parseObject(JSON.parseObject(result).getString("returnValue"), Page.class);
            if (page == null || page.getList() == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            if (page.getList().size() > 0) {
                List<AnalysisDateVo> list = null;
                list = "2".equals(parm.get("type")) ? JSON.parseArray(page.getList().toString(), AnalysisDateMedaVo.class) : ("4".equals(parm.get("type")) ? JSON.parseArray(page.getList().toString(), AnalysisDateArea.class) : ("3".equals(parm.get("type")) ? JSON.parseArray(page.getList().toString(), AnalysisDateAdvertisingDate.class) : ("5".equals(parm.get("type")) ? JSON.parseArray(page.getList().toString(), AnalysisDateAppOs.class) : ("6".equals(parm.get("type")) ? JSON.parseArray(page.getList().toString(), AnalysisDatePayWay.class) : JSON.parseArray(page.getList().toString(), AnalysisDateVo.class)))));
                page.setList(list);
            }
            page.getList().stream().forEach(vo -> {
                if (vo.getNumber() != null && vo.getNumber().equals("\u5408\u8ba1")) {
                    vo.setDisplayName(vo.getNumber());
                } else {
                    vo.setDisplayName(StringUtil.isEmpty(vo.getId()) ? "\u672a\u77e5" : vo.getId());
                }
                this.setbusinessDisplayName((AnalysisDateVo)vo, parm);
            });
            Pagination pagination = new Pagination(page.getPageNum(), page.getPageSize(), page.getTotal().intValue(), page.getList());
            resultModel.setReturnValue(pagination);
            return resultModel;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25url:+" + url + e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25");
            return resultModel;
        }
    }

    public void setbusinessDisplayName(AnalysisDateVo vo, Map<String, Object> parm) {
        if ("5".equals(parm.get("type"))) {
            if (vo.getId() == null) {
                return;
            }
            if (vo.getId().equals("1")) {
                vo.setDisplayName("\u5b89\u5353");
            } else if (vo.getId().equals("2")) {
                vo.setDisplayName("IOS");
            } else if (vo.getId().equals("3")) {
                vo.setDisplayName("Web");
            }
        } else if ("6".equals(parm.get("type"))) {
            if (vo.getId() == null) {
                return;
            }
            if (vo.getId().equals("1")) {
                vo.setDisplayName("\u5fae\u4fe1");
            } else if (vo.getId().equals("2")) {
                vo.setDisplayName("\u652f\u4ed8\u5b9d");
            } else if (vo.getId().equals("0")) {
                vo.setDisplayName("\u5176\u4ed6");
            } else {
                vo.setDisplayName("\u672a\u77e5");
            }
        }
    }
}

