/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.datapark;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.app.model.vo.AppCountVo;
import com.bxm.datapark.facade.app.service.AppDataReportService;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.dao.appcount.AppCount;
import com.bxm.report.model.resttemplate.RestTemplateClient;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkAppPullerIntegration {
    @Autowired
    private RestTemplateClient restTemplateClient;
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private AppDataReportService appDataReportService;

    public Page<AppCount> getAppCountPage(String datetime, Integer pageSize, Integer pageNum, String sortName, String sortType, String appKeysJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).json(appKeysJson).build();
        ResultModel<Page<AppCountVo>> rs = this.appDataReportService.appReport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<AppCount>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<AppCount> list = JSON.parseArray(page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    public List<AppCount> getAppCountVos(String datetime, String sortName, String sortType, String appKeysJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).sortName(sortName).sortType(sortType).json(appKeysJson).build();
        ResultModel<List<AppCountVo>> rs = this.appDataReportService.appReportExport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        List<AppCount> list = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
        if (CollectionUtils.isEmpty(list)) {
            new ArrayList();
        }
        return list;
    }

    public Page<AppCount> getAppBusinessCountVoPage(String datetime, String appKey, Integer pageSize, Integer pageNum, String sortName, String sortType, String appBusinessesJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).json(appBusinessesJson).build();
        ResultModel<Page<AppCountVo>> rs = this.appDataReportService.appBusinessReport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<AppCount>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<AppCount> list = JSON.parseArray(page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    public List<AppCount> getAppBusinessCountVos(String datetime, String appKey, String sortName, String sortType, String appBusinessesJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).sortName(sortName).sortType(sortType).json(appBusinessesJson).build();
        ResultModel<List<AppCountVo>> rs = this.appDataReportService.appBusinessReportExport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppBusinessCountVosBydatime(String datetime) throws IOException {
        String result;
        HashMap<String, Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)) {
            maps.put("datetime", datetime);
        }
        if (JSON.parseObject(result = this.restTemplateClient.getByParams(this.DATAPARKURL + "/app/business/profit", maps, HttpMethod.POST, null)).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppDateVos(String appKey, String startTime, String endTime, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).appKey(appKey).sortName(sortName).sortType(sortType).build();
        ResultModel<List<AppCountVo>> rs = this.appDataReportService.appDateReport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppAppBusinessDateVos(String appKey, String business, String startTime, String endTime, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).appKey(appKey).business(business).sortName(sortName).sortType(sortType).build();
        ResultModel<List<AppCountVo>> rs = this.appDataReportService.appBusinessDateReport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public Page<TicketCountCommon> getAppTicketCount(String datetime, String appKey, Integer scene, String json, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).scene(scene).appKey(appKey).pageNum(pageNum).pageSize(pageSize).json(json).sortName(sortName).sortType(sortType).build();
        String result = JSON.toJSONString(this.appDataReportService.appTicketReport(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getAppTicketCount(String datetime, String appKey, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).scene(scene).json(json).build();
        String result = JSON.toJSONString(this.appDataReportService.appTicketReportExport(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getAppTicketCountDate(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType) throws IOException {
        return this.getAppBusinessTicketDateReport(startTime, endTime, appKey, certificateid, sortName, sortType, null);
    }

    public Page<TicketCountCommon> getAppBusinessTicketCount(String datetime, String appKey, String business, Integer scene, String json, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).scene(scene).business(business).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).appKey(appKey).json(json).build();
        String result = JSON.toJSONString(this.appDataReportService.appTicketReport(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getAppBusinessTicketExport(String datetime, String appKey, String business, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).scene(scene).business(business).appKey(appKey).json(json).build();
        String result = JSON.toJSONString(this.appDataReportService.appTicketReportExport(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public ResultModel appBusinessActivity(String json, String datetime, String appKey, String business, String activityType, String activityPlanner, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).json(json).appKey(appKey).business(business).activityType(activityType).activityPlanner(activityPlanner).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        String result = JSON.toJSONString(this.appDataReportService.appBusinessActivity(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (page.getList() == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        if (page.getSize() > 0) {
            List<ActivityCount> list = JSON.parseArray(page.getList().toString(), ActivityCount.class);
            page.setList(list);
        }
        Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    public List<ActivityCount> appBusinessActivityExport(String json, String datetime, String appKey, String business) throws IOException {
        ResultModel resultModel = new ResultModel();
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).json(json).appKey(appKey).business(business).build();
        String result = JSON.toJSONString(this.appDataReportService.appBusinessActivityExport(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<ActivityCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), ActivityCount.class);
    }

    public List<TicketCountCommon> getAppTicketCountWeight(String datetime, String json) throws IOException {
        String result;
        HashMap<String, Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)) {
            maps.put("datetime", datetime);
        }
        if (StringUtils.isNotEmpty(json)) {
            maps.put("json", json);
        }
        if (JSON.parseObject(result = this.restTemplateClient.getByParams(this.DATAPARKURL + "/ticket/weight", maps, HttpMethod.POST, null)).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public List<AppCount> getAppCountVosSum(String startTime, String endTime, String sortName, String sortType, String appKeysJson) throws Exception {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).sortName(sortName).sortType(sortType).json(appKeysJson).build();
        ResultModel<List<AppCountVo>> rs = this.appDataReportService.appSumReport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public List<AppCount> appCountVosSumExport(String startTime, String endTime, String appKeysJson) throws Exception {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).json(appKeysJson).build();
        ResultModel<List<AppCountVo>> rs = this.appDataReportService.appSumReport(dto);
        String result = JSON.toJSONString(rs);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), AppCount.class);
    }

    public List<TicketCountCommon> getAppBusinessTicketDateReport(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType, String business) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).business(business).appKey(appKey).certificateid(certificateid).sortName(sortName).sortType(sortType).build();
        String result = JSON.toJSONString(this.appDataReportService.appTicketDateReport(dto));
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }
}

