/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.datapark;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AnalysisParamsDTO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisAppOSVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisMediaVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisPaymentTypeVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisRegionVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTagTypeVO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.AnalysisTrendVO;
import com.bxm.datapark.facade.ticket.service.TicketAnalysisService;
import com.bxm.util.dto.ResultModel;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkTicketAnalysisIntegration {
    private static final Logger log = LoggerFactory.getLogger(DataparkTicketAnalysisIntegration.class);
    @Autowired
    private TicketAnalysisService ticketAnalysisService;

    public Page<AnalysisTrendVO> trend(AnalysisParamsDTO paramsDTO) {
        ResultModel<Page<AnalysisTrendVO>> resultModel;
        try {
            long start = System.currentTimeMillis();
            resultModel = this.ticketAnalysisService.trend(paramsDTO);
            log.info(">>>>>>>>>request analysis by trend time consuming : {}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>request analysis by trend fail, " + JSON.toJSONString(resultModel));
    }

    public Page<AnalysisMediaVO> media(AnalysisParamsDTO paramsDTO) {
        ResultModel<Page<AnalysisMediaVO>> resultModel;
        try {
            long start = System.currentTimeMillis();
            resultModel = this.ticketAnalysisService.media(paramsDTO);
            log.info(">>>>>>>>>request analysis by media time consuming : {}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>request analysis by media fail, " + JSON.toJSONString(resultModel));
    }

    public Page<AnalysisRegionVO> region(AnalysisParamsDTO paramsDTO) {
        ResultModel<Page<AnalysisRegionVO>> resultModel;
        try {
            long start = System.currentTimeMillis();
            resultModel = this.ticketAnalysisService.region(paramsDTO);
            log.info(">>>>>>>>>request analysis by region time consuming : {}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>request analysis by region fail, " + JSON.toJSONString(resultModel));
    }

    public Page<AnalysisTagTypeVO> tagType(AnalysisParamsDTO paramsDTO) {
        ResultModel<Page<AnalysisTagTypeVO>> resultModel;
        try {
            long start = System.currentTimeMillis();
            resultModel = this.ticketAnalysisService.tagType(paramsDTO);
            log.info(">>>>>>>>>request analysis by tagType time consuming : {}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>request analysis by tagType fail, " + JSON.toJSONString(resultModel));
    }

    public Page<AnalysisAppOSVO> appOS(AnalysisParamsDTO paramsDTO) {
        ResultModel<Page<AnalysisAppOSVO>> resultModel;
        try {
            long start = System.currentTimeMillis();
            resultModel = this.ticketAnalysisService.appOS(paramsDTO);
            log.info(">>>>>>>>>request analysis by appOS time consuming : {}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>analysis by appOS fail, " + JSON.toJSONString(resultModel));
    }

    public Page<AnalysisPaymentTypeVO> paymentType(AnalysisParamsDTO paramsDTO) {
        ResultModel<Page<AnalysisPaymentTypeVO>> resultModel;
        try {
            long start = System.currentTimeMillis();
            resultModel = this.ticketAnalysisService.paymentType(paramsDTO);
            log.info(">>>>>>>>>request analysis by paymentType time consuming : {}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>request analysis by paymentType fail, " + JSON.toJSONString(resultModel));
    }

    public Map<String, Map<String, Double>> commonAnalysisChat(AnalysisParamsDTO paramsDTO, String analysisType) {
        ResultModel<Map<String, Map<String, Double>>> resultModel;
        try {
            long start = System.currentTimeMillis();
            switch (analysisType) {
                case "TREND": {
                    resultModel = this.ticketAnalysisService.trendChart(paramsDTO);
                    break;
                }
                case "MEDIA": {
                    resultModel = this.ticketAnalysisService.mediaChart(paramsDTO);
                    break;
                }
                case "TAG_TYPE": {
                    resultModel = this.ticketAnalysisService.tagTypeChart(paramsDTO);
                    break;
                }
                case "REGION": {
                    resultModel = this.ticketAnalysisService.regionChart(paramsDTO);
                    break;
                }
                case "APP_OS": {
                    resultModel = this.ticketAnalysisService.appOSChart(paramsDTO);
                    break;
                }
                case "PAYMENT_TYPE": {
                    resultModel = this.ticketAnalysisService.paymentTypeChart(paramsDTO);
                    break;
                }
                default: {
                    return Collections.emptyMap();
                }
            }
            log.info(">>>>>>>>>request analysis chat by {} time consuming : {}", (Object)analysisType, (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resultModel.isSuccessed()) {
            return resultModel.getReturnValue();
        }
        throw new RuntimeException(">>>>>>>>>>request analysis chart by " + analysisType + " fail, " + JSON.toJSONString(resultModel));
    }
}

