/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.facade.datapark;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.datapark.facade.ticket.model.dto.TicketUrlDto;
import com.bxm.datapark.facade.ticket.model.vo.TicketCountCommonVo;
import com.bxm.datapark.facade.ticket.model.vo.TicketUrlVo;
import com.bxm.datapark.facade.ticket.service.TicketDataReportSevice;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.adticket.TicketCountCommon;
import com.bxm.report.model.resttemplate.RestTemplateClient;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkTicketPullerIntegration {
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private RestTemplateClient restTemplateClient;
    @Autowired
    private TicketDataReportSevice ticketDataReportSevice;
    private static final Logger logger = Logger.getLogger(DataparkTicketPullerIntegration.class);

    public ResultModel ticketData(Long certificateid, String appkey, String business, String datetime, Integer sHour, Integer eHour, Integer pageSize, Integer pageNum, String sortName, String sortType) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).sHour(sHour).eHour(eHour).appKey(appkey).business(business).certificateid(certificateid).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        return this.pullTicketData(dto);
    }

    private void calOpenPvRate(List<TicketCountCommon> ticketCountCommonList) {
        if (CollectionUtils.isNotEmpty(ticketCountCommonList)) {
            int countOpenPv = 1;
            for (int i = 0; i < ticketCountCommonList.size(); ++i) {
                if (i == 0) {
                    TicketCountCommon count = ticketCountCommonList.get(i);
                    countOpenPv = count.getOpenPv();
                    continue;
                }
                TicketCountCommon ticketCountCommon = ticketCountCommonList.get(i);
                int openPv = ticketCountCommon.getOpenPv();
                if (countOpenPv > 0) {
                    BigDecimal pvRate = new BigDecimal(openPv).multiply(new BigDecimal(100)).divide(new BigDecimal(countOpenPv), 2, 5);
                    ticketCountCommon.setOpenPvRate(pvRate.doubleValue());
                    continue;
                }
                ticketCountCommon.setOpenPvRate(0.0);
            }
        }
    }

    public List<TicketCountCommon> ticketHoursExport(String datetime, Long certificateid, String appkey, String business, Integer sHour, Integer eHour) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).sHour(sHour).eHour(eHour).appKey(appkey).business(business).certificateid(certificateid).build();
        List<TicketCountCommon> ticketCountCommonList = this.ticketDateExport(dto);
        return ticketCountCommonList;
    }

    public ResultModel pullTicketData(AppBusinessTicketDto dto) {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        try {
            ResultModel<Page<TicketCountCommonVo>> rs = this.ticketDataReportSevice.ticketHourReport(dto);
            String result = JSON.toJSONString(rs);
            if (JSON.parseObject(result).get("returnValue") == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
            if (page.getList() == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            if (page.getSize() > 0) {
                List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
                this.calOpenPvRate(list);
                page.setList(list);
            }
            Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
            resultModel.setReturnValue(pagination);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25pullTicketData:+" + e.getMessage(), e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25");
        }
        return resultModel;
    }

    public List<TicketCountCommon> ticketDateExport(AppBusinessTicketDto dto) {
        try {
            ResultModel<List<TicketCountCommonVo>> rs = this.ticketDataReportSevice.ticketHourReportExport(dto);
            String result = JSON.toJSONString(rs);
            if (JSON.parseObject(result).get("returnValue") == null) {
                return new ArrayList<TicketCountCommon>();
            }
            List<TicketCountCommon> list = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
            if (list.size() > 0) {
                return list;
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25" + e.getMessage(), e);
        }
        return new ArrayList<TicketCountCommon>();
    }

    public Page<TicketCountCommon> getTicketCount(String datetime, Integer scene, String json, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().scene(scene).datetime(datetime).json(json).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        ResultModel<Page<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketReport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketCount(String datetime, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().scene(scene).datetime(datetime).json(json).build();
        ResultModel<List<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketReportExport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue").toString() == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getTicketAppCount(String datetime, Long certificateid, String json, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).json(json).certificateid(certificateid).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        ResultModel<Page<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketReport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketAppCount(String datetime, Long certificateid, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().certificateid(certificateid).datetime(datetime).json(json).build();
        ResultModel<List<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketReportExport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getTicketAppBusinessCount(String datetime, Long certificateid, String appKey, String json, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).json(json).certificateid(certificateid).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).build();
        ResultModel<Page<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketReport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketAppBusinessCount(String datetime, Long certificateid, String appKey, String json) throws IOException {
        String result;
        HashMap<String, Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(datetime)) {
            maps.put("datetime", datetime);
        }
        if (certificateid != null) {
            maps.put("certificateid", certificateid);
        }
        if (StringUtils.isNotEmpty(appKey)) {
            maps.put("appkey", appKey);
        }
        if (StringUtils.isNotEmpty(json)) {
            maps.put("json", json);
        }
        if (JSON.parseObject(result = this.restTemplateClient.getByParams(this.DATAPARKURL + "/ticket/profit", maps, HttpMethod.POST, null)).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getTicketCountDate(String startTime, String endTime, Long certificateid, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).certificateid(certificateid).sortName(sortName).sortType(sortType).build();
        ResultModel<List<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketDateReport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getTicketAppBusinessCountNew(String datetime, Long certificateid, String appKey, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).json(json).certificateid(certificateid).build();
        ResultModel<List<TicketCountCommonVo>> resultModel = this.ticketDataReportSevice.ticketReportExport(dto);
        String result = JSON.toJSONString(resultModel);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public ResultModel<Page<TicketUrlVo>> analysisTicketUrl(TicketUrlDto param) {
        return this.ticketDataReportSevice.analysisTicketUrl(param);
    }
}

