/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect.helper;

import com.github.pagehelper.Page;
import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.cache.CacheFactory;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.parser.SqlServerParser;
import com.github.pagehelper.util.StringUtil;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public class SqlServerDialect
extends AbstractHelperDialect {
    protected SqlServerParser pageSql = new SqlServerParser();
    protected Cache<String, String> CACHE_COUNTSQL;
    protected Cache<String, String> CACHE_PAGESQL;
    protected String WITHNOLOCK = ", PAGEWITHNOLOCK";

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        String cacheSql = this.CACHE_COUNTSQL.get(sql);
        if (cacheSql != null) {
            return cacheSql;
        }
        cacheSql = sql;
        cacheSql = cacheSql.replaceAll("((?i)with\\s*\\(nolock\\))", this.WITHNOLOCK);
        cacheSql = this.countSqlParser.getSmartCountSql(cacheSql);
        cacheSql = cacheSql.replaceAll(this.WITHNOLOCK, " with(nolock)");
        this.CACHE_COUNTSQL.put(sql, cacheSql);
        return cacheSql;
    }

    @Override
    public String getPageSql(String sql, Page page, CacheKey pageKey) {
        pageKey.update((Object)page.getStartRow());
        pageKey.update((Object)page.getPageSize());
        String cacheSql = this.CACHE_PAGESQL.get(sql);
        if (cacheSql == null) {
            cacheSql = sql;
            cacheSql = cacheSql.replaceAll("((?i)with\\s*\\(nolock\\))", this.WITHNOLOCK);
            cacheSql = this.pageSql.convertToPageSql(cacheSql, null, null);
            cacheSql = cacheSql.replaceAll(this.WITHNOLOCK, " with(nolock)");
            this.CACHE_PAGESQL.put(sql, cacheSql);
        }
        cacheSql = cacheSql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(page.getStartRow()));
        cacheSql = cacheSql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(page.getPageSize()));
        return cacheSql;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String sqlCacheClass = properties.getProperty("sqlCacheClass");
        if (StringUtil.isNotEmpty(sqlCacheClass) && !sqlCacheClass.equalsIgnoreCase("false")) {
            this.CACHE_COUNTSQL = CacheFactory.createCache(sqlCacheClass, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(sqlCacheClass, "page", properties);
        } else {
            this.CACHE_COUNTSQL = CacheFactory.createCache(null, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(null, "page", properties);
        }
    }
}

