/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.servo.monitor.Monitors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.RetryableRibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.apache.http.client.HttpClient"})
@ConditionalOnProperty(name={"ribbon.httpclient.enabled"}, matchIfMissing=true)
public class HttpClientRibbonConfiguration {
    @Value(value="${ribbon.client.name}")
    private String name = "client";

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
    public RibbonLoadBalancingHttpClient ribbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler) {
        RibbonLoadBalancingHttpClient client = new RibbonLoadBalancingHttpClient(config, serverIntrospector);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    public RetryableRibbonLoadBalancingHttpClient retryableRibbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        RetryableRibbonLoadBalancingHttpClient client = new RetryableRibbonLoadBalancingHttpClient(config, serverIntrospector, loadBalancedRetryPolicyFactory);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }
}

