/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.report.service.activity.impl;

import com.bxm.dao.adkeeper.AdPopupMapper;
import com.bxm.datapark.facade.adpopup.model.ro.PopupStyleRo;
import com.bxm.datapark.facade.adpopup.model.vo.PopupStyleVo;
import com.bxm.report.facade.constant.PopupStyleIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.dao.popup.AdPopup;
import com.bxm.report.model.ro.PopupRo;
import com.bxm.report.model.vo.activity.PopupVo;
import com.bxm.report.service.activity.ActivityStatisticService;
import com.bxm.report.service.utils.DoubleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dozer.Mapper;
import org.springframework.stereotype.Service;

@Service
public class ActivityStatisticServiceImpl
implements ActivityStatisticService {
    @Resource
    private AdPopupMapper adPopupMapper;
    @Resource
    private PopupStyleIntegration popupStyleIntegration;
    @Resource
    private Mapper mapper;

    @Override
    public Pagination getList(PopupRo popupRo) {
        if (popupRo.getPopupType() == null) {
            throw new RuntimeException("\u6837\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        popupRo.setPageSize(Integer.valueOf(popupRo.getPageSize() > 50 ? 50 : popupRo.getPageSize()));
        Pagination pagination = new Pagination();
        pagination.setPageNo(popupRo.getPageNum());
        pagination.setPageSize(Integer.valueOf(pagination.getPageSize()));
        pagination.setTotalCount(this.adPopupMapper.countByRo(popupRo).intValue());
        if (pagination.getTotalCount() == 0) {
            return pagination;
        }
        popupRo.setSkip(Integer.valueOf(popupRo.getPageSize() * (popupRo.getPageNum() - 1)));
        List popIds = this.adPopupMapper.queryPopIdsByRo(popupRo);
        if (popIds.isEmpty()) {
            return pagination;
        }
        List adPopups = this.adPopupMapper.queryIdsAndPopIdsByPopId(popupRo, popIds);
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (AdPopup adPopup : adPopups) {
            map.put(adPopup.getId(), adPopup.getPopupId());
        }
        PopupStyleRo ro = (PopupStyleRo)this.mapper.map((Object)popupRo, PopupStyleRo.class);
        ro.setIds(map);
        Map resultMap = this.popupStyleIntegration.queryListByRo(ro);
        if (resultMap == null) {
            return pagination;
        }
        ArrayList<PopupVo> list = new ArrayList<PopupVo>();
        for (String popId : popIds) {
            PopupStyleVo popupStyleVo = (PopupStyleVo)resultMap.get(popId);
            if (popupStyleVo == null) continue;
            PopupVo popupVo = (PopupVo)this.mapper.map((Object)popupStyleVo, PopupVo.class);
            popupVo.setClickPercent(DoubleUtil.percent(popupVo.getClickRate()));
            list.add(popupVo);
        }
        pagination.setList(list);
        return pagination;
    }
}

